/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.map;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyHandler;
import io.undertow.server.handlers.proxy.SimpleProxyClientProvider;
import jakarta.ws.rs.core.UriBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import org.openremote.container.util.MapAccess;
import org.openremote.container.web.WebService;
import org.openremote.manager.app.ConfigurationService;
import org.openremote.manager.map.MapResourceImpl;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.manager.MapConfig;
import org.openremote.model.manager.MapSourceConfig;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;
import org.sqlite.JDBC;

public class MapService
implements ContainerService {
    public static final String MAP_SHARED_DATA_BASE_URI = "/shared";
    public static final String OR_MAP_TILESERVER_HOST = "OR_MAP_TILESERVER_HOST";
    public static final String OR_MAP_TILESERVER_HOST_DEFAULT = null;
    public static final String OR_MAP_TILESERVER_PORT = "OR_MAP_TILESERVER_PORT";
    public static final int OR_MAP_TILESERVER_PORT_DEFAULT = 8082;
    public static final String OR_CUSTOM_MAP_SIZE_LIMIT = "OR_CUSTOM_MAP_SIZE_LIMIT";
    public static final int OR_CUSTOM_MAP_SIZE_LIMIT_DEFAULT = 30000000;
    public static final String RASTER_MAP_TILE_PATH = "/raster_map/tile";
    public static final String TILESERVER_TILE_PATH = "/styles/standard";
    public static final String OR_MAP_TILESERVER_REQUEST_TIMEOUT = "OR_MAP_TILESERVER_REQUEST_TIMEOUT";
    public static final int OR_MAP_TILESERVER_REQUEST_TIMEOUT_DEFAULT = 10000;
    public static final String OR_PATH_PREFIX = "OR_PATH_PREFIX";
    public static final String OR_PATH_PREFIX_DEFAULT = "";
    private static final Logger LOG = Logger.getLogger(MapService.class.getName());
    private static final String DEFAULT_VECTOR_TILES_URL = "mbtiles://mapdata.mbtiles";
    private static ConfigurationService configurationService;
    protected Connection connection;
    protected Metadata metadata;
    protected ObjectNode mapConfig;
    protected ConcurrentMap<String, ObjectNode> mapSettings = new ConcurrentHashMap<String, ObjectNode>();
    protected ConcurrentMap<String, ObjectNode> mapSettingsJs = new ConcurrentHashMap<String, ObjectNode>();
    protected String pathPrefix;
    protected int customMapLimit = 30000000;

    public ObjectNode saveMapConfig(MapConfig mapConfiguration) throws RuntimeException {
        if (this.mapConfig == null) {
            this.mapConfig = ValueUtil.JSON.createObjectNode();
        }
        ObjectNode vectorTiles = (ObjectNode)ValueUtil.JSON.valueToTree(mapConfiguration.sources.get("vector_tiles"));
        String tileUrl = Optional.ofNullable(vectorTiles.get("tiles")).map(tiles -> tiles.get(0)).filter(JsonNode::isTextual).map(JsonNode::textValue).orElse(null);
        if (vectorTiles.get("custom").booleanValue() && tileUrl != null && tileUrl.contains("/{z}/{x}/{y}")) {
            vectorTiles.put("url", tileUrl);
        } else {
            vectorTiles = ValueUtil.JSON.createObjectNode().put("type", "vector").put("url", DEFAULT_VECTOR_TILES_URL);
        }
        mapConfiguration.sources.put("vector_tiles", (MapSourceConfig)ValueUtil.JSON.convertValue((Object)vectorTiles, MapSourceConfig.class));
        this.mapConfig.putPOJO("options", (Object)mapConfiguration.options);
        this.mapConfig.putPOJO("sources", (Object)mapConfiguration.sources);
        configurationService.saveMapConfig(this.mapConfig);
        this.mapConfig = configurationService.getMapConfig();
        this.mapSettings.clear();
        return this.mapConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Metadata getMetadata(Connection connection) {
        Metadata metadata;
        ResultSet result;
        PreparedStatement query;
        block8: {
            HashMap<String, String> resultMap;
            block7: {
                query = null;
                result = null;
                metadata = null;
                query = connection.prepareStatement("select NAME, VALUE from METADATA");
                result = query.executeQuery();
                resultMap = new HashMap<String, String>();
                while (result.next()) {
                    resultMap.put(result.getString(1), result.getString(2));
                }
                if (!resultMap.isEmpty()) break block7;
                Metadata metadata2 = new Metadata();
                MapService.closeQuietly(query, result);
                return metadata2;
            }
            try {
                ArrayNode bounds;
                String attribution = (String)resultMap.get("attribution");
                int maxZoom = Integer.parseInt((String)resultMap.get("maxzoom"));
                int minZoom = Integer.parseInt((String)resultMap.get("minzoom"));
                ArrayNode vectorLayer = resultMap.containsKey("json") ? (ArrayNode)ValueUtil.JSON.readTree((String)resultMap.get("json")).get("vector_layers") : null;
                ArrayNode center = resultMap.containsKey("center") ? (ArrayNode)ValueUtil.JSON.readTree("[" + (String)resultMap.get("center") + "]") : null;
                ArrayNode arrayNode = bounds = resultMap.containsKey("bounds") ? (ArrayNode)ValueUtil.JSON.readTree("[" + (String)resultMap.get("bounds") + "]") : null;
                if (!TextUtil.isNullOrEmpty((String)attribution) && vectorLayer != null && !vectorLayer.isEmpty() && maxZoom > 0) {
                    metadata = new Metadata(attribution, vectorLayer, bounds, center, maxZoom, minZoom);
                    break block8;
                }
                metadata = new Metadata();
                LOG.log(Level.SEVERE, "Required metadata missing in mbtiles DB");
            }
            catch (Exception ex) {
                try {
                    metadata = new Metadata();
                    LOG.log(Level.SEVERE, "Failed to get metadata from mbtiles DB", ex);
                }
                catch (Throwable throwable) {
                    MapService.closeQuietly(query, result);
                    throw throwable;
                }
                MapService.closeQuietly(query, result);
            }
        }
        MapService.closeQuietly(query, result);
        return metadata;
    }

    protected static void closeQuietly(PreparedStatement query, ResultSet result) {
        try {
            if (result != null) {
                result.close();
            }
            if (query != null) {
                query.close();
            }
        }
        catch (Exception ex) {
            LOG.warning("Error closing query/result: " + String.valueOf(ex));
        }
    }

    public void init(Container container) throws Exception {
        configurationService = (ConfigurationService)container.getService(ConfigurationService.class);
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new MapResourceImpl(this, (ManagerIdentityService)container.getService(ManagerIdentityService.class)));
        String tileServerHost = MapAccess.getString((Map)container.getConfig(), (String)OR_MAP_TILESERVER_HOST, (String)OR_MAP_TILESERVER_HOST_DEFAULT);
        int tileServerPort = MapAccess.getInteger((Map)container.getConfig(), (String)OR_MAP_TILESERVER_PORT, (int)8082);
        this.pathPrefix = MapAccess.getString((Map)container.getConfig(), (String)OR_PATH_PREFIX, (String)OR_PATH_PREFIX_DEFAULT);
        this.customMapLimit = MapAccess.getInteger((Map)container.getConfig(), (String)OR_CUSTOM_MAP_SIZE_LIMIT, (int)30000000);
        if (!TextUtil.isNullOrEmpty((String)tileServerHost)) {
            WebService webService = (WebService)container.getService(WebService.class);
            UriBuilder tileServerUri = UriBuilder.fromPath((String)"/").scheme("http").host(tileServerHost).port(tileServerPort);
            ProxyHandler proxyHandler = new ProxyHandler((ProxyClient)new SimpleProxyClientProvider(tileServerUri.build(new Object[0])), MapAccess.getInteger((Map)container.getConfig(), (String)OR_MAP_TILESERVER_REQUEST_TIMEOUT, (int)10000), (HttpHandler)ResponseCodeHandler.HANDLE_404).setReuseXForwarded(true);
            HttpHandler proxyWrapper = exchange -> {
                String path = exchange.getRequestPath().substring(RASTER_MAP_TILE_PATH.length());
                exchange.setRequestURI(TILESERVER_TILE_PATH + path, true);
                exchange.setRequestPath(TILESERVER_TILE_PATH + path);
                exchange.setRelativePath(TILESERVER_TILE_PATH + path);
                proxyHandler.handleRequest(exchange);
            };
            webService.getRequestHandlers().add(0, WebService.pathStartsWithHandler((String)"Raster Map Tile Proxy", (String)RASTER_MAP_TILE_PATH, (HttpHandler)proxyWrapper));
        }
    }

    public void start(Container container) throws Exception {
        this.setData(false);
    }

    public Path setData(boolean skipCustom) {
        Path connectedFile;
        block26: {
            block25: {
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (SQLException e) {
                    LOG.log(Level.WARNING, "Could not close existing connection", e);
                }
                connectedFile = null;
                if (!skipCustom) {
                    try {
                        Path customMapTilesPath = configurationService.getCustomMapTilesPath(true);
                        if (!customMapTilesPath.toFile().isFile()) break block25;
                        Class.forName(JDBC.class.getName());
                        this.connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(customMapTilesPath));
                        this.metadata = MapService.getMetadata(this.connection);
                        if (!this.metadata.isValid()) {
                            LOG.warning("Custom map meta data could not be loaded, falling back to default map");
                            try {
                                if (this.connection != null) {
                                    this.connection.close();
                                }
                                break block25;
                            }
                            catch (SQLException e) {
                                LOG.log(Level.WARNING, "Could not close connection", e);
                            }
                            break block25;
                        }
                        connectedFile = customMapTilesPath;
                    }
                    catch (IOException | ClassNotFoundException | SQLException e) {
                        LOG.log(Level.WARNING, "An error occurred whilst trying to load custom map tiles file", e);
                    }
                }
            }
            if (connectedFile == null) {
                try {
                    Path mapTilesPath = configurationService.getMapTilesPath();
                    if (mapTilesPath == null) break block26;
                    Class.forName(JDBC.class.getName());
                    this.connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(mapTilesPath));
                    this.metadata = MapService.getMetadata(this.connection);
                    if (!this.metadata.isValid()) {
                        LOG.warning("Default map meta data could not be loaded, map will not work");
                        try {
                            if (this.connection != null) {
                                this.connection.close();
                            }
                            break block26;
                        }
                        catch (SQLException e) {
                            LOG.log(Level.WARNING, "Could not close connection", e);
                        }
                        break block26;
                    }
                    connectedFile = mapTilesPath;
                }
                catch (ClassNotFoundException | SQLException e) {
                    LOG.log(Level.WARNING, "An error occurred whilst trying to load map tiles file", e);
                }
            }
        }
        if (connectedFile == null) {
            return null;
        }
        this.mapConfig = configurationService.getMapConfig();
        if (this.mapConfig == null) {
            return connectedFile;
        }
        ObjectNode options = Optional.ofNullable((ObjectNode)this.mapConfig.get("options")).orElse(this.mapConfig.objectNode());
        ObjectNode defaultOptions = Optional.ofNullable((ObjectNode)options.get("default")).orElse(this.mapConfig.objectNode());
        options.replace("default", (JsonNode)defaultOptions);
        this.mapConfig.replace("options", (JsonNode)options);
        if (!defaultOptions.has("maxZoom")) {
            defaultOptions.put("maxZoom", this.metadata.maxZoom);
        }
        if (!defaultOptions.has("minZoom")) {
            defaultOptions.put("minZoom", this.metadata.minZoom);
        }
        if (this.metadata.getCenter() != null) {
            if (!defaultOptions.has("center")) {
                ArrayNode center = this.metadata.getCenter().deepCopy();
                center.remove(2);
                defaultOptions.set("center", (JsonNode)center);
            }
            if (!defaultOptions.has("zoom")) {
                defaultOptions.put("zoom", this.metadata.getCenter().get(2).asDouble(13.0));
            }
        }
        if (!defaultOptions.has("bounds") && this.metadata.getBounds() != null) {
            defaultOptions.set("bounds", (JsonNode)this.metadata.getBounds());
        }
        return connectedFile;
    }

    public void stop(Container container) throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public ObjectNode getMapSettings(String realm, URI host) {
        String realmUriKey = realm + host.toString();
        if (this.mapSettings.containsKey(realmUriKey)) {
            return (ObjectNode)this.mapSettings.get(realmUriKey);
        }
        if (this.mapConfig == null) {
            return null;
        }
        ObjectNode settings = this.mapSettings.computeIfAbsent(realmUriKey, r -> {
            if (this.metadata.isValid() && !this.mapConfig.isEmpty()) {
                return this.mapConfig.deepCopy();
            }
            return this.mapConfig.objectNode();
        });
        if (!this.metadata.isValid() || this.mapConfig.isEmpty()) {
            return settings;
        }
        Optional.ofNullable(settings.get("sources")).map(s -> s.get("vector_tiles")).filter(JsonNode::isObject).ifPresent(vectorTilesNode -> {
            ObjectNode vectorTilesObj = (ObjectNode)vectorTilesNode;
            vectorTilesObj.remove("url");
            vectorTilesObj.put("attribution", this.metadata.attribution);
            vectorTilesObj.put("maxzoom", this.metadata.maxZoom);
            vectorTilesObj.put("minzoom", this.metadata.minZoom);
            vectorTilesObj.replace("vector_layers", (JsonNode)this.metadata.vectorLayers);
            Optional.ofNullable(this.mapConfig.get("center")).ifPresent(center -> Optional.ofNullable(this.mapConfig.has("zoom") && this.mapConfig.get("zoom").isInt() ? this.mapConfig.get("zoom") : null).ifPresent(zoom -> {
                ArrayNode centerArray = (ArrayNode)center.deepCopy();
                centerArray.add(zoom);
                vectorTilesObj.replace("center", (JsonNode)centerArray);
            }));
            ArrayNode tilesArray = this.mapConfig.arrayNode();
            String tileUrl = UriBuilder.fromUri((URI)host).replacePath(this.pathPrefix + "/api").path(realm).path("map/tile").build(new Object[0]).toString() + "/{z}/{x}/{y}";
            tilesArray.insert(0, tileUrl);
            Optional.ofNullable(vectorTilesObj.get("tiles")).map(tiles -> tiles.get(0)).filter(JsonNode::isTextual).map(JsonNode::textValue).ifPresent(url -> {
                if (!url.contentEquals(DEFAULT_VECTOR_TILES_URL)) {
                    tilesArray.remove(0);
                    tilesArray.insert(0, url);
                }
            });
            vectorTilesObj.replace("tiles", (JsonNode)tilesArray);
        });
        Optional.ofNullable(this.mapConfig.has("sprite") && this.mapConfig.get("sprite").isTextual() ? this.mapConfig.get("sprite").asText() : null).ifPresent(sprite -> {
            String spriteUri = UriBuilder.fromUri((URI)host).replacePath(this.pathPrefix + MAP_SHARED_DATA_BASE_URI).path(sprite).build(new Object[0]).toString();
            settings.put("sprite", spriteUri);
        });
        Optional.ofNullable(this.mapConfig.has("glyphs") && this.mapConfig.get("glyphs").isTextual() ? this.mapConfig.get("glyphs").asText() : null).ifPresent(glyphs -> {
            String glyphsUri = UriBuilder.fromUri((URI)host).replacePath(this.pathPrefix + MAP_SHARED_DATA_BASE_URI).build(new Object[0]).toString() + "/fonts/" + glyphs;
            settings.put("glyphs", glyphsUri);
        });
        return settings;
    }

    public ObjectNode getMapSettingsJs(String realm, URI host) {
        String realmUriKey = realm + host.toString();
        if (this.mapSettingsJs.containsKey(realmUriKey)) {
            return (ObjectNode)this.mapSettingsJs.get(realmUriKey);
        }
        ObjectNode settings = this.mapSettingsJs.computeIfAbsent(realmUriKey, r -> ValueUtil.JSON.createObjectNode());
        if (!this.metadata.isValid() || this.mapConfig.isEmpty()) {
            return settings;
        }
        ArrayNode tilesArray = ValueUtil.JSON.createArrayNode();
        String tileUrl = UriBuilder.fromUri((URI)host).replacePath(RASTER_MAP_TILE_PATH).build(new Object[0]).toString() + "/{z}/{x}/{y}.png";
        tilesArray.insert(0, tileUrl);
        settings.replace("options", this.mapConfig.has("options") && this.mapConfig.get("options").isObject() ? (ObjectNode)this.mapConfig.get("options") : null);
        settings.put("attribution", this.metadata.attribution);
        settings.put("format", "png");
        settings.put("type", "baselayer");
        settings.replace("tiles", (JsonNode)tilesArray);
        return settings;
    }

    public byte[] getMapTile(int zoom, int column, int row) {
        byte[] byArray;
        ResultSet result;
        PreparedStatement query;
        block5: {
            row = Double.valueOf(Math.pow(2.0, zoom) - 1.0 - (double)row).intValue();
            query = null;
            result = null;
            query = this.connection.prepareStatement("select TILE_DATA from TILES where ZOOM_LEVEL = ? and TILE_COLUMN = ? and TILE_ROW = ?");
            int index = 0;
            query.setInt(++index, zoom);
            query.setInt(++index, column);
            query.setInt(++index, row);
            result = query.executeQuery();
            if (!result.next()) break block5;
            byte[] byArray2 = result.getBytes(1);
            MapService.closeQuietly(query, result);
            return byArray2;
        }
        try {
            byArray = null;
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                MapService.closeQuietly(query, result);
                throw throwable;
            }
        }
        MapService.closeQuietly(query, result);
        return byArray;
    }

    public void saveUploadedFile(String filename, InputStream fileInputStream) throws IOException, IllegalArgumentException {
        Path customTilesDir = configurationService.getCustomMapTilesPath(false);
        Path tilesPath = customTilesDir.resolve(filename);
        Path previousCustomTilesPath = configurationService.getCustomMapTilesPath(true);
        boolean isValid = tilesPath.toFile().getCanonicalPath().contains(customTilesDir.toFile().getCanonicalPath() + File.separator);
        if (!isValid) {
            String msg = "Filename outside permitted directory: " + filename;
            LOG.warning(msg);
            throw new IllegalArgumentException(msg);
        }
        try (OutputStream outputStream = Files.newOutputStream(tilesPath, new OpenOption[0]);){
            int bytesRead;
            byte[] buffer = new byte[4096];
            int written = 0;
            while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                if (written > this.customMapLimit) {
                    String msg = "Stream continued passed custom map limit size: " + String.valueOf(tilesPath);
                    LOG.log(Level.SEVERE, msg);
                    throw new IOException(msg);
                }
                outputStream.write(buffer, 0, bytesRead);
                written += bytesRead;
            }
        }
        catch (IOException e) {
            try {
                Files.deleteIfExists(tilesPath);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Could not delete partially written file: " + filename, ex);
            }
            throw e;
        }
        Path loadedFile = this.setData(false);
        this.saveMapMetadata(this.metadata);
        if (loadedFile == null || !loadedFile.toAbsolutePath().equals(tilesPath.toAbsolutePath())) {
            try {
                Files.deleteIfExists(tilesPath);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Could not delete partially written file: " + filename, ex);
            }
            throw new IOException("Failed to load map data ensure the uploaded file is a valid mbtiles file: " + filename);
        }
        if (previousCustomTilesPath.toFile().isFile()) {
            try {
                Files.deleteIfExists(previousCustomTilesPath);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Could not delete old file: " + String.valueOf(previousCustomTilesPath), ex);
            }
        }
    }

    public void deleteUploadedFile() throws IOException {
        Path previousCustomTilesPath = configurationService.getCustomMapTilesPath(true);
        if (previousCustomTilesPath.toFile().isFile()) {
            this.setData(true);
            this.saveMapMetadata(this.metadata);
            Files.deleteIfExists(previousCustomTilesPath);
        }
    }

    public void saveMapMetadata(Metadata metadata) {
        Optional<JsonNode> options = Optional.ofNullable(this.mapConfig.get("options"));
        if (metadata.isValid() && options.isPresent()) {
            Iterator fields = options.get().fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                ObjectNode value = (ObjectNode)field.getValue();
                value.set("center", (JsonNode)metadata.getCenter());
                value.set("bounds", (JsonNode)metadata.getBounds());
            }
            configurationService.saveMapConfig(this.mapConfig);
            this.mapConfig = configurationService.getMapConfig();
            this.mapSettings.clear();
        }
    }

    public ObjectNode getCustomMapInfo() throws IOException {
        return ValueUtil.JSON.createObjectNode().put("limit", this.customMapLimit).put("filename", (String)Optional.ofNullable(configurationService.getCustomMapTilesPath(true)).map(p -> p.toFile().isFile() ? p : null).map(p -> p.getFileName().toString()).orElse(null));
    }

    protected static final class Metadata {
        protected String attribution;
        protected ArrayNode vectorLayers;
        protected int maxZoom;
        protected int minZoom;
        protected ArrayNode bounds;
        protected ArrayNode center;
        protected boolean valid;

        public Metadata(String attribution, ArrayNode vectorLayers, ArrayNode bounds, ArrayNode center, int maxZoom, int minZoom) {
            boolean centerValid;
            this.attribution = attribution;
            this.vectorLayers = vectorLayers;
            this.bounds = bounds;
            this.center = center;
            this.maxZoom = maxZoom;
            this.minZoom = minZoom;
            boolean boundsValid = this.bounds.size() == 4 && StreamSupport.stream(Spliterators.spliterator(this.bounds.elements(), 0L, 4), false).allMatch(v -> v.numberType() != null);
            boolean bl = centerValid = this.center.size() >= 2 && StreamSupport.stream(Spliterators.spliterator(this.bounds.elements(), 0L, 3), false).allMatch(v -> v.numberType() != null);
            if (!boundsValid) {
                LOG.log(Level.WARNING, "Map bounds are invalid.");
            }
            if (!centerValid) {
                LOG.log(Level.WARNING, "Map center is invalid.");
            }
            this.valid = boundsValid && centerValid;
        }

        public Metadata() {
        }

        public String getAttribution() {
            return this.attribution;
        }

        public ArrayNode getVectorLayers() {
            return this.vectorLayers;
        }

        public ArrayNode getBounds() {
            return this.bounds;
        }

        public ArrayNode getCenter() {
            return this.center;
        }

        public int getMaxZoom() {
            return this.maxZoom;
        }

        public int getMinZoom() {
            return this.minZoom;
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

