/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.map;

import com.fasterxml.jackson.databind.node.ObjectNode;
import jakarta.servlet.ServletInputStream;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openremote.container.web.WebResource;
import org.openremote.manager.map.MapService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.model.http.RequestParams;
import org.openremote.model.manager.MapConfig;
import org.openremote.model.map.MapResource;

public class MapResourceImpl
extends WebResource
implements MapResource {
    private static final Logger LOG = Logger.getLogger(MapResourceImpl.class.getName());
    protected final MapService mapService;
    protected final ManagerIdentityService identityService;

    public MapResourceImpl(MapService mapService, ManagerIdentityService identityService) {
        this.mapService = mapService;
        this.identityService = identityService;
    }

    public ObjectNode saveSettings(RequestParams requestParams, MapConfig mapConfig) {
        return this.mapService.saveMapConfig(mapConfig);
    }

    public ObjectNode getSettings(RequestParams requestParams) {
        return this.mapService.getMapSettings(this.getRequestRealmName(), requestParams.getExternalSchemeHostAndPort());
    }

    public ObjectNode getSettingsJs(RequestParams requestParams) {
        return this.mapService.getMapSettingsJs(this.getAuthenticatedRealmName(), requestParams.getExternalSchemeHostAndPort());
    }

    public byte[] getTile(int zoom, int column, int row) {
        byte[] tile = this.mapService.getMapTile(zoom, column, row);
        if (tile != null) {
            return tile;
        }
        throw new WebApplicationException(Response.Status.NO_CONTENT);
    }

    public ObjectNode uploadMap(RequestParams requestParams, String filename) {
        ObjectNode objectNode;
        block10: {
            if (this.request.getContentLength() > this.mapService.customMapLimit) {
                throw new WebApplicationException(Response.Status.REQUEST_ENTITY_TOO_LARGE);
            }
            ServletInputStream stream = this.request.getInputStream();
            try {
                this.mapService.saveUploadedFile(filename, (InputStream)stream);
                objectNode = this.mapService.getMapSettings(this.getRequestRealmName(), requestParams.getExternalSchemeHostAndPort());
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.log(Level.INFO, "Failed to save custom map tiles", e);
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (IllegalArgumentException e) {
                    LOG.log(Level.INFO, "Invalid filename specified", e);
                    throw new WebApplicationException(Response.Status.BAD_REQUEST);
                }
            }
            stream.close();
        }
        return objectNode;
    }

    public ObjectNode getCustomMapInfo() {
        try {
            return this.mapService.getCustomMapInfo();
        }
        catch (IOException e) {
            throw new ServerErrorException(Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    public ObjectNode deleteMap(RequestParams requestParams) {
        try {
            this.mapService.deleteUploadedFile();
            return this.mapService.getMapSettings(this.getRequestRealmName(), requestParams.getExternalSchemeHostAndPort());
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "Failed to delete custom map tiles", e);
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }
}

