/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.gateway;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JulLogger;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openremote.manager.gateway.GatewayTunnelFactory;
import org.openremote.model.gateway.GatewayTunnelInfo;
import org.openremote.model.gateway.GatewayTunnelStartRequestEvent;

public class JSchGatewayTunnelFactory
implements GatewayTunnelFactory {
    protected String localhostRewrite;
    protected File sshKeyFile;
    protected JSch jSch;
    protected final Map<GatewayTunnelInfo, Session> sessionMap = new ConcurrentHashMap<GatewayTunnelInfo, Session>(2);

    public JSchGatewayTunnelFactory(File sshKeyFile, String localhostRewrite) {
        this.sshKeyFile = sshKeyFile;
        this.localhostRewrite = localhostRewrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTunnel(GatewayTunnelStartRequestEvent startRequestEvent) throws Exception {
        String bindAddress;
        if (this.sessionMap.containsKey(startRequestEvent.getInfo())) {
            return;
        }
        JSchGatewayTunnelFactory jSchGatewayTunnelFactory = this;
        synchronized (jSchGatewayTunnelFactory) {
            if (this.jSch == null) {
                this.jSch = new JSch();
                JSch.setLogger((Logger)new JulLogger());
                this.jSch.addIdentity(this.sshKeyFile.getAbsolutePath());
            }
        }
        GatewayTunnelInfo tunnelInfo = startRequestEvent.getInfo();
        Session session = this.jSch.getSession(null, startRequestEvent.getSshHostname(), startRequestEvent.getSshPort());
        session.setTimeout(10000);
        session.setConfig("StrictHostKeyChecking", "no");
        String string = bindAddress = tunnelInfo.getType() == GatewayTunnelInfo.Type.TCP ? null : tunnelInfo.getId();
        int rPort = tunnelInfo.getType() == GatewayTunnelInfo.Type.HTTPS ? 443 : (tunnelInfo.getType() == GatewayTunnelInfo.Type.HTTP ? 80 : tunnelInfo.getAssignedPort());
        String target = this.localhostRewrite != null && "localhost".equals(tunnelInfo.getTarget()) ? this.localhostRewrite : tunnelInfo.getTarget();
        session.connect();
        session.setPortForwardingR(bindAddress, rPort, target, tunnelInfo.getTargetPort());
        this.sessionMap.put(tunnelInfo, session);
    }

    @Override
    public void stopTunnel(GatewayTunnelInfo tunnelInfo) throws Exception {
        Session session = this.sessionMap.remove(tunnelInfo);
        if (session != null) {
            session.disconnect();
        }
    }

    @Override
    public void stopAll() {
        try {
            this.sessionMap.values().forEach(session -> {
                try {
                    session.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        finally {
            this.sessionMap.clear();
        }
    }
}

