/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.gateway;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.gateway.GatewayService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.gateway.GatewayServiceResource;
import org.openremote.model.gateway.GatewayTunnelInfo;
import org.openremote.model.http.RequestParams;
import org.openremote.model.util.TextUtil;

public class GatewayServiceResourceImpl
extends ManagerWebResource
implements GatewayServiceResource {
    protected GatewayService gatewayService;
    protected AssetStorageService assetStorageService;

    public GatewayServiceResourceImpl(TimerService timerService, ManagerIdentityService identityService, GatewayService gatewayService, AssetStorageService assetStorageService) {
        super(timerService, identityService);
        this.gatewayService = gatewayService;
        this.assetStorageService = assetStorageService;
    }

    public GatewayTunnelInfo[] getAllActiveTunnelInfos(RequestParams requestParams, String realm) {
        if (TextUtil.isNullOrEmpty((String)realm) || !this.isAuthenticated()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (!this.isSuperUser() && !this.getAuthenticatedRealmName().equals(realm)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (this.isRestrictedUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return (GatewayTunnelInfo[])this.gatewayService.getTunnelInfos().stream().filter(tunnel -> tunnel.getRealm().equals(realm)).toArray(GatewayTunnelInfo[]::new);
    }

    public GatewayTunnelInfo[] getGatewayActiveTunnelInfos(RequestParams requestParams, String realm, String gatewayId) {
        if (TextUtil.isNullOrEmpty((String)realm) || !this.isAuthenticated()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (!this.isSuperUser() && !this.getAuthenticatedRealmName().equals(realm)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (TextUtil.isNullOrEmpty((String)gatewayId)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), gatewayId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return (GatewayTunnelInfo[])this.gatewayService.getTunnelInfos().stream().filter(tunnel -> tunnel.getRealm().equals(realm) && tunnel.getGatewayId().equals(gatewayId)).toArray(GatewayTunnelInfo[]::new);
    }

    public GatewayTunnelInfo getActiveTunnelInfo(RequestParams requestParams, String realm, String gatewayId, String target, int targetPort) {
        if (TextUtil.isNullOrEmpty((String)realm) || !this.isAuthenticated()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (!this.isSuperUser() && !this.getAuthenticatedRealmName().equals(realm)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (TextUtil.isNullOrEmpty((String)gatewayId)) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), gatewayId)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return this.gatewayService.getTunnelInfos().stream().filter(tunnel -> tunnel.getRealm().equals(realm) && tunnel.getGatewayId().equals(gatewayId) && tunnel.getTarget().equals(target) && tunnel.getTargetPort() == targetPort).findFirst().orElse(null);
    }

    public GatewayTunnelInfo startTunnel(GatewayTunnelInfo tunnelInfo) {
        if (!this.isAuthenticated()) {
            throw new ForbiddenException();
        }
        if (tunnelInfo == null || TextUtil.isNullOrEmpty((String)tunnelInfo.getGatewayId())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (TextUtil.isNullOrEmpty((String)tunnelInfo.getRealm())) {
            tunnelInfo.setRealm(this.getAuthenticatedRealmName());
        } else if (!this.isSuperUser() && !tunnelInfo.getRealm().equals(this.getAuthenticatedRealmName())) {
            throw new ForbiddenException();
        }
        if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), tunnelInfo.getGatewayId())) {
            throw new ForbiddenException();
        }
        try {
            return this.gatewayService.startTunnel(tunnelInfo);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (IllegalStateException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public void stopTunnel(GatewayTunnelInfo tunnelInfo) {
        if (!this.isAuthenticated()) {
            throw new ForbiddenException();
        }
        if (tunnelInfo == null || TextUtil.isNullOrEmpty((String)tunnelInfo.getGatewayId())) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (TextUtil.isNullOrEmpty((String)tunnelInfo.getRealm())) {
            tunnelInfo.setRealm(this.getAuthenticatedRealmName());
        } else if (!this.isSuperUser() && !tunnelInfo.getRealm().equals(this.getAuthenticatedRealmName())) {
            throw new ForbiddenException();
        }
        if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), tunnelInfo.getGatewayId())) {
            throw new ForbiddenException();
        }
        try {
            this.gatewayService.stopTunnel(tunnelInfo);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        catch (IllegalStateException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.NOT_FOUND);
        }
        catch (RuntimeException e) {
            throw new WebApplicationException(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

