/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.gateway;

import jakarta.persistence.EntityManager;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.timer.TimerService;
import org.openremote.container.util.MapAccess;
import org.openremote.manager.asset.AssetProcessingException;
import org.openremote.manager.asset.AssetProcessingService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.event.AttributeEventInterceptor;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.gateway.GatewayConnector;
import org.openremote.manager.gateway.GatewayServiceResourceImpl;
import org.openremote.manager.rules.RulesService;
import org.openremote.manager.rules.RulesetStorageService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.security.ManagerKeycloakIdentityProvider;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.impl.GatewayAsset;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeMap;
import org.openremote.model.attribute.AttributeWriteFailure;
import org.openremote.model.event.shared.SharedEvent;
import org.openremote.model.gateway.GatewayDisconnectEvent;
import org.openremote.model.gateway.GatewayTunnelInfo;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.rules.Ruleset;
import org.openremote.model.security.Realm;
import org.openremote.model.security.User;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.TextUtil;
import org.openremote.model.value.AbstractNameValueDescriptorHolder;
import org.openremote.model.value.MetaItemType;

public class GatewayService
extends RouteBuilder
implements ContainerService {
    public static final int PRIORITY = -2147482548;
    public static final String GATEWAY_CLIENT_ID_PREFIX = "gateway-";
    public static final String OR_GATEWAY_TUNNEL_SSH_KEY_FILE = "OR_GATEWAY_TUNNEL_SSH_KEY_FILE";
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.GATEWAY, (String)GatewayService.class.getName());
    public static final String OR_GATEWAY_TUNNEL_SSH_HOSTNAME = "OR_GATEWAY_TUNNEL_SSH_HOSTNAME";
    public static final String OR_GATEWAY_TUNNEL_SSH_PORT = "OR_GATEWAY_TUNNEL_SSH_PORT";
    public static final String OR_GATEWAY_TUNNEL_TCP_START = "OR_GATEWAY_TUNNEL_TCP_START";
    public static final String OR_GATEWAY_TUNNEL_HOSTNAME = "OR_GATEWAY_TUNNEL_HOSTNAME";
    public static final String OR_GATEWAY_TUNNEL_AUTO_CLOSE_MINUTES = "OR_GATEWAY_TUNNEL_AUTO_CLOSE_MINUTES";
    public static final int OR_GATEWAY_TUNNEL_TCP_START_DEFAULT = 9000;
    protected AssetStorageService assetStorageService;
    protected AssetProcessingService assetProcessingService;
    protected ManagerIdentityService identityService;
    protected ManagerKeycloakIdentityProvider identityProvider;
    protected ClientEventService clientEventService;
    protected RulesetStorageService rulesetStorageService;
    protected RulesService rulesService;
    protected ExecutorService executorService;
    protected ScheduledExecutorService scheduledExecutorService;
    protected TimerService timerService;
    protected String tunnelSSHHostname;
    protected String tunnelHostname;
    protected int tunnelSSHPort;
    protected int tunnelTCPStart;
    protected int tunnelAutoCloseMinutes;
    protected final Map<String, GatewayConnector> gatewayConnectorMap = new ConcurrentHashMap<String, GatewayConnector>();
    protected final Map<String, String> assetIdGatewayIdMap = new HashMap<String, String>();
    protected boolean active;
    protected List<String> realmIds = new ArrayList<String>();
    protected Map<String, GatewayTunnelInfo> tunnelInfos = new ConcurrentHashMap<String, GatewayTunnelInfo>();
    protected AtomicInteger pendingTunnelCounter = new AtomicInteger();

    public static Predicate isNotForGateway(GatewayService gatewayService) {
        return exchange -> {
            if (PersistenceService.isPersistenceEventForEntityType(Asset.class).matches(exchange)) {
                PersistenceEvent persistenceEvent = (PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class);
                Asset asset = (Asset)persistenceEvent.getEntity();
                return gatewayService.getLocallyRegisteredGatewayId(asset.getId(), asset.getParentId()) == null;
            }
            if (PersistenceService.isPersistenceEventForEntityType(Realm.class).matches(exchange)) {
                PersistenceEvent persistenceEvent = (PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class);
                Realm realm = (Realm)persistenceEvent.getEntity();
                if (persistenceEvent.getCause() == PersistenceEvent.Cause.DELETE) {
                    return gatewayService.realmIds.remove(realm.getId());
                }
                Realm localRealm = gatewayService.identityProvider.getRealm(realm.getName());
                if (localRealm != null && localRealm.getId().equals(realm.getId())) {
                    gatewayService.realmIds.add(realm.getId());
                    return true;
                }
                return false;
            }
            if (PersistenceService.isPersistenceEventForEntityType(Ruleset.class).matches(exchange)) {
                PersistenceEvent persistenceEvent = (PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class);
                Ruleset ruleset = (Ruleset)persistenceEvent.getEntity();
                if (persistenceEvent.getCause() == PersistenceEvent.Cause.DELETE) {
                    return gatewayService.rulesService.isRulesetKnown(ruleset);
                }
                return gatewayService.rulesetStorageService.find(ruleset.getClass(), ruleset.getId()) != null;
            }
            return true;
        };
    }

    protected static boolean isGatewayClientId(String clientId) {
        return clientId != null && clientId.startsWith(GATEWAY_CLIENT_ID_PREFIX);
    }

    public static String getGatewayIdFromClientId(String clientId) {
        return clientId.substring(GATEWAY_CLIENT_ID_PREFIX.length());
    }

    public int getPriority() {
        return -2147482548;
    }

    public void init(Container container) throws Exception {
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.assetProcessingService = (AssetProcessingService)container.getService(AssetProcessingService.class);
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.clientEventService = (ClientEventService)container.getService(ClientEventService.class);
        this.executorService = container.getExecutor();
        this.scheduledExecutorService = container.getScheduledExecutor();
        this.rulesetStorageService = (RulesetStorageService)container.getService(RulesetStorageService.class);
        this.rulesService = (RulesService)container.getService(RulesService.class);
        this.timerService = (TimerService)container.getService(TimerService.class);
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new GatewayServiceResourceImpl(this.timerService, this.identityService, this, this.assetStorageService));
        if (!this.identityService.isKeycloakEnabled()) {
            LOG.warning("Incoming edge gateway connections disabled: Not supported when not using Keycloak identity provider");
            this.active = false;
        } else {
            this.active = true;
            this.identityProvider = (ManagerKeycloakIdentityProvider)this.identityService.getIdentityProvider();
            ((MessageBrokerService)container.getService(MessageBrokerService.class)).getContext().addRoutes((RoutesBuilder)this);
            this.clientEventService.setGatewayInterceptor(this::onGatewayMessageIntercept);
            this.assetProcessingService.addEventInterceptor(new AttributeEventInterceptor(){

                @Override
                public int getPriority() {
                    return 0;
                }

                @Override
                public boolean intercept(EntityManager em, AttributeEvent event) throws AssetProcessingException {
                    return GatewayService.this.onAttributeEventIntercepted(em, event);
                }
            });
        }
        this.tunnelSSHHostname = MapAccess.getString((Map)container.getConfig(), (String)OR_GATEWAY_TUNNEL_SSH_HOSTNAME, null);
        this.tunnelSSHPort = MapAccess.getInteger((Map)container.getConfig(), (String)OR_GATEWAY_TUNNEL_SSH_PORT, (int)0);
        this.tunnelTCPStart = MapAccess.getInteger((Map)container.getConfig(), (String)OR_GATEWAY_TUNNEL_TCP_START, (int)9000);
        this.tunnelHostname = MapAccess.getString((Map)container.getConfig(), (String)OR_GATEWAY_TUNNEL_HOSTNAME, null);
        this.tunnelAutoCloseMinutes = MapAccess.getInteger((Map)container.getConfig(), (String)OR_GATEWAY_TUNNEL_AUTO_CLOSE_MINUTES, (int)0);
    }

    public void start(Container container) throws Exception {
        if (!this.active) {
            return;
        }
        List<GatewayAsset> gateways = this.assetStorageService.findAll(new AssetQuery().types(GatewayAsset.class)).stream().map(asset -> (GatewayAsset)asset).collect(Collectors.toList());
        List<String> gatewayIds = gateways.stream().map(Asset::getId).toList();
        if (!(gateways = gateways.stream().filter(gateway -> Arrays.stream(gateway.getPath()).noneMatch(p -> !p.equals(gateway.getId()) && gatewayIds.contains(p))).collect(Collectors.toList())).isEmpty()) {
            LOG.info("Directly registered gateways found = " + gateways.size());
            gateways.forEach(gateway -> {
                boolean hasClientId = gateway.getClientId().isPresent();
                boolean hasClientSecret = gateway.getClientSecret().isPresent();
                if (!hasClientId || !hasClientSecret) {
                    this.createUpdateGatewayServiceUser((GatewayAsset)gateway);
                }
                GatewayConnector connector = new GatewayConnector(this.assetStorageService, this.assetProcessingService, this.executorService, this.scheduledExecutorService, this, (GatewayAsset)gateway);
                this.gatewayConnectorMap.put(gateway.getId().toLowerCase(Locale.ROOT), connector);
                List<Asset<?>> gatewayAssets = this.assetStorageService.findAll(new AssetQuery().parents(new String[]{gateway.getId()}).select(new AssetQuery.Select().excludeAttributes()).recursive(true));
                gatewayAssets.forEach(asset -> this.assetIdGatewayIdMap.put(asset.getId(), gateway.getId()));
            });
        }
    }

    public void stop(Container container) throws Exception {
        this.gatewayConnectorMap.values().forEach(connector -> connector.disconnect(GatewayDisconnectEvent.Reason.TERMINATING));
        this.gatewayConnectorMap.clear();
        this.assetIdGatewayIdMap.clear();
        this.tunnelInfos.clear();
    }

    public void configure() throws Exception {
        if (this.active) {
            this.from("seda://PersistenceTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&size=25000").routeId("Persistence-GatewayAsset").filter(PersistenceService.isPersistenceEventForEntityType(Asset.class)).process(exchange -> {
                PersistenceEvent persistenceEvent = (PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class);
                Asset<?> eventAsset = (Asset<?>)persistenceEvent.getEntity();
                if (!(eventAsset instanceof GatewayAsset) && this.gatewayConnectorMap.isEmpty()) {
                    return;
                }
                if (eventAsset instanceof GatewayAsset && (this.isLocallyRegisteredGateway(eventAsset.getId()) || this.getLocallyRegisteredGatewayId(eventAsset.getId(), eventAsset.getParentId()) == null)) {
                    if (persistenceEvent.getCause() != PersistenceEvent.Cause.DELETE && (eventAsset = this.assetStorageService.find(eventAsset.getId(), true)) == null) {
                        return;
                    }
                    this.processGatewayChange((GatewayAsset)eventAsset, persistenceEvent);
                } else {
                    String gatewayId = this.getLocallyRegisteredGatewayId(eventAsset.getId(), eventAsset.getParentId());
                    if (gatewayId != null) {
                        if (persistenceEvent.getCause() != PersistenceEvent.Cause.DELETE && (eventAsset = this.assetStorageService.find(eventAsset.getId(), true)) == null) {
                            return;
                        }
                        this.processGatewayChildAssetChange(gatewayId, eventAsset, persistenceEvent);
                    }
                }
            });
        }
    }

    protected void onGatewayMessageIntercept(Exchange exchange) {
        String clientId = ClientEventService.getClientId(exchange);
        if (!GatewayService.isGatewayClientId(clientId)) {
            return;
        }
        if (this.header("connection.sessionOpen").matches(exchange)) {
            String sessionKey = ClientEventService.getSessionKey(exchange);
            this.processGatewayConnected(clientId, sessionKey);
            return;
        }
        if (PredicateBuilder.or((Predicate)this.header("connection.sessionClose"), (Predicate)this.header("connection.sessionCloseError")).matches(exchange)) {
            String sessionKey = ClientEventService.getSessionKey(exchange);
            this.processGatewayDisconnected(clientId, sessionKey);
            return;
        }
        if (this.body().isInstanceOf(SharedEvent.class).matches(exchange)) {
            exchange.setRouteStop(true);
            String sessionKey = ClientEventService.getSessionKey(exchange);
            String gatewayId = GatewayService.getGatewayIdFromClientId(clientId);
            this.processGatewayMessage(gatewayId, sessionKey, (SharedEvent)exchange.getIn().getBody(SharedEvent.class));
        }
    }

    public boolean onAttributeEventIntercepted(EntityManager em, AttributeEvent event) throws AssetProcessingException {
        if (((Object)((Object)this)).getClass().getSimpleName().equals(event.getSource())) {
            event.getMeta().remove(MetaItemType.AGENT_LINK);
            return false;
        }
        GatewayConnector connector = this.gatewayConnectorMap.get(event.getId().toLowerCase(Locale.ROOT));
        if (connector != null) {
            LOG.fine("Attribute event for a locally registered gateway asset (Asset ID=" + event.getId() + "): " + String.valueOf(event.getRef()));
            if (GatewayAsset.DISABLED.getName().equals(event.getName())) {
                boolean isAlreadyDisabled;
                boolean disabled = event.getValue().orElse(false);
                if (disabled != (isAlreadyDisabled = event.getOldValue().orElse(false).booleanValue())) {
                    GatewayAsset gatewayAsset = this.assetStorageService.find(event.getId(), GatewayAsset.class);
                    if (gatewayAsset == null) {
                        String msg = "Gateway asset not found: ref=" + String.valueOf(event.getRef());
                        LOG.info(msg);
                        throw new AssetProcessingException(AttributeWriteFailure.CANNOT_PROCESS, msg);
                    }
                    LOG.fine("Gateway client disabled attribute updated so updating gateway service user enabled flag: (gatewayId=" + event.getId() + ")");
                    gatewayAsset.setDisabled(Boolean.valueOf(disabled));
                    this.createUpdateGatewayServiceUser(gatewayAsset);
                    connector.setDisabled(disabled);
                }
            } else if (GatewayAsset.CLIENT_SECRET.getName().equals(event.getName())) {
                String newSecret = event.getValue().orElse(null);
                GatewayAsset gatewayAsset = this.assetStorageService.find(event.getId(), GatewayAsset.class);
                if (gatewayAsset == null) {
                    String msg = "Gateway asset not found: ref=" + String.valueOf(event.getRef());
                    LOG.warning(msg);
                    throw new AssetProcessingException(AttributeWriteFailure.CANNOT_PROCESS, msg);
                }
                LOG.fine("Gateway client secret attribute updated so updating gateway service user secret: (gatewayId=" + event.getId() + ")");
                User gatewayServiceUser = this.identityProvider.getUserByUsername(event.getRealm(), "service-account-" + (String)gatewayAsset.getClientId().orElseThrow(() -> {
                    String msg = "Gateway asset client ID is missing";
                    LOG.warning(msg);
                    return new AssetProcessingException(AttributeWriteFailure.CANNOT_PROCESS, msg);
                }));
                if (gatewayServiceUser == null) {
                    String msg = "Couldn't retrieve gateway service user to update secret: (gatewayId=" + event.getId() + ")";
                    LOG.warning(msg);
                    throw new AssetProcessingException(AttributeWriteFailure.CANNOT_PROCESS, msg);
                }
                newSecret = this.identityProvider.resetSecret(event.getRealm(), gatewayServiceUser.getId(), newSecret);
                connector.disconnect(GatewayDisconnectEvent.Reason.TERMINATING);
                event.setValue((Object)newSecret);
            }
            return false;
        }
        String gatewayId = this.assetIdGatewayIdMap.get(event.getId());
        if (gatewayId != null) {
            LOG.fine("Attribute event for a gateway descendant asset (assetId=" + event.getId() + ", gatewayId=" + gatewayId + ")");
            connector = this.gatewayConnectorMap.get(gatewayId.toLowerCase(Locale.ROOT));
            if (connector == null) {
                String msg = "Gateway not found for descendant asset, this should not happen!!! assetId=" + event.getId() + ", gatewayId=" + gatewayId + ")";
                LOG.warning(msg);
                throw new AssetProcessingException(AttributeWriteFailure.CANNOT_PROCESS, msg);
            }
            if (!connector.isConnected()) {
                LOG.info("Gateway is not connected so attribute event for descendant asset will be dropped (assetId=" + event.getId() + ", gatewayId=" + gatewayId + ")");
                throw new AssetProcessingException(AttributeWriteFailure.CANNOT_PROCESS, "Gateway is not connected: gatewayId=" + connector.gatewayId);
            }
            LOG.fine("Attribute event for a gateway descendant asset being forwarded to the gateway (assetRef=" + String.valueOf(event.getRef()) + ", gatewayId=" + gatewayId + ")");
            connector.sendMessageToGateway(new AttributeEvent(GatewayConnector.mapAssetId(gatewayId, event.getId(), true), event.getName(), event.getValue().orElse(null), Long.valueOf(event.getTimestamp())).setParentId(GatewayConnector.mapAssetId(gatewayId, event.getParentId(), true)).setRealm(event.getRealm()));
            return true;
        }
        return false;
    }

    public boolean deleteGateway(String gatewayId) {
        GatewayConnector connector = this.gatewayConnectorMap.get(gatewayId.toLowerCase(Locale.ROOT));
        if (connector == null) {
            String msg = "Gateway is not known: Gateway ID=" + gatewayId;
            LOG.info(msg);
            throw new IllegalStateException(msg);
        }
        if (connector.isConnected()) {
            connector.setDisabled(true);
        }
        List<String> gatewayAssetIds = this.assetIdGatewayIdMap.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(gatewayId)).map(Map.Entry::getKey).collect(Collectors.toList());
        gatewayAssetIds.add(gatewayId);
        return this.assetStorageService.delete(gatewayAssetIds, true);
    }

    public Collection<GatewayTunnelInfo> getTunnelInfos() {
        return this.tunnelInfos.values();
    }

    protected boolean tunnellingSupported() {
        return !TextUtil.isNullOrEmpty((String)this.tunnelSSHHostname) && this.tunnelSSHPort > 0;
    }

    public GatewayTunnelInfo startTunnel(GatewayTunnelInfo tunnelInfo) throws IllegalArgumentException, IllegalStateException {
        if (!this.tunnellingSupported()) {
            String msg = "Failed to start tunnel: reason=tunnelling is not supported";
            LOG.info(msg);
            throw new IllegalArgumentException(msg);
        }
        if (TextUtil.isNullOrEmpty((String)tunnelInfo.getGatewayId())) {
            String msg = "Failed to start tunnel: reason=gateway ID cannot be null or empty";
            LOG.info(msg);
            throw new IllegalArgumentException(msg);
        }
        String gatewayId = tunnelInfo.getGatewayId().toLowerCase(Locale.ROOT);
        String realm = tunnelInfo.getRealm();
        GatewayConnector connector = this.gatewayConnectorMap.get(gatewayId);
        if (connector == null || !realm.equals(connector.getRealm())) {
            String msg = "Failed to start tunnel: reason=Gateway disconnected or doesn't exist, id=" + gatewayId;
            LOG.info(msg);
            throw new IllegalStateException(msg);
        }
        if (!connector.isTunnellingSupported()) {
            String msg = "Failed to start tunnel: reason=Not supported by gateway, id=" + gatewayId;
            LOG.info(msg);
            throw new IllegalArgumentException(msg);
        }
        if (!connector.isConnected()) {
            String msg = "Failed to start tunnel: reason=Not connected, id=" + gatewayId;
            LOG.info(msg);
            throw new IllegalArgumentException(msg);
        }
        if (tunnelInfo.getType() == GatewayTunnelInfo.Type.TCP) {
            int assignedPort = this.tunnelTCPStart + Math.toIntExact((long)this.pendingTunnelCounter.get() + this.tunnelInfos.values().stream().filter(ti -> ti.getType() == GatewayTunnelInfo.Type.TCP).count());
            tunnelInfo.setAssignedPort(Integer.valueOf(assignedPort));
        }
        if (!TextUtil.isNullOrEmpty((String)this.tunnelHostname)) {
            tunnelInfo.setHostname(this.tunnelHostname);
        }
        if (this.tunnelAutoCloseMinutes > 0) {
            tunnelInfo.setAutoCloseTime(this.timerService.getNow().plus(Duration.ofMinutes(this.tunnelAutoCloseMinutes)));
        }
        CompletableFuture<Void> startFuture = connector.startTunnel(tunnelInfo);
        try {
            Object delay;
            this.pendingTunnelCounter.incrementAndGet();
            startFuture.get();
            this.tunnelInfos.put(tunnelInfo.getId(), tunnelInfo);
            if (tunnelInfo.getAutoCloseTime() != null) {
                delay = Duration.between(this.timerService.getNow(), tunnelInfo.getAutoCloseTime());
                this.scheduledExecutorService.schedule(() -> this.autoCloseTunnel(tunnelInfo.getId()), ((Duration)delay).toMillis(), TimeUnit.MILLISECONDS);
                LOG.fine("Scheduled job to automatically close tunnel '" + tunnelInfo.getId() + "' at " + String.valueOf(tunnelInfo.getAutoCloseTime()));
            }
            delay = tunnelInfo;
            return delay;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TimeoutException) {
                String msg = "Failed to start tunnel: A timeout occurred whilst waiting for the tunnel to be started: id=" + gatewayId;
                LOG.log(Level.WARNING, msg);
            } else {
                String msg = "Failed to start tunnel: An error occurred whilst waiting for the tunnel to be started: id=" + gatewayId;
                LOG.log(Level.WARNING, msg, e.getCause());
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.pendingTunnelCounter.decrementAndGet();
        }
    }

    public void stopTunnel(GatewayTunnelInfo tunnelInfo) throws IllegalArgumentException, IllegalStateException {
        if (!this.tunnellingSupported()) {
            String msg = "Failed to stop tunnel: reason=tunnelling is not supported";
            LOG.info(msg);
            throw new IllegalArgumentException(msg);
        }
        if (TextUtil.isNullOrEmpty((String)tunnelInfo.getGatewayId())) {
            String msg = "Failed to stop tunnel: reason=gateway ID cannot be null or empty";
            LOG.info(msg);
            throw new IllegalArgumentException(msg);
        }
        String gatewayId = tunnelInfo.getGatewayId().toLowerCase(Locale.ROOT);
        String realm = tunnelInfo.getRealm();
        GatewayConnector connector = this.gatewayConnectorMap.get(gatewayId);
        if (connector == null || !realm.equals(connector.getRealm())) {
            String msg = "Failed to stop tunnel: reason=Gateway disconnected or doesn't exist, id=" + gatewayId;
            LOG.info(msg);
            throw new IllegalStateException(msg);
        }
        if (!connector.isTunnellingSupported()) {
            String msg = "Failed to stop tunnel: reason=Not supported by gateway, id=" + gatewayId;
            LOG.info(msg);
            throw new IllegalArgumentException(msg);
        }
        if (!connector.isConnected()) {
            String msg = "Failed to stop tunnel: reason=Not connected, id=" + gatewayId;
            LOG.info(msg);
            throw new IllegalArgumentException(msg);
        }
        CompletableFuture<Void> stopFuture = connector.stopTunnel(tunnelInfo);
        try {
            stopFuture.get(20L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            String msg = "Failed to stop tunnel: An error occurred whilst waiting for the tunnel to be stopped: id=" + gatewayId;
            LOG.log(Level.WARNING, msg, e.getCause());
            throw new RuntimeException(msg, e.getCause());
        }
        catch (InterruptedException | TimeoutException e) {
            String msg = "Failed to stop tunnel: An error occurred whilst waiting for the tunnel to be stopped: id=" + gatewayId;
            LOG.warning(msg);
            throw new RuntimeException(msg);
        }
        finally {
            this.tunnelInfos.remove(tunnelInfo.getId(), tunnelInfo);
        }
    }

    public boolean isLocallyRegisteredGateway(String assetId) {
        return this.gatewayConnectorMap.containsKey(assetId.toLowerCase(Locale.ROOT));
    }

    public String getLocallyRegisteredGatewayId(String assetId, String parentId) {
        String gatewayId = this.assetIdGatewayIdMap.get(assetId);
        if (gatewayId != null) {
            return gatewayId;
        }
        if (parentId != null) {
            GatewayConnector connector = this.gatewayConnectorMap.get(parentId.toLowerCase(Locale.ROOT));
            if (connector != null) {
                return connector.gatewayId;
            }
            return this.getLocallyRegisteredGatewayId(parentId, null);
        }
        return null;
    }

    protected void processGatewayConnected(String gatewayClientId, String sessionId) {
        String gatewayId = GatewayService.getGatewayIdFromClientId(gatewayClientId);
        GatewayConnector connector = this.gatewayConnectorMap.get(gatewayId.toLowerCase(Locale.ROOT));
        if (connector == null) {
            LOG.warning("Gateway connected but not recognised which shouldn't happen: GatewayID=" + gatewayId);
            this.clientEventService.sendToWebsocketSession(sessionId, new GatewayDisconnectEvent(GatewayDisconnectEvent.Reason.UNRECOGNISED));
            this.clientEventService.closeWebsocketSession(sessionId);
            return;
        }
        if (connector.isDisabled()) {
            LOG.warning("Gateway is currently disabled so will be ignored: " + String.valueOf((Object)this));
            this.clientEventService.sendToWebsocketSession(sessionId, new GatewayDisconnectEvent(GatewayDisconnectEvent.Reason.DISABLED));
            this.clientEventService.closeWebsocketSession(sessionId);
            return;
        }
        connector.connected(sessionId, this.createConnectorMessageConsumer(sessionId), () -> {
            try {
                this.clientEventService.closeWebsocketSession(sessionId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processGatewayDisconnected(String gatewayClientId, String sessionId) {
        String gatewayId = GatewayService.getGatewayIdFromClientId(gatewayClientId);
        GatewayConnector connector = this.gatewayConnectorMap.get(gatewayId.toLowerCase(Locale.ROOT));
        try {
            if (connector != null) {
                connector.disconnected(sessionId);
            }
        }
        finally {
            this.tunnelInfos.values().removeIf(tunnelInfo -> tunnelInfo.getGatewayId().equalsIgnoreCase(gatewayId));
        }
    }

    protected void processGatewayMessage(String gatewayId, String sessionId, SharedEvent event) {
        GatewayConnector connector = this.gatewayConnectorMap.get(gatewayId.toLowerCase(Locale.ROOT));
        if (connector == null) {
            return;
        }
        if (!connector.isConnected() || !sessionId.equals(connector.getSessionId())) {
            LOG.finest("Gateway event received for an obsolete session so ignoring: " + String.valueOf((Object)this));
            return;
        }
        connector.onGatewayEvent(event);
    }

    protected void processGatewayChange(GatewayAsset gateway, PersistenceEvent<Asset<?>> persistenceEvent) {
        switch (persistenceEvent.getCause()) {
            case CREATE: {
                this.createUpdateGatewayServiceUser(gateway);
                GatewayConnector connector = new GatewayConnector(this.assetStorageService, this.assetProcessingService, this.executorService, this.scheduledExecutorService, this, gateway);
                this.gatewayConnectorMap.put(gateway.getId().toLowerCase(Locale.ROOT), connector);
                break;
            }
            case UPDATE: {
                AttributeMap oldAttributes;
                boolean wasDisabled;
                GatewayConnector connector = this.gatewayConnectorMap.get(gateway.getId().toLowerCase(Locale.ROOT));
                if (connector == null) break;
                boolean isNowDisabled = gateway.getDisabled().orElse(false);
                connector.setDisabled(isNowDisabled);
                if (!persistenceEvent.hasPropertyChanged("attributes") || (wasDisabled = (oldAttributes = (AttributeMap)persistenceEvent.getPreviousState("attributes")).getValue((AbstractNameValueDescriptorHolder)GatewayAsset.DISABLED).orElse(false).booleanValue()) == isNowDisabled) break;
                this.createUpdateGatewayServiceUser(gateway);
                break;
            }
            case DELETE: {
                GatewayConnector connector = this.gatewayConnectorMap.get(gateway.getId().toLowerCase(Locale.ROOT));
                if (connector == null) break;
                this.tunnelInfos.values().forEach(tunnelInfo -> {
                    if (tunnelInfo.getGatewayId().equals(gateway.getId())) {
                        try {
                            this.stopTunnel((GatewayTunnelInfo)tunnelInfo);
                        }
                        catch (IllegalArgumentException | IllegalStateException runtimeException) {
                            // empty catch block
                        }
                    }
                });
                connector = this.gatewayConnectorMap.remove(gateway.getId().toLowerCase(Locale.ROOT));
                if (connector != null) {
                    connector.disconnect(GatewayDisconnectEvent.Reason.UNRECOGNISED);
                }
                this.removeGatewayServiceUser(gateway);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processGatewayChildAssetChange(String gatewayId, Asset<?> childAsset, PersistenceEvent<Asset<?>> persistenceEvent) {
        switch (persistenceEvent.getCause()) {
            case CREATE: 
            case UPDATE: {
                Map<String, String> map = this.assetIdGatewayIdMap;
                synchronized (map) {
                    this.assetIdGatewayIdMap.put(childAsset.getId(), gatewayId);
                    break;
                }
            }
            case DELETE: {
                Map<String, String> map = this.assetIdGatewayIdMap;
                synchronized (map) {
                    this.assetIdGatewayIdMap.remove(childAsset.getId());
                    break;
                }
            }
        }
    }

    protected boolean isGatewayConnected(String gatewayId) {
        AtomicBoolean connected = new AtomicBoolean(false);
        this.gatewayConnectorMap.computeIfPresent(gatewayId.toLowerCase(Locale.ROOT), (id, gatewayConnector) -> {
            connected.set(gatewayConnector.isConnected());
            return gatewayConnector;
        });
        return connected.get();
    }

    public static String getGatewayClientId(String gatewayAssetId) {
        Object clientId = GATEWAY_CLIENT_ID_PREFIX + gatewayAssetId.toLowerCase(Locale.ROOT);
        if (((String)clientId).length() > 255) {
            clientId = ((String)clientId).substring(0, 254);
        }
        return clientId;
    }

    protected void createUpdateGatewayServiceUser(GatewayAsset gateway) {
        LOG.info("Creating/updating gateway service user for gateway id: " + gateway.getId());
        String clientId = GatewayService.getGatewayClientId(gateway.getId());
        String secret = gateway.getClientSecret().orElseGet(() -> UUID.randomUUID().toString());
        try {
            boolean createUpdateGatewayUser;
            User gatewayUser = this.identityProvider.getUserByUsername(gateway.getRealm(), "service-account-" + clientId);
            boolean userExists = gatewayUser != null;
            boolean bl = createUpdateGatewayUser = gatewayUser == null || gatewayUser.getEnabled() == gateway.getDisabled().orElse(false) || Objects.equals(gatewayUser.getSecret(), gateway.getClientSecret().orElse(null));
            if (createUpdateGatewayUser) {
                gatewayUser = this.identityProvider.createUpdateUser(gateway.getRealm(), new User().setServiceAccount(true).setSystemAccount(true).setUsername(clientId).setEnabled(Boolean.valueOf(gateway.getDisabled().orElse(false) == false)), secret, true);
            }
            if (!userExists && gatewayUser != null) {
                this.identityProvider.updateUserRealmRoles(gateway.getRealm(), gatewayUser.getId(), this.identityProvider.addUserRealmRoles(gateway.getRealm(), gatewayUser.getId(), new String[]{"restricted_user"}));
            }
            if (!clientId.equals(gateway.getClientId().orElse(null)) || !secret.equals(gateway.getClientSecret().orElse(null))) {
                gateway.setClientId(clientId);
                gateway.setClientSecret(secret);
                this.assetStorageService.merge(gateway);
            }
            try {
                LOG.info("Created gateway keycloak client for gateway id: " + gateway.getId());
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to merge registered gateway: " + gateway.getId(), e);
            }
        }
        catch (Exception e) {
            LOG.warning("Failed to create client for gateway: " + gateway.getId());
        }
    }

    protected void removeGatewayServiceUser(GatewayAsset gateway) {
        String id = gateway.getClientId().orElse(null);
        if (TextUtil.isNullOrEmpty((String)id)) {
            LOG.warning("Cannot find gateway keycloak client ID so cannot remove keycloak client for gateway: " + gateway.getId());
            return;
        }
        this.identityProvider.deleteClient(gateway.getRealm(), id);
    }

    protected Consumer<Object> createConnectorMessageConsumer(String sessionId) {
        return msg -> this.clientEventService.sendToWebsocketSession(sessionId, msg);
    }

    String getTunnelSSHHostname() {
        return this.tunnelSSHHostname;
    }

    int getTunnelSSHPort() {
        return this.tunnelSSHPort;
    }

    public int getTunnelTCPStart() {
        return this.tunnelTCPStart;
    }

    protected void autoCloseTunnel(String tunnelId) {
        GatewayTunnelInfo tunnelInfo = this.tunnelInfos.get(tunnelId);
        if (tunnelInfo == null) {
            LOG.fine("Tunnel '" + tunnelId + "' not found so it cannot be automatically closed");
            return;
        }
        try {
            LOG.info("Automatically closing tunnel: " + tunnelId);
            this.stopTunnel(tunnelInfo);
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            LOG.log(Level.WARNING, "Failed to automatically close tunnel: " + tunnelId, e);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{active=" + this.active + "}";
    }
}

