/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.gateway;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.openremote.agent.protocol.websocket.WebsocketIOClient;
import org.openremote.model.auth.OAuthGrant;
import org.openremote.model.syslog.SyslogCategory;

public class GatewayIOClient
extends WebsocketIOClient<String> {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.PROTOCOL, GatewayIOClient.class);
    protected static final int TIMEOUT_MILLIS = 30000;
    protected CompletableFuture<Void> syncFuture;

    public GatewayIOClient(URI uri, Map<String, List<String>> headers, OAuthGrant oAuthGrant) {
        super(uri, headers, oAuthGrant);
    }

    protected Future<Void> startChannel() {
        CompletableFuture connectedFuture;
        try {
            connectedFuture = GatewayIOClient.toCompletableFuture((Future)super.startChannel());
        }
        catch (Exception e) {
            connectedFuture = CompletableFuture.failedFuture(e);
        }
        return connectedFuture.orTimeout((long)this.getConnectTimeoutMillis() + 1000L, TimeUnit.MILLISECONDS).thenCompose(__ -> this.getFuture().orTimeout(30000L, TimeUnit.MILLISECONDS).handle((result, ex) -> {
            this.syncFuture = null;
            if (ex instanceof TimeoutException && !this.channel.isOpen()) {
                LOG.info("Channel has been closed unexpectedly during sync");
                throw new RuntimeException("Channel has been closed unexpectedly during sync");
            }
            if (ex instanceof TimeoutException) {
                LOG.finest("Timeout reached whilst waiting for sync complete event");
            } else if (ex != null) {
                throw new RuntimeException(ex.getMessage());
            }
            return null;
        }));
    }

    protected Void waitForConnectFuture(Future<Void> connectFuture) throws Exception {
        return connectFuture.get((long)this.getConnectTimeoutMillis() + 60000L, TimeUnit.MILLISECONDS);
    }

    protected CompletableFuture<Void> getFuture() {
        this.syncFuture = new CompletableFuture();
        return this.syncFuture;
    }

    protected void onMessageReceived(String message) {
        if (this.syncFuture != null && message.contains("gateway-capabilities-request")) {
            LOG.finest("Gateway connection is now ready");
            this.syncFuture.complete(null);
        }
        if (this.syncFuture != null && message.contains("gateway-disconnect")) {
            LOG.finest("Gateway disconnect event received during sync: " + message);
            this.syncFuture.completeExceptionally(new RuntimeException("Gateway disconnect event received during sync"));
        }
        super.onMessageReceived((Object)message);
    }
}

