/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.gateway;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.openremote.manager.asset.AssetProcessingService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.gateway.GatewayService;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetEvent;
import org.openremote.model.asset.AssetsEvent;
import org.openremote.model.asset.ReadAssetEvent;
import org.openremote.model.asset.ReadAssetsEvent;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.asset.impl.GatewayAsset;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.event.shared.SharedEvent;
import org.openremote.model.gateway.GatewayCapabilitiesRequestEvent;
import org.openremote.model.gateway.GatewayCapabilitiesResponseEvent;
import org.openremote.model.gateway.GatewayDisconnectEvent;
import org.openremote.model.gateway.GatewayTunnelInfo;
import org.openremote.model.gateway.GatewayTunnelStartRequestEvent;
import org.openremote.model.gateway.GatewayTunnelStartResponseEvent;
import org.openremote.model.gateway.GatewayTunnelStopRequestEvent;
import org.openremote.model.gateway.GatewayTunnelStopResponseEvent;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.Pair;

public class GatewayConnector {
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.GATEWAY, (String)GatewayConnector.class.getName());
    public static int MAX_SYNC_RETRIES = 5;
    public static int SYNC_ASSET_BATCH_SIZE = 20;
    public static final String ASSET_READ_EVENT_NAME_INITIAL = "INITIAL";
    public static final String ASSET_READ_EVENT_NAME_BATCH = "BATCH";
    public static final long RESPONSE_TIMEOUT_MILLIS = 10000L;
    protected static final Map<String, Pair<Function<String, String>, Function<String, String>>> ASSET_ID_MAPPERS = new HashMap<String, Pair<Function<String, String>, Function<String, String>>>();
    protected final String realm;
    protected final String gatewayId;
    protected final AssetStorageService assetStorageService;
    protected final ExecutorService executorService;
    protected final ScheduledExecutorService scheduledExecutorService;
    protected final AssetProcessingService assetProcessingService;
    protected final GatewayService gatewayService;
    protected List<AssetEvent> cachedAssetEvents;
    protected List<AttributeEvent> cachedAttributeEvents;
    protected Consumer<Object> gatewayMessageConsumer;
    protected Runnable requestDisconnect;
    protected final AtomicReference<String> sessionId = new AtomicReference();
    protected boolean disabled;
    protected boolean initialSyncInProgress;
    protected ScheduledFuture<?> syncProcessorFuture;
    protected Future<?> capabilitiesFuture;
    List<String> syncAssetIds;
    protected GatewayAsset gatewayAsset;
    int syncIndex;
    int syncErrors;
    String expectedSyncResponseName;
    protected boolean tunnellingSupported;
    protected final Map<Class<? extends SharedEvent>, Consumer<SharedEvent>> eventConsumerMap = new HashMap<Class<? extends SharedEvent>, Consumer<SharedEvent>>();
    protected static List<Integer> ALPHA_NUMERIC_CHARACTERS = new ArrayList<Integer>(62);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GatewayConnector(AssetStorageService assetStorageService, AssetProcessingService assetProcessingService, ExecutorService executorService, ScheduledExecutorService scheduledExecutorService, GatewayService gatewayService, GatewayAsset gateway) {
        this.assetStorageService = assetStorageService;
        this.assetProcessingService = assetProcessingService;
        this.executorService = executorService;
        this.scheduledExecutorService = scheduledExecutorService;
        this.gatewayService = gatewayService;
        this.disabled = gateway.getDisabled().orElse(false);
        this.realm = gateway.getRealm();
        this.gatewayId = gateway.getId();
        this.gatewayAsset = gateway;
        Map<Class<? extends SharedEvent>, Consumer<SharedEvent>> map = this.eventConsumerMap;
        synchronized (map) {
            this.eventConsumerMap.put(AssetEvent.class, e -> this.onAssetEvent((AssetEvent)e));
            this.eventConsumerMap.put(AttributeEvent.class, e -> this.onAttributeEvent((AttributeEvent)e));
        }
        this.publishAttributeEvent(new AttributeEvent(this.gatewayId, GatewayAsset.STATUS, (Object)ConnectionStatus.DISCONNECTED));
    }

    protected void sendMessageToGateway(Object message) {
        try {
            if (this.gatewayMessageConsumer != null) {
                this.gatewayMessageConsumer.accept(message);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to send message to gateway: " + String.valueOf(this), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connected(String sessionId, Consumer<Object> gatewayMessageConsumer, Runnable requestDisconnect) {
        LOG.fine("Gateway connector connected: " + String.valueOf(this));
        AtomicReference<String> atomicReference = this.sessionId;
        synchronized (atomicReference) {
            if (this.getSessionId() != null) {
                this.disconnect(GatewayDisconnectEvent.Reason.ALREADY_CONNECTED);
            }
            this.sessionId.set(sessionId);
        }
        this.gatewayMessageConsumer = gatewayMessageConsumer;
        this.requestDisconnect = requestDisconnect;
        this.initialSyncInProgress = true;
        this.syncProcessorFuture = null;
        this.cachedAssetEvents = new ArrayList<AssetEvent>();
        this.cachedAttributeEvents = new ArrayList<AttributeEvent>();
        this.syncAssetIds = null;
        this.syncIndex = 0;
        this.syncErrors = 0;
        this.publishAttributeEvent(new AttributeEvent(this.gatewayId, GatewayAsset.STATUS, (Object)ConnectionStatus.CONNECTING));
        this.startSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnected(String sessionId) {
        AtomicReference<String> atomicReference = this.sessionId;
        synchronized (atomicReference) {
            if (!sessionId.equals(this.sessionId.get())) {
                return;
            }
            this.sessionId.set(null);
        }
        this.requestDisconnect.run();
        LOG.fine("Gateway connector disconnected: " + String.valueOf(this));
        if (this.syncProcessorFuture != null) {
            LOG.finest("Aborting active sync process: " + String.valueOf(this));
            this.syncProcessorFuture.cancel(true);
        }
        if (this.capabilitiesFuture != null) {
            LOG.finest("Aborting capabilities request: " + String.valueOf(this));
            this.capabilitiesFuture.cancel(true);
        }
        this.initialSyncInProgress = false;
        this.publishAttributeEvent(new AttributeEvent(this.gatewayId, GatewayAsset.STATUS, (Object)ConnectionStatus.DISCONNECTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disconnect(GatewayDisconnectEvent.Reason reason) {
        AtomicReference<String> atomicReference = this.sessionId;
        synchronized (atomicReference) {
            if (this.isConnected()) {
                if (!this.disabled) {
                    this.sendMessageToGateway(new GatewayDisconnectEvent(reason));
                }
                this.disconnected(this.getSessionId());
            }
        }
    }

    protected boolean isConnected() {
        return this.sessionId.get() != null;
    }

    protected boolean isInitialSyncInProgress() {
        return this.initialSyncInProgress;
    }

    protected boolean isTunnellingSupported() {
        return this.tunnellingSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<GatewayCapabilitiesResponseEvent> getCapabilities() {
        CompletableFuture future = new CompletableFuture();
        Map<Class<? extends SharedEvent>, Consumer<SharedEvent>> map = this.eventConsumerMap;
        synchronized (map) {
            if (this.eventConsumerMap.containsKey(GatewayCapabilitiesResponseEvent.class)) {
                return CompletableFuture.failedFuture(new IllegalArgumentException("A capabilities request is already pending"));
            }
            this.eventConsumerMap.put(GatewayCapabilitiesResponseEvent.class, e -> {
                GatewayCapabilitiesResponseEvent response = (GatewayCapabilitiesResponseEvent)e;
                future.complete(response);
            });
        }
        this.sendMessageToGateway(new GatewayCapabilitiesRequestEvent());
        return future.orTimeout(10000L, TimeUnit.MILLISECONDS).whenComplete((result, ex) -> {
            Map<Class<? extends SharedEvent>, Consumer<SharedEvent>> map = this.eventConsumerMap;
            synchronized (map) {
                this.eventConsumerMap.remove(GatewayCapabilitiesResponseEvent.class);
            }
            if (ex != null && !(ex instanceof TimeoutException)) {
                throw new RuntimeException("Failed to get gateway response", (Throwable)ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> startTunnel(GatewayTunnelInfo tunnelInfo) {
        if (!this.isConnected() || this.isInitialSyncInProgress()) {
            String msg = "Gateway is not connected or initial sync in progress so cannot start tunnel: " + String.valueOf(this);
            LOG.info(msg);
            throw new IllegalStateException(msg);
        }
        CompletableFuture future = new CompletableFuture();
        Map<Class<? extends SharedEvent>, Consumer<SharedEvent>> map = this.eventConsumerMap;
        synchronized (map) {
            if (this.eventConsumerMap.containsKey(GatewayTunnelStartResponseEvent.class)) {
                return CompletableFuture.failedFuture(new IllegalArgumentException("A start tunnel request is already pending"));
            }
            this.eventConsumerMap.put(GatewayTunnelStartResponseEvent.class, e -> {
                GatewayTunnelStartResponseEvent response = (GatewayTunnelStartResponseEvent)e;
                if (response != null && response.getError() != null) {
                    throw new RuntimeException("Failed to start tunnel: error=" + response.getError() + ", " + String.valueOf(tunnelInfo));
                }
                future.complete(null);
            });
        }
        this.sendMessageToGateway(new GatewayTunnelStartRequestEvent(this.gatewayService.getTunnelSSHHostname(), this.gatewayService.getTunnelSSHPort(), tunnelInfo));
        return future.orTimeout(10000L, TimeUnit.MILLISECONDS).whenComplete((result, ex) -> {
            Map<Class<? extends SharedEvent>, Consumer<SharedEvent>> map = this.eventConsumerMap;
            synchronized (map) {
                this.eventConsumerMap.remove(GatewayTunnelStartResponseEvent.class);
            }
            if (ex != null && !(ex instanceof TimeoutException)) {
                throw new RuntimeException("Failed to get gateway response", (Throwable)ex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> stopTunnel(GatewayTunnelInfo tunnelInfo) {
        CompletableFuture future = new CompletableFuture();
        Map<Class<? extends SharedEvent>, Consumer<SharedEvent>> map = this.eventConsumerMap;
        synchronized (map) {
            if (this.eventConsumerMap.containsKey(GatewayTunnelStopResponseEvent.class)) {
                return CompletableFuture.failedFuture(new IllegalArgumentException("A stop tunnel request is already pending"));
            }
            this.eventConsumerMap.put(GatewayTunnelStopResponseEvent.class, e -> {
                GatewayTunnelStopResponseEvent response = (GatewayTunnelStopResponseEvent)e;
                if (response != null && response.getError() != null) {
                    throw new RuntimeException("Failed to stop tunnel: error=" + response.getError() + ", " + String.valueOf(tunnelInfo));
                }
                future.complete(null);
            });
        }
        this.sendMessageToGateway(new GatewayTunnelStopRequestEvent(tunnelInfo));
        return future.orTimeout(10000L, TimeUnit.MILLISECONDS).whenComplete((result, ex) -> {
            Map<Class<? extends SharedEvent>, Consumer<SharedEvent>> map = this.eventConsumerMap;
            synchronized (map) {
                this.eventConsumerMap.remove(GatewayTunnelStopResponseEvent.class);
            }
            if (ex != null && !(ex instanceof TimeoutException)) {
                throw new RuntimeException("Failed to get gateway response", (Throwable)ex);
            }
        });
    }

    protected String getRealm() {
        return this.realm;
    }

    protected boolean isDisabled() {
        return this.disabled;
    }

    protected void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.disconnect(GatewayDisconnectEvent.Reason.DISABLED);
    }

    protected String getSessionId() {
        return this.sessionId.get();
    }

    protected void publishAttributeEvent(AttributeEvent event) {
        this.assetProcessingService.sendAttributeEvent(event, GatewayService.class.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void onGatewayEvent(SharedEvent e) {
        block12: {
            try {
                if (this.initialSyncInProgress) {
                    if (e instanceof AssetsEvent) {
                        this.onSyncAssetsResponse((AssetsEvent)e);
                    } else if (e instanceof AttributeEvent) {
                        this.cachedAttributeEvents.add((AttributeEvent)e);
                    } else if (e instanceof AssetEvent) {
                        this.cachedAssetEvents.add((AssetEvent)e);
                    }
                    break block12;
                }
                Map<Class<? extends SharedEvent>, Consumer<SharedEvent>> map = this.eventConsumerMap;
                synchronized (map) {
                    Consumer<SharedEvent> consumer = this.eventConsumerMap.get(e.getClass());
                    if (consumer != null) {
                        consumer.accept(e);
                    }
                }
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, ex, () -> "An error occurred while processing a gateway event: event=" + String.valueOf(e) + ", connector=" + String.valueOf(this));
                this.disconnect(GatewayDisconnectEvent.Reason.SYNC_ERROR);
            }
        }
    }

    protected synchronized void startSync() {
        if (this.syncAborted()) {
            return;
        }
        this.expectedSyncResponseName = ASSET_READ_EVENT_NAME_INITIAL;
        ReadAssetsEvent event = new ReadAssetsEvent(new AssetQuery().select(new AssetQuery.Select().excludeAttributes()).recursive(true));
        event.setMessageID(this.expectedSyncResponseName);
        this.sendMessageToGateway(event);
        this.syncProcessorFuture = this.scheduledExecutorService.schedule(this::onSyncAssetsTimeout, 10000L, TimeUnit.MILLISECONDS);
    }

    protected synchronized void onSyncAssetsTimeout() {
        if (!this.isConnected()) {
            return;
        }
        LOG.info("Gateway sync timeout occurred: " + String.valueOf(this));
        ++this.syncErrors;
        if (this.syncAborted()) {
            return;
        }
        if (this.syncAssetIds == null) {
            this.startSync();
        } else {
            this.requestAssets();
        }
    }

    protected boolean syncAborted() {
        if (this.syncErrors == MAX_SYNC_RETRIES) {
            LOG.warning("Gateway sync max retries reached so disconnecting the gateway: " + String.valueOf(this));
            this.disconnect(GatewayDisconnectEvent.Reason.SYNC_ERROR);
            return true;
        }
        return false;
    }

    protected void requestAssets() {
        if (this.syncAborted()) {
            return;
        }
        String[] requestAssetIds = (String[])this.syncAssetIds.stream().skip(this.syncIndex).limit(SYNC_ASSET_BATCH_SIZE).toArray(String[]::new);
        this.expectedSyncResponseName = ASSET_READ_EVENT_NAME_BATCH + this.syncIndex;
        LOG.fine("Synchronising gateway assets " + this.syncIndex + "1-" + this.syncIndex + requestAssetIds.length + " of " + this.syncAssetIds.size() + ": " + String.valueOf(this));
        ReadAssetsEvent event = new ReadAssetsEvent(new AssetQuery().ids(requestAssetIds));
        event.setMessageID(this.expectedSyncResponseName);
        this.sendMessageToGateway(event);
        this.syncProcessorFuture = this.scheduledExecutorService.schedule(this::requestAssets, 10000L, TimeUnit.MILLISECONDS);
    }

    protected synchronized void onSyncAssetsResponse(AssetsEvent e) {
        if (!this.isConnected()) {
            return;
        }
        String messageId = e.getMessageID();
        if (!this.expectedSyncResponseName.equalsIgnoreCase(messageId)) {
            LOG.info("Unexpected response from gateway so ignoring (expected=" + this.expectedSyncResponseName + ", actual =" + messageId + "): " + String.valueOf(this));
            return;
        }
        this.syncProcessorFuture.cancel(true);
        this.syncProcessorFuture = null;
        boolean isInitialResponse = ASSET_READ_EVENT_NAME_INITIAL.equalsIgnoreCase(messageId);
        if (isInitialResponse) {
            Map gatewayAssetIdParentIdMap = e.getAssets() == null ? Collections.emptyMap() : (Map)e.getAssets().stream().collect(HashMap::new, (m, v) -> m.put(v.getId(), v.getParentId()), HashMap::putAll);
            ToIntFunction<Asset> assetLevelExtractor = asset -> {
                int level = 0;
                String parentId = asset.getParentId();
                while (parentId != null) {
                    ++level;
                    parentId = (String)gatewayAssetIdParentIdMap.get(parentId);
                }
                return level;
            };
            List<Object> list = this.syncAssetIds = e.getAssets() == null ? Collections.emptyList() : e.getAssets().stream().sorted(Comparator.comparingInt(assetLevelExtractor)).map(Asset::getId).collect(Collectors.toList());
            if (this.syncAssetIds.isEmpty()) {
                this.deleteObsoleteLocalAssets();
                this.onInitialSyncComplete();
                return;
            }
            this.requestAssets();
        } else {
            if (this.syncAssetIds == null) {
                LOG.warning("Unexpected gateway initialisation message, requesting disconnect: " + String.valueOf(this));
                this.disconnect(GatewayDisconnectEvent.Reason.SYNC_ERROR);
                return;
            }
            List requestedAssetIds = this.syncAssetIds.stream().skip(this.syncIndex).limit(SYNC_ASSET_BATCH_SIZE).collect(Collectors.toList());
            List<Asset> returnedAssets = e.getAssets() == null ? Collections.emptyList() : e.getAssets();
            this.cachedAssetEvents.removeIf(assetEvent -> {
                boolean remove = requestedAssetIds.stream().anyMatch(id -> id.equals(assetEvent.getId()) && assetEvent.getCause() == AssetEvent.Cause.DELETE);
                if (remove) {
                    this.syncAssetIds.remove(assetEvent.getId());
                    requestedAssetIds.remove(assetEvent.getId());
                }
                return remove;
            });
            if (returnedAssets.size() != requestedAssetIds.size() || !returnedAssets.stream().allMatch(asset -> requestedAssetIds.contains(asset.getId()))) {
                LOG.warning("Retrieved gateway asset batch count or ID mismatch, attempting to re-send the request: " + String.valueOf(this));
                ++this.syncErrors;
                this.requestAssets();
                return;
            }
            returnedAssets = returnedAssets.stream().sorted(Comparator.comparingInt(a -> this.syncAssetIds.indexOf(a.getId()))).toList();
            returnedAssets.stream().map(returnedAsset -> {
                AtomicReference<Asset> latestAssetVersion = new AtomicReference<Asset>((Asset)returnedAsset);
                this.cachedAssetEvents.removeIf(assetEvent -> {
                    boolean remove;
                    boolean bl = remove = assetEvent.getId().equals(returnedAsset.getId()) && (assetEvent.getCause() == AssetEvent.Cause.UPDATE || assetEvent.getCause() == AssetEvent.Cause.READ);
                    if (remove && assetEvent.getAsset().getVersion() > ((Asset)latestAssetVersion.get()).getVersion()) {
                        latestAssetVersion.set(assetEvent.getAsset());
                    }
                    return remove;
                });
                return latestAssetVersion.get();
            }).forEach(this::saveAssetLocally);
            this.syncIndex += requestedAssetIds.size();
            if (this.syncIndex >= this.syncAssetIds.size()) {
                LOG.info("All requested gateway assets retrieved: " + String.valueOf(this));
                HashSet refreshAssets = new HashSet();
                this.cachedAssetEvents.forEach(assetEvent -> {
                    if (assetEvent.getCause() == AssetEvent.Cause.DELETE) {
                        this.syncAssetIds.remove(assetEvent.getId());
                    } else if (assetEvent.getCause() == AssetEvent.Cause.CREATE) {
                        this.syncAssetIds.add(assetEvent.getId());
                        try {
                            this.saveAssetLocally(assetEvent.getAsset());
                        }
                        catch (Exception ex) {
                            LOG.log(Level.SEVERE, "Failed to add new gateway asset (Asset=" + String.valueOf(assetEvent.getAsset()) + "): " + String.valueOf(this), ex);
                        }
                    } else {
                        refreshAssets.add(assetEvent.getId());
                    }
                });
                this.deleteObsoleteLocalAssets();
                this.onInitialSyncComplete();
                this.cachedAttributeEvents.forEach(attributeEvent -> {
                    String assetId = attributeEvent.getId();
                    if (!refreshAssets.contains(assetId)) {
                        LOG.info("1 or more gateway asset attribute values have changed so requesting the asset again (Asset<?> ID=" + assetId + ": " + String.valueOf(this));
                        refreshAssets.add(assetId);
                    }
                });
                refreshAssets.forEach(id -> this.sendMessageToGateway(new ReadAssetEvent(id)));
            } else {
                this.requestAssets();
            }
        }
    }

    protected void deleteObsoleteLocalAssets() {
        boolean deleted;
        List<Asset<?>> localAssets = this.assetStorageService.findAll(new AssetQuery().select(new AssetQuery.Select().excludeAttributes()).recursive(true).parents(new String[]{this.gatewayId}));
        List<String> obsoleteLocalAssetIds = localAssets.stream().map(Asset::getId).filter(id -> !this.syncAssetIds.contains(GatewayConnector.mapAssetId(this.gatewayId, id, true))).toList();
        if (!obsoleteLocalAssetIds.isEmpty() && !(deleted = this.deleteAssetsLocally(obsoleteLocalAssetIds))) {
            LOG.warning("Failed to delete obsolete local gateway assets; assets are not correctly synced: " + String.valueOf(this));
        }
    }

    protected void onInitialSyncComplete() {
        this.initialSyncInProgress = false;
        this.cachedAssetEvents.clear();
        this.cachedAttributeEvents.clear();
        this.getCapabilities().whenComplete((response, error) -> {
            if (error != null) {
                LOG.warning("An error occurred whilst getting the gateway capabilities, assuming no support: " + String.valueOf(this));
            }
            this.tunnellingSupported = response != null && response.isTunnelingSupported();
            this.publishAttributeEvent(new AttributeEvent(this.gatewayId, GatewayAsset.TUNNELING_SUPPORTED, (Object)this.tunnellingSupported));
            this.publishAttributeEvent(new AttributeEvent(this.gatewayId, GatewayAsset.STATUS, (Object)ConnectionStatus.CONNECTED));
        });
    }

    protected synchronized void onAssetEvent(AssetEvent e) {
        switch (e.getCause()) {
            case CREATE: 
            case READ: 
            case UPDATE: {
                this.saveAssetLocally(e.getAsset());
                break;
            }
            case DELETE: {
                this.deleteAssetsLocally(Collections.singletonList(GatewayConnector.mapAssetId(this.gatewayId, e.getId(), false)));
            }
        }
    }

    protected void onAttributeEvent(AttributeEvent e) {
        this.publishAttributeEvent(new AttributeEvent(GatewayConnector.mapAssetId(this.gatewayId, e.getId(), false), e.getName(), e.getValue().orElse(null), Long.valueOf(e.getTimestamp())));
    }

    protected <T extends Asset<?>> T saveAssetLocally(T asset) {
        String assetId = asset.getId();
        asset.setId(GatewayConnector.mapAssetId(this.gatewayId, assetId, false));
        asset.setParentId(asset.getParentId() != null ? GatewayConnector.mapAssetId(this.gatewayId, asset.getParentId(), false) : this.gatewayId);
        asset.setRealm(this.realm);
        LOG.fine("Creating/updating gateway asset: Asset ID=" + assetId + ", Asset ID Mapped=" + asset.getId() + ": " + String.valueOf(this));
        return this.assetStorageService.merge(asset, true, this.gatewayAsset, null);
    }

    protected boolean deleteAssetsLocally(List<String> assetIds) {
        LOG.fine("Removing gateway asset: Asset IDs=" + Arrays.toString(assetIds.toArray()) + ": " + String.valueOf(this));
        return this.assetStorageService.delete(assetIds, true);
    }

    public GatewayAsset getGatewayAsset() {
        return this.gatewayAsset;
    }

    public String toString() {
        return GatewayConnector.class.getSimpleName() + "{gatewayId='" + this.gatewayId + "'}";
    }

    public static String mapAssetId(String gatewayId, String assetId, boolean outbound) {
        Pair gatewayIdMappers = ASSET_ID_MAPPERS.computeIfAbsent(gatewayId, gwId -> {
            int g1 = gatewayId.charAt(0) % ALPHA_NUMERIC_CHARACTERS.size();
            int g2 = gatewayId.charAt(1) % ALPHA_NUMERIC_CHARACTERS.size();
            BiFunction<Integer, String, String> mapper = (sign, id) -> {
                int a1 = (ALPHA_NUMERIC_CHARACTERS.indexOf(id.charAt(0)) + sign * g1 + ALPHA_NUMERIC_CHARACTERS.size()) % ALPHA_NUMERIC_CHARACTERS.size();
                int a2 = (ALPHA_NUMERIC_CHARACTERS.indexOf(id.charAt(1)) + sign * g2 + ALPHA_NUMERIC_CHARACTERS.size()) % ALPHA_NUMERIC_CHARACTERS.size();
                return String.valueOf((char)ALPHA_NUMERIC_CHARACTERS.get(a1).intValue()) + (char)ALPHA_NUMERIC_CHARACTERS.get(a2).intValue() + id.substring(2);
            };
            return new Pair(id -> (String)mapper.apply(1, (String)id), id -> (String)mapper.apply(-1, (String)id));
        });
        return outbound ? (String)((Function)gatewayIdMappers.value).apply(assetId) : (String)((Function)gatewayIdMappers.key).apply(assetId);
    }

    static {
        ALPHA_NUMERIC_CHARACTERS.addAll(Stream.concat(Stream.concat(IntStream.rangeClosed(97, 122).boxed(), IntStream.rangeClosed(65, 90).boxed()), IntStream.rangeClosed(48, 57).boxed()).toList());
    }
}

