/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.gateway;

import io.netty.channel.ChannelHandler;
import jakarta.persistence.EntityManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.openremote.agent.protocol.io.AbstractNettyIOClient;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.timer.TimerService;
import org.openremote.container.util.MapAccess;
import org.openremote.manager.asset.AssetProcessingService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.gateway.GatewayClientResourceImpl;
import org.openremote.manager.gateway.GatewayIOClient;
import org.openremote.manager.gateway.GatewayTunnelFactory;
import org.openremote.manager.gateway.JSchGatewayTunnelFactory;
import org.openremote.manager.rules.AssetQueryPredicate;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetEvent;
import org.openremote.model.asset.AssetFilter;
import org.openremote.model.asset.AssetsEvent;
import org.openremote.model.asset.ReadAssetsEvent;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeInfo;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.attribute.MetaMap;
import org.openremote.model.auth.OAuthClientCredentialsGrant;
import org.openremote.model.auth.OAuthGrant;
import org.openremote.model.event.shared.EventFilter;
import org.openremote.model.event.shared.EventSubscription;
import org.openremote.model.event.shared.RealmFilter;
import org.openremote.model.event.shared.SharedEvent;
import org.openremote.model.gateway.GatewayAssetSyncRule;
import org.openremote.model.gateway.GatewayAttributeFilter;
import org.openremote.model.gateway.GatewayCapabilitiesRequestEvent;
import org.openremote.model.gateway.GatewayCapabilitiesResponseEvent;
import org.openremote.model.gateway.GatewayConnection;
import org.openremote.model.gateway.GatewayConnectionStatusEvent;
import org.openremote.model.gateway.GatewayDisconnectEvent;
import org.openremote.model.gateway.GatewayTunnelStartRequestEvent;
import org.openremote.model.gateway.GatewayTunnelStartResponseEvent;
import org.openremote.model.gateway.GatewayTunnelStopRequestEvent;
import org.openremote.model.gateway.GatewayTunnelStopResponseEvent;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.Pair;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;

public class GatewayClientService
extends RouteBuilder
implements ContainerService {
    public static final int PRIORITY = 2147482447;
    private static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.GATEWAY, (String)GatewayClientService.class.getName());
    public static final String CLIENT_EVENT_SESSION_PREFIX = GatewayClientService.class.getSimpleName() + ":";
    public static final String OR_GATEWAY_TUNNEL_LOCALHOST_REWRITE = "OR_GATEWAY_TUNNEL_LOCALHOST_REWRITE";
    protected AssetStorageService assetStorageService;
    protected AssetProcessingService assetProcessingService;
    protected PersistenceService persistenceService;
    protected ClientEventService clientEventService;
    protected TimerService timerService;
    protected ManagerIdentityService identityService;
    protected final Map<String, GatewayConnection> connectionRealmMap = new HashMap<String, GatewayConnection>();
    protected final Map<String, GatewayIOClient> clientRealmMap = new HashMap<String, GatewayIOClient>();
    protected GatewayTunnelFactory gatewayTunnelFactory;
    protected Map<String, Map<AttributeRef, Long>> clientAttributeTimestamps = new ConcurrentHashMap<String, Map<AttributeRef, Long>>();
    protected Consumer<AssetEvent> realmAssetEventConsumer;
    protected Consumer<AttributeEvent> realmAttributeEventConsumer;

    public void init(Container container) throws Exception {
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.assetProcessingService = (AssetProcessingService)container.getService(AssetProcessingService.class);
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        this.clientEventService = (ClientEventService)container.getService(ClientEventService.class);
        this.timerService = (TimerService)container.getService(TimerService.class);
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        String tunnelKeyFile = MapAccess.getString((Map)container.getConfig(), (String)"OR_GATEWAY_TUNNEL_SSH_KEY_FILE", null);
        String localhostRewrite = MapAccess.getString((Map)container.getConfig(), (String)OR_GATEWAY_TUNNEL_LOCALHOST_REWRITE, null);
        if (!TextUtil.isNullOrEmpty((String)tunnelKeyFile)) {
            File f = new File(tunnelKeyFile);
            if (f.exists()) {
                LOG.info("Gateway tunnelling SSH key file found at: " + f.getAbsolutePath());
                if (!TextUtil.isNullOrEmpty((String)localhostRewrite)) {
                    LOG.info("Gateway tunnelling localhostRewrite set to: " + localhostRewrite);
                }
                this.gatewayTunnelFactory = new JSchGatewayTunnelFactory(f, localhostRewrite);
            } else {
                LOG.warning("Gateway tunnelling SSH key file does not exist, tunnelling support disabled: " + f.getAbsolutePath());
            }
        }
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new GatewayClientResourceImpl(this.timerService, this.identityService, this));
        ((MessageBrokerService)container.getService(MessageBrokerService.class)).getContext().addRoutes((RoutesBuilder)this);
        this.clientEventService.addSubscriptionAuthorizer((realm, authContext, eventSubscription) -> {
            if (!eventSubscription.isEventType(GatewayConnectionStatusEvent.class)) {
                return false;
            }
            if (authContext == null) {
                return false;
            }
            if (!authContext.isSuperUser()) {
                EventSubscription subscription = eventSubscription;
                subscription.setFilter((EventFilter)new RealmFilter(authContext.getAuthenticatedRealmName()));
            }
            return true;
        });
    }

    public void start(Container container) throws Exception {
        this.connectionRealmMap.putAll(((List)this.persistenceService.doReturningTransaction(entityManager -> entityManager.createQuery("select gc from GatewayConnection gc", GatewayConnection.class).getResultList())).stream().collect(Collectors.toMap(GatewayConnection::getLocalRealm, gc -> gc)));
        this.connectionRealmMap.forEach((realm, connection) -> {
            if (!connection.isDisabled()) {
                this.clientRealmMap.put((String)realm, this.createGatewayClient((GatewayConnection)connection));
                this.clientAttributeTimestamps.put(connection.getLocalRealm(), new ConcurrentHashMap());
            }
        });
    }

    public void stop(Container container) throws Exception {
        this.clientRealmMap.forEach((realm, client) -> {
            if (client != null) {
                this.destroyGatewayClient(this.connectionRealmMap.get(realm), (GatewayIOClient)((Object)client));
            }
        });
        this.clientRealmMap.clear();
        this.connectionRealmMap.clear();
        this.clientAttributeTimestamps.clear();
    }

    public void configure() throws Exception {
        this.from("seda://PersistenceTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&size=25000").routeId("Persistence-GatewayConnection").filter(PersistenceService.isPersistenceEventForEntityType(GatewayConnection.class)).process(exchange -> {
            PersistenceEvent persistenceEvent = (PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class);
            GatewayConnection connection = (GatewayConnection)persistenceEvent.getEntity();
            this.processConnectionChange(connection, persistenceEvent.getCause());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void processConnectionChange(GatewayConnection connection, PersistenceEvent.Cause cause) {
        LOG.info("Modified gateway client connection '" + String.valueOf(cause) + "': " + String.valueOf(connection));
        Map<String, GatewayIOClient> map = this.clientRealmMap;
        synchronized (map) {
            switch (cause) {
                case UPDATE: {
                    GatewayIOClient client = this.clientRealmMap.remove(connection.getLocalRealm());
                    this.clientAttributeTimestamps.remove(connection.getLocalRealm());
                    if (client != null) {
                        this.destroyGatewayClient(connection, client);
                    }
                }
                case CREATE: {
                    this.connectionRealmMap.put(connection.getLocalRealm(), connection);
                    if (connection.isDisabled()) break;
                    this.clientRealmMap.put(connection.getLocalRealm(), this.createGatewayClient(connection));
                    this.clientAttributeTimestamps.put(connection.getLocalRealm(), new ConcurrentHashMap());
                    break;
                }
                case DELETE: {
                    this.connectionRealmMap.remove(connection.getLocalRealm());
                    this.clientAttributeTimestamps.remove(connection.getLocalRealm());
                    GatewayIOClient client = this.clientRealmMap.remove(connection.getLocalRealm());
                    if (client == null) break;
                    this.destroyGatewayClient(connection, client);
                }
            }
        }
    }

    protected GatewayIOClient createGatewayClient(GatewayConnection connection) {
        if (connection.isDisabled()) {
            LOG.info("Disabled gateway client connection so ignoring: " + String.valueOf(connection));
            return null;
        }
        LOG.info("Creating gateway IO client: " + String.valueOf(connection));
        try {
            GatewayIOClient client = new GatewayIOClient(new URIBuilder().setScheme(connection.isSecured() ? "wss" : "ws").setHost(connection.getHost()).setPort(connection.getPort() == null ? -1 : connection.getPort()).setPath("websocket/events").setParameter("Realm", connection.getRealm()).build(), null, (OAuthGrant)new OAuthClientCredentialsGrant(new URIBuilder().setScheme(connection.isSecured() ? "https" : "http").setHost(connection.getHost()).setPort(connection.getPort() == null ? -1 : connection.getPort()).setPath("auth/realms/" + connection.getRealm() + "/protocol/openid-connect/token").build().toString(), connection.getClientId(), connection.getClientSecret(), null).setBasicAuthHeader(true));
            client.setEncoderDecoderProvider(() -> new ChannelHandler[]{new AbstractNettyIOClient.MessageToMessageDecoder(String.class, (AbstractNettyIOClient)client)});
            client.addConnectionStatusConsumer(connectionStatus -> this.onGatewayClientConnectionStatusChanged(connection, (ConnectionStatus)connectionStatus));
            client.addMessageConsumer(message -> this.onCentralManagerMessage(connection, (String)message));
            this.realmAssetEventConsumer = assetEvent -> this.sendAssetEvent(connection, (AssetEvent)assetEvent);
            this.clientEventService.addSubscription(AssetEvent.class, new AssetFilter().setRealm(connection.getLocalRealm()), this.realmAssetEventConsumer);
            this.realmAttributeEventConsumer = attributeEvent -> this.sendAttributeEvent(connection, (AttributeEvent)attributeEvent);
            this.clientEventService.addSubscription(AttributeEvent.class, this.getOutboundAttributeEventFilter(connection), this.realmAttributeEventConsumer);
            client.connect();
            return client;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Creating gateway IO client failed so marking connection as disabled: " + String.valueOf(connection), e);
            connection.setDisabled(true);
            this.setConnection(connection);
            return null;
        }
    }

    protected void sendAssetEvent(GatewayConnection connection, AssetEvent event) {
        if (connection.getAssetSyncRules() != null) {
            event = (AssetEvent)ValueUtil.clone((Object)event);
            this.applySyncRules(event.getAsset(), connection.getAssetSyncRules());
        }
        this.sendCentralManagerMessage(connection.getLocalRealm(), this.messageToString("EVENT:", event));
    }

    protected void sendAttributeEvent(GatewayConnection connection, AttributeEvent event) {
        if (connection.getAssetSyncRules() != null) {
            event.setMeta((event = (AttributeEvent)ValueUtil.clone((Object)event)).getMeta() != null ? event.getMeta() : new MetaMap());
            this.applySyncRuleToMeta(event.getName(), event.getMeta(), connection.getAssetSyncRules().getOrDefault(event.getAssetType(), (GatewayAssetSyncRule)connection.getAssetSyncRules().get("*")));
        }
        this.sendCentralManagerMessage(connection.getLocalRealm(), this.messageToString("EVENT:", event));
    }

    protected EventFilter<AttributeEvent> getOutboundAttributeEventFilter(GatewayConnection gatewayConnection) {
        List<Object> predicatesWithFilters = gatewayConnection.getAttributeFilters() != null && !gatewayConnection.getAttributeFilters().isEmpty() ? gatewayConnection.getAttributeFilters().stream().map(filter -> {
            AssetQueryPredicate predicate = filter.getMatcher() != null ? new AssetQueryPredicate(this.timerService, this.assetStorageService, filter.getMatcher()) : null;
            return new Pair((Object)predicate, filter);
        }).toList() : Collections.emptyList();
        return ev -> {
            GatewayAssetSyncRule syncRule;
            if (!gatewayConnection.getLocalRealm().equals(ev.getRealm())) {
                return null;
            }
            if (((Object)((Object)this)).getClass().getSimpleName().equals(ev.getSource())) {
                return ev;
            }
            boolean allowEvent = predicatesWithFilters.stream().filter(predicateWithFilter -> {
                if (predicateWithFilter.key == null) {
                    return true;
                }
                return ((AssetQueryPredicate)predicateWithFilter.key).test((AttributeInfo)ev);
            }).findFirst().map(predicatesWithFilter -> {
                GatewayAttributeFilter filter = (GatewayAttributeFilter)predicatesWithFilter.value;
                if (filter.isAllow()) {
                    return true;
                }
                if (filter.getSkipAlways() != null && filter.getSkipAlways().booleanValue()) {
                    return false;
                }
                if (filter.getValueChange() != null && filter.getValueChange().booleanValue() && !Objects.equals(ev.getValue(), ev.getOldValue())) {
                    LOG.finest(() -> "Gateway client for '" + gatewayConnection.getLocalRealm() + "' value change has allowed attribute event: " + String.valueOf(ev.getRef()));
                    return true;
                }
                if (filter.getDelta() != null && Number.class.isAssignableFrom(ev.getTypeClass())) {
                    double oldValue;
                    double delta = filter.getDelta();
                    double value = ev.getValue(Double.class).orElse(0.0);
                    if (Math.abs(value - (oldValue = ev.getOldValue(Double.class).orElse(0.0).doubleValue())) > Math.abs(delta)) {
                        LOG.finest(() -> "Gateway client for '" + gatewayConnection.getLocalRealm() + "' delta setting has allowed attribute event: " + String.valueOf(ev.getRef()));
                        return true;
                    }
                }
                if (filter.getDurationParsed().isPresent()) {
                    boolean allow = filter.getDurationParsed().map(durationMillis -> {
                        Map<AttributeRef, Long> attributeTimestamps = this.clientAttributeTimestamps.get(gatewayConnection.getLocalRealm());
                        Long lastSendMillis = attributeTimestamps.get(ev.getRef());
                        if (lastSendMillis == null || this.timerService.getCurrentTimeMillis() - lastSendMillis > durationMillis) {
                            LOG.finest(() -> "Gateway client for '" + gatewayConnection.getLocalRealm() + "' duration setting has allowed attribute event: " + String.valueOf(ev.getRef()));
                            attributeTimestamps.put(ev.getRef(), this.timerService.getCurrentTimeMillis());
                            return true;
                        }
                        LOG.finest(() -> "Gateway client for '" + gatewayConnection.getLocalRealm() + "' duration setting has blocked attribute event: " + String.valueOf(ev.getRef()));
                        return false;
                    }).orElse(true);
                    return allow;
                }
                return false;
            }).orElse(true);
            if (allowEvent && gatewayConnection.getAssetSyncRules() != null && (syncRule = gatewayConnection.getAssetSyncRules().getOrDefault(ev.getAssetType(), (GatewayAssetSyncRule)gatewayConnection.getAssetSyncRules().get("*"))) != null && syncRule.excludeAttributes != null && syncRule.excludeAttributes.contains(ev.getName())) {
                LOG.finer(() -> "Attribute event excluded due to sync rule: " + String.valueOf(ev));
                allowEvent = false;
            }
            return allowEvent ? ev : null;
        };
    }

    protected void destroyGatewayClient(GatewayConnection connection, GatewayIOClient client) {
        if (client == null) {
            return;
        }
        LOG.info("Destroying gateway IO client: " + String.valueOf(connection));
        try {
            client.disconnect();
            client.removeAllConnectionStatusConsumers();
            client.removeAllMessageConsumers();
            client.setEncoderDecoderProvider(null);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "An exception occurred whilst trying to disconnect the gateway IO client", e);
        }
        if (connection != null) {
            this.clientEventService.removeSubscription(this.realmAttributeEventConsumer);
            this.clientEventService.removeSubscription(this.realmAssetEventConsumer);
        }
    }

    protected void onGatewayClientConnectionStatusChanged(GatewayConnection connection, ConnectionStatus connectionStatus) {
        LOG.info("Connection status change for gateway IO client '" + String.valueOf(connectionStatus) + "': " + String.valueOf(connection));
        this.clientEventService.publishEvent(new GatewayConnectionStatusEvent(this.timerService.getCurrentTimeMillis(), connection.getLocalRealm(), connectionStatus));
        if (this.gatewayTunnelFactory != null) {
            LOG.finer("Terminating all gateway tunnel sessions");
            this.gatewayTunnelFactory.stopAll();
        }
    }

    protected void onCentralManagerMessage(GatewayConnection connection, String message) {
        SharedEvent event = this.messageFromString(message, "EVENT:", SharedEvent.class);
        if (event != null) {
            if (event instanceof GatewayDisconnectEvent) {
                if (((GatewayDisconnectEvent)event).getReason() == GatewayDisconnectEvent.Reason.PERMANENT_ERROR) {
                    LOG.info("Central manager requested disconnect due to permanent error (likely this version of the edge gateway software is not compatible with that manager version)");
                    this.destroyGatewayClient(connection, this.clientRealmMap.get(connection.getLocalRealm()));
                    this.clientRealmMap.put(connection.getLocalRealm(), null);
                }
            } else if (event instanceof GatewayCapabilitiesRequestEvent) {
                LOG.fine("Central manager requested specifications / capabilities of the gateway.");
                GatewayCapabilitiesResponseEvent responseEvent = new GatewayCapabilitiesResponseEvent(this.gatewayTunnelFactory != null);
                responseEvent.setMessageID(event.getMessageID());
                this.sendCentralManagerMessage(connection.getLocalRealm(), this.messageToString("EVENT:", responseEvent));
            } else if (event instanceof GatewayTunnelStartRequestEvent) {
                GatewayTunnelStartRequestEvent gatewayTunnelStartRequestEvent = (GatewayTunnelStartRequestEvent)event;
                if (this.gatewayTunnelFactory == null) {
                    return;
                }
                LOG.info("Start tunnel request received: " + String.valueOf(gatewayTunnelStartRequestEvent));
                String error = null;
                try {
                    this.gatewayTunnelFactory.startTunnel(gatewayTunnelStartRequestEvent);
                }
                catch (Exception e) {
                    error = e.getMessage();
                }
                GatewayTunnelStartResponseEvent responseEvent = new GatewayTunnelStartResponseEvent(error);
                responseEvent.setMessageID(event.getMessageID());
                this.sendCentralManagerMessage(connection.getLocalRealm(), this.messageToString("EVENT:", responseEvent));
            } else if (event instanceof GatewayTunnelStopRequestEvent) {
                GatewayTunnelStopRequestEvent stopRequestEvent = (GatewayTunnelStopRequestEvent)event;
                if (this.gatewayTunnelFactory == null) {
                    return;
                }
                LOG.info("Stop tunnel request received: " + String.valueOf(stopRequestEvent));
                String error = null;
                try {
                    this.gatewayTunnelFactory.stopTunnel(stopRequestEvent.getInfo());
                }
                catch (Exception e) {
                    error = e.getMessage();
                }
                GatewayTunnelStopResponseEvent responseEvent = new GatewayTunnelStopResponseEvent(error);
                responseEvent.setMessageID(event.getMessageID());
                this.sendCentralManagerMessage(connection.getLocalRealm(), this.messageToString("EVENT:", responseEvent));
            } else if (event instanceof AttributeEvent) {
                this.assetProcessingService.sendAttributeEvent((AttributeEvent)event, ((Object)((Object)this)).getClass().getSimpleName());
            } else if (event instanceof AssetEvent) {
                AssetEvent assetEvent = (AssetEvent)event;
                if (assetEvent.getCause() == AssetEvent.Cause.CREATE || assetEvent.getCause() == AssetEvent.Cause.UPDATE) {
                    Asset asset = assetEvent.getAsset();
                    asset.setRealm(connection.getLocalRealm());
                    LOG.finest("Request from central manager to create/update an asset: Realm=" + connection.getLocalRealm() + ", Asset<?> ID=" + asset.getId());
                    try {
                        asset = this.assetStorageService.merge(asset, true);
                    }
                    catch (Exception e) {
                        LOG.log(Level.INFO, "Request from central manager to create/update an asset failed: Realm=" + connection.getLocalRealm() + ", Asset<?> ID=" + asset.getId(), e);
                    }
                }
            } else if (event instanceof ReadAssetsEvent) {
                ReadAssetsEvent readAssets = (ReadAssetsEvent)event;
                AssetQuery query = readAssets.getAssetQuery();
                query.realm(new RealmPredicate(connection.getLocalRealm()));
                List<Object> assets = this.assetStorageService.findAll(readAssets.getAssetQuery());
                assets = assets.stream().map(it -> this.applySyncRules((Asset<?>)it, connection.getAssetSyncRules())).collect(Collectors.toList());
                AssetsEvent responseEvent = new AssetsEvent(assets);
                responseEvent.setMessageID(event.getMessageID());
                this.sendCentralManagerMessage(connection.getLocalRealm(), this.messageToString("EVENT:", responseEvent));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCentralManagerMessage(String realm, String message) {
        GatewayIOClient client;
        Map<String, GatewayIOClient> map = this.clientRealmMap;
        synchronized (map) {
            client = this.clientRealmMap.get(realm);
        }
        if (client != null) {
            client.sendMessage(message);
        }
    }

    protected String getClientSessionKey(GatewayConnection connection) {
        return CLIENT_EVENT_SESSION_PREFIX + connection.getLocalRealm();
    }

    protected <T> T messageFromString(String message, String prefix, Class<T> clazz) {
        message = message.substring(prefix.length());
        return ValueUtil.parse((String)message, clazz).orElse(null);
    }

    protected String messageToString(String prefix, Object message) {
        String str = ValueUtil.asJSON((Object)message).orElse("null");
        return prefix + str;
    }

    protected List<GatewayConnection> getConnections() {
        return new ArrayList<GatewayConnection>(this.connectionRealmMap.values());
    }

    public void setConnection(GatewayConnection connection) {
        LOG.info("Updating/creating gateway connection: " + String.valueOf(connection));
        this.persistenceService.doTransaction(em -> em.merge((Object)connection));
    }

    public boolean deleteConnections(List<String> realms) {
        LOG.info("Deleting gateway connections for the following realm(s): " + Arrays.toString(realms.toArray()));
        try {
            this.persistenceService.doTransaction(em -> {
                List connections = em.createQuery("select gc from GatewayConnection gc where gc.localRealm in :realms", GatewayConnection.class).setParameter("realms", (Object)realms).getResultList();
                if (connections.size() != realms.size()) {
                    throw new IllegalArgumentException("Cannot delete one or more requested gateway connections as they don't exist");
                }
                connections.forEach(arg_0 -> ((EntityManager)em).remove(arg_0));
            });
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected ConnectionStatus getConnectionStatus(String realm) {
        GatewayConnection connection = this.connectionRealmMap.get(realm);
        if (connection == null) {
            return null;
        }
        if (connection.isDisabled()) {
            return ConnectionStatus.DISABLED;
        }
        GatewayIOClient client = this.clientRealmMap.get(realm);
        return client != null ? client.getConnectionStatus() : null;
    }

    protected Asset<?> applySyncRules(Asset<?> asset, Map<String, GatewayAssetSyncRule> assetSyncRules) {
        if (asset == null || assetSyncRules == null) {
            return asset;
        }
        GatewayAssetSyncRule syncRule = assetSyncRules.getOrDefault(asset.getType(), assetSyncRules.get("*"));
        if (syncRule == null) {
            return asset;
        }
        List<Attribute> attributes = asset.getAttributes().stream().filter(it -> syncRule.excludeAttributes == null || !syncRule.excludeAttributes.contains(it.getName())).peek(attribute -> this.applySyncRuleToMeta(attribute.getName(), attribute.getMeta(), syncRule)).toList();
        asset.setAttributes(attributes);
        return asset;
    }

    protected void applySyncRuleToMeta(String attributeName, MetaMap meta, GatewayAssetSyncRule syncRule) {
        Map addMetaRules;
        List excludeMetaRules;
        if (syncRule == null) {
            return;
        }
        if (syncRule.excludeAttributeMeta != null && !meta.isEmpty() && (excludeMetaRules = syncRule.excludeAttributeMeta.getOrDefault(attributeName, (List)syncRule.excludeAttributeMeta.get("*"))) != null && !excludeMetaRules.isEmpty()) {
            meta.keySet().removeIf(excludeMetaRules::contains);
        }
        if (syncRule.addAttributeMeta != null && (addMetaRules = (Map)syncRule.addAttributeMeta.getOrDefault(attributeName, (MetaMap)syncRule.addAttributeMeta.get("*"))) != null && !addMetaRules.isEmpty()) {
            meta.addAll(addMetaRules);
        }
    }
}

