/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.gateway;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.gateway.GatewayClientService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.gateway.GatewayClientResource;
import org.openremote.model.gateway.GatewayConnection;
import org.openremote.model.http.RequestParams;
import org.openremote.model.query.filter.RealmPredicate;

public class GatewayClientResourceImpl
extends ManagerWebResource
implements GatewayClientResource {
    protected GatewayClientService gatewayClientService;

    public GatewayClientResourceImpl(TimerService timerService, ManagerIdentityService identityService, GatewayClientService gatewayClientService) {
        super(timerService, identityService);
        this.gatewayClientService = gatewayClientService;
    }

    public GatewayConnection getConnection(RequestParams requestParams, String realm) {
        if (!realm.equals(this.getAuthenticatedRealmName()) && !this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try {
            return this.gatewayClientService.getConnections().stream().filter(c -> realm.equals(c.getLocalRealm())).findFirst().orElse(null);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    public ConnectionStatus getConnectionStatus(RequestParams requestParams, String realm) {
        if (!realm.equals(this.getAuthenticatedRealmName()) && !this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return this.gatewayClientService.getConnectionStatus(realm);
    }

    public List<GatewayConnection> getConnections(RequestParams requestParams) {
        if (!this.isSuperUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try {
            return this.gatewayClientService.getConnections();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    public void setConnection(RequestParams requestParams, String realm, GatewayConnection connection) {
        if (!realm.equals(this.getAuthenticatedRealmName()) && !this.isSuperUser()) {
            throw new WebApplicationException("Gateway connection can only be created in the users realm", Response.Status.FORBIDDEN);
        }
        connection.setLocalRealm(realm);
        if (connection.getAttributeFilters() != null) {
            connection.getAttributeFilters().forEach(filter -> {
                if (filter.getMatcher() != null) {
                    filter.getMatcher().realm(new RealmPredicate(realm));
                }
            });
        }
        try {
            this.gatewayClientService.setConnection(connection);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }

    public void deleteConnection(RequestParams requestParams, String realm) {
        this.deleteConnections(requestParams, Collections.singletonList(realm));
    }

    public void deleteConnections(RequestParams requestParams, List<String> realms) {
        if (realms.isEmpty()) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!(realms.size() <= 1 && this.getAuthenticatedRealmName().equals(realms.get(0)) || this.isSuperUser())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try {
            boolean deleted = this.gatewayClientService.deleteConnections(realms);
            if (!deleted) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }
}

