/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.event;

import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.SecurityConstraint;
import io.undertow.servlet.api.SecurityInfo;
import io.undertow.servlet.api.WebResourceCollection;
import java.net.URI;
import org.apache.camel.component.undertow.HttpHandlerRegistrationInfo;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowHostKey;
import org.apache.camel.component.undertow.UndertowHostOptions;
import org.openremote.container.web.WebService;
import org.openremote.model.Container;

public class UndertowHost
implements org.apache.camel.component.undertow.UndertowHost {
    protected final Container container;
    protected final UndertowHostKey key;
    protected final UndertowHostOptions options;
    protected final Undertow undertow;
    protected DeploymentInfo deployment;
    protected WebService.RequestHandler websocketHttpHandler;
    protected HttpHandler camelHandler;

    public UndertowHost(Container container, UndertowHostKey key, UndertowHostOptions options) {
        this.container = container;
        this.undertow = ((WebService)container.getService(WebService.class)).getUndertow();
        this.key = key;
        this.options = options;
    }

    public void validateEndpointURI(URI httpURI) {
    }

    public HttpHandler registerHandler(UndertowConsumer consumer, HttpHandlerRegistrationInfo registrationInfo, HttpHandler handler) {
        if (this.camelHandler != null) {
            return this.camelHandler;
        }
        String path = registrationInfo.getUri().getPath();
        String deploymentName = "Camel WebSocket Deployment";
        this.deployment = Servlets.deployment().setDeploymentName(deploymentName).setContextPath(path).setClassLoader(this.getClass().getClassLoader()).addInnerHandlerChainWrapper(h -> handler);
        WebResourceCollection resourceCollection = new WebResourceCollection();
        resourceCollection.addUrlPattern("/*");
        SecurityConstraint constraint = new SecurityConstraint();
        constraint.setEmptyRoleSemantic(SecurityInfo.EmptyRoleSemantic.PERMIT);
        constraint.addWebResourceCollection(resourceCollection);
        this.deployment.addSecurityConstraints(new SecurityConstraint[]{constraint});
        HttpHandler deploymentHandler = WebService.addServletDeployment((Container)this.container, (DeploymentInfo)this.deployment, (boolean)true);
        this.websocketHttpHandler = WebService.pathStartsWithHandler((String)deploymentName, (String)path, (HttpHandler)deploymentHandler);
        ((WebService)this.container.getService(WebService.class)).getRequestHandlers().add(0, this.websocketHttpHandler);
        this.camelHandler = handler;
        return handler;
    }

    public void unregisterHandler(UndertowConsumer consumer, HttpHandlerRegistrationInfo registrationInfo) {
        WebService webService = (WebService)this.container.getService(WebService.class);
        if (this.deployment != null) {
            webService.removeServletDeployment(this.deployment);
            this.deployment = null;
        }
        webService.getRequestHandlers().remove(this.websocketHttpHandler);
        this.websocketHttpHandler = null;
    }
}

