/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.event;

import java.util.logging.Logger;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverters;
import org.openremote.model.event.TriggeredEventSubscription;
import org.openremote.model.event.shared.CancelEventSubscription;
import org.openremote.model.event.shared.EventSubscription;
import org.openremote.model.event.shared.SharedEvent;
import org.openremote.model.event.shared.UnauthorizedEventSubscription;
import org.openremote.model.util.ValueUtil;

public class EventTypeConverters
implements TypeConverters {
    private static final Logger LOG = Logger.getLogger(EventTypeConverters.class.getName());

    @Converter
    public String writeEvent(SharedEvent event, Exchange exchange) throws Exception {
        return "EVENT:" + ValueUtil.JSON.writeValueAsString((Object)event);
    }

    @Converter
    public String writeEventArray(SharedEvent[] event, Exchange exchange) throws Exception {
        return "EVENT:" + ValueUtil.JSON.writeValueAsString((Object)event);
    }

    @Converter
    public String writeTriggeredEventSubscription(TriggeredEventSubscription triggeredEventSubscription, Exchange exchange) throws Exception {
        return "TRIGGERED:" + ValueUtil.JSON.writeValueAsString((Object)triggeredEventSubscription);
    }

    @Converter
    public SharedEvent readEvent(String string, Exchange exchange) throws Exception {
        if (!string.startsWith("EVENT:")) {
            return null;
        }
        string = string.substring("EVENT:".length());
        return (SharedEvent)ValueUtil.JSON.readValue(string, SharedEvent.class);
    }

    @Converter
    public String writeEventSubscription(EventSubscription eventSubscription, Exchange exchange) throws Exception {
        return (eventSubscription.isSubscribed() ? "SUBSCRIBED:" : "SUBSCRIBE:") + ValueUtil.JSON.writeValueAsString((Object)eventSubscription);
    }

    @Converter
    public EventSubscription readEventSubscription(String string, Exchange exchange) throws Exception {
        if (!string.startsWith("SUBSCRIBE:")) {
            return null;
        }
        string = string.substring("SUBSCRIBE:".length());
        return (EventSubscription)ValueUtil.JSON.readValue(string, EventSubscription.class);
    }

    @Converter
    public CancelEventSubscription readCancelEventSubscription(String string, Exchange exchange) throws Exception {
        if (!string.startsWith("UNSUBSCRIBE:")) {
            return null;
        }
        string = string.substring("UNSUBSCRIBE:".length());
        return (CancelEventSubscription)ValueUtil.JSON.readValue(string, CancelEventSubscription.class);
    }

    @Converter
    public String writeUnauthorizedEventSubscription(UnauthorizedEventSubscription unauthorizedEventSubscription, Exchange exchange) throws Exception {
        return "UNAUTHORIZED:" + ValueUtil.JSON.writeValueAsString((Object)unauthorizedEventSubscription);
    }
}

