/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.energy;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.util.MapAccess;
import org.openremote.container.web.WebTargetBuilder;
import org.openremote.manager.asset.AssetProcessingService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.datapoint.AssetPredictedDatapointService;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.gateway.GatewayService;
import org.openremote.manager.rules.RulesService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.asset.impl.ElectricityProducerAsset;
import org.openremote.model.asset.impl.ElectricityProducerWindAsset;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.geo.GeoJSONPoint;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.syslog.SyslogCategory;

public class ForecastWindService
extends RouteBuilder
implements ContainerService {
    public static final String OR_OPEN_WEATHER_API_APP_ID = "OR_OPEN_WEATHER_API_APP_ID";
    protected static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.DATA, (String)ForecastWindService.class.getName());
    protected static final AtomicReference<ResteasyClient> resteasyClient = new AtomicReference();
    protected AssetStorageService assetStorageService;
    protected AssetProcessingService assetProcessingService;
    protected GatewayService gatewayService;
    protected AssetPredictedDatapointService assetPredictedDatapointService;
    protected ClientEventService clientEventService;
    protected ScheduledExecutorService scheduledExecutorService;
    protected RulesService rulesService;
    private ResteasyWebTarget weatherForecastWebTarget;
    private String openWeatherAppId;
    private final Map<String, ScheduledFuture<?>> calculationFutures = new HashMap();

    public void configure() throws Exception {
        this.from("seda://PersistenceTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&size=25000").routeId("Persistence-ForecastWind").filter(PersistenceService.isPersistenceEventForEntityType(ElectricityProducerWindAsset.class)).filter(GatewayService.isNotForGateway(this.gatewayService)).process(exchange -> this.processAssetChange((PersistenceEvent<ElectricityProducerWindAsset>)((PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class))));
    }

    public void init(Container container) throws Exception {
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.assetProcessingService = (AssetProcessingService)container.getService(AssetProcessingService.class);
        this.gatewayService = (GatewayService)container.getService(GatewayService.class);
        this.assetPredictedDatapointService = (AssetPredictedDatapointService)container.getService(AssetPredictedDatapointService.class);
        this.clientEventService = (ClientEventService)container.getService(ClientEventService.class);
        this.scheduledExecutorService = container.getScheduledExecutor();
        this.rulesService = (RulesService)container.getService(RulesService.class);
        this.openWeatherAppId = MapAccess.getString((Map)container.getConfig(), (String)OR_OPEN_WEATHER_API_APP_ID, null);
    }

    public void start(Container container) throws Exception {
        if (this.openWeatherAppId == null) {
            LOG.fine("No value found for OR_OPEN_WEATHER_API_APP_ID, ForecastWindService won't start");
            return;
        }
        ForecastWindService.initClient();
        this.weatherForecastWebTarget = resteasyClient.get().target("https://api.openweathermap.org/data/2.5").queryParam("units", new Object[]{"metric"}).queryParam("exclude", new Object[]{"minutely,daily,alerts"}).queryParam("appid", new Object[]{this.openWeatherAppId});
        ((MessageBrokerService)container.getService(MessageBrokerService.class)).getContext().addRoutes((RoutesBuilder)this);
        LOG.fine("Loading producer wind assets...");
        List<ElectricityProducerWindAsset> electricityProducerWindAssets = this.assetStorageService.findAll(new AssetQuery().types(ElectricityProducerWindAsset.class)).stream().map(asset -> (ElectricityProducerWindAsset)asset).filter(electricityProducerWindAsset -> electricityProducerWindAsset.isIncludeForecastWindService().orElse(false) != false && electricityProducerWindAsset.getLocation().isPresent()).toList();
        LOG.fine("Found includes producer wind asset count = " + electricityProducerWindAssets.size());
        electricityProducerWindAssets.forEach(this::startCalculation);
        this.clientEventService.addSubscription(AttributeEvent.class, null, this::processAttributeEvent);
    }

    public void stop(Container container) throws Exception {
        new ArrayList<String>(this.calculationFutures.keySet()).forEach(this::stopCalculation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initClient() {
        AtomicReference<ResteasyClient> atomicReference = resteasyClient;
        synchronized (atomicReference) {
            if (resteasyClient.get() == null) {
                resteasyClient.set(WebTargetBuilder.createClient((ExecutorService)org.openremote.container.Container.SCHEDULED_EXECUTOR));
            }
        }
    }

    protected void processAttributeEvent(AttributeEvent attributeEvent) {
        this.processElectricityProducerWindAssetAttributeEvent(attributeEvent);
    }

    protected synchronized void processElectricityProducerWindAssetAttributeEvent(AttributeEvent attributeEvent) {
        ElectricityProducerWindAsset asset;
        if (ElectricityProducerWindAsset.POWER.getName().equals(attributeEvent.getName()) || ElectricityProducerWindAsset.POWER_FORECAST.getName().equals(attributeEvent.getName())) {
            return;
        }
        if (attributeEvent.getName().equals(ElectricityProducerWindAsset.INCLUDE_FORECAST_WIND_SERVICE.getName())) {
            boolean enabled = attributeEvent.getValue().orElse(false);
            if (enabled && this.calculationFutures.containsKey(attributeEvent.getId())) {
                return;
            }
            if (!enabled && !this.calculationFutures.containsKey(attributeEvent.getId())) {
                return;
            }
            LOG.fine("Processing producer wind asset attribute event: " + String.valueOf(attributeEvent));
            this.stopCalculation(attributeEvent.getId());
            ElectricityProducerWindAsset asset2 = (ElectricityProducerWindAsset)this.assetStorageService.find(attributeEvent.getId());
            if (asset2 != null && asset2.isIncludeForecastWindService().orElse(false).booleanValue() && asset2.getLocation().isPresent()) {
                this.startCalculation(asset2);
            }
        }
        if (attributeEvent.getName().equals(ElectricityProducerWindAsset.SET_ACTUAL_WIND_VALUE_WITH_FORECAST.getName()) && (asset = (ElectricityProducerWindAsset)this.assetStorageService.find(attributeEvent.getId())).getPower().orElse(0.0) == 0.0 && asset.getPowerForecast().orElse(0.0) != 0.0) {
            this.assetProcessingService.sendAttributeEvent(new AttributeEvent(asset.getId(), ElectricityProducerWindAsset.POWER, (Object)asset.getPowerForecast().orElse(0.0)), ((Object)((Object)this)).getClass().getSimpleName());
        }
    }

    protected void processAssetChange(PersistenceEvent<ElectricityProducerWindAsset> persistenceEvent) {
        LOG.fine("Processing producer wind asset change: " + String.valueOf(persistenceEvent));
        this.stopCalculation(((ElectricityProducerWindAsset)persistenceEvent.getEntity()).getId());
        if (persistenceEvent.getCause() != PersistenceEvent.Cause.DELETE && ((ElectricityProducerWindAsset)persistenceEvent.getEntity()).isIncludeForecastWindService().orElse(false).booleanValue() && ((ElectricityProducerWindAsset)persistenceEvent.getEntity()).getLocation().isPresent()) {
            this.startCalculation((ElectricityProducerWindAsset)persistenceEvent.getEntity());
        }
    }

    protected void startCalculation(ElectricityProducerWindAsset electricityProducerWindAsset) {
        LOG.fine("Starting calculation for producer wind asset: " + String.valueOf(electricityProducerWindAsset));
        this.calculationFutures.put(electricityProducerWindAsset.getId(), this.scheduledExecutorService.scheduleAtFixedRate(() -> this.processWeatherData(electricityProducerWindAsset), 0L, 1L, TimeUnit.HOURS));
    }

    protected void stopCalculation(String electricityProducerWindAssetId) {
        ScheduledFuture<?> scheduledFuture = this.calculationFutures.remove(electricityProducerWindAssetId);
        if (scheduledFuture != null) {
            LOG.fine("Stopping calculation for producer wind asset: " + electricityProducerWindAssetId);
            scheduledFuture.cancel(false);
        }
    }

    protected void processWeatherData(ElectricityProducerWindAsset electricityProducerWindAsset) {
        try (Response response = this.weatherForecastWebTarget.path("onecall").queryParam("lat", new Object[]{((GeoJSONPoint)electricityProducerWindAsset.getLocation().get()).getY()}).queryParam("lon", new Object[]{((GeoJSONPoint)electricityProducerWindAsset.getLocation().get()).getX()}).request().build("GET").invoke();){
            if (response != null && response.getStatus() == 200) {
                WeatherForecastResponseModel weatherForecastResponseModel = (WeatherForecastResponseModel)response.readEntity(WeatherForecastResponseModel.class);
                double currentPower = this.calculatePower(electricityProducerWindAsset, weatherForecastResponseModel.current);
                this.assetProcessingService.sendAttributeEvent(new AttributeEvent(electricityProducerWindAsset.getId(), ElectricityProducerAsset.POWER_FORECAST.getName(), (Object)(-currentPower)), ((Object)((Object)this)).getClass().getSimpleName());
                if (electricityProducerWindAsset.isSetActualWindValueWithForecast().orElse(false).booleanValue()) {
                    this.assetProcessingService.sendAttributeEvent(new AttributeEvent(electricityProducerWindAsset.getId(), ElectricityProducerAsset.POWER.getName(), (Object)(-currentPower)), ((Object)((Object)this)).getClass().getSimpleName());
                }
                for (WeatherForecastModel weatherForecastModel : weatherForecastResponseModel.getList()) {
                    double powerForecast = this.calculatePower(electricityProducerWindAsset, weatherForecastModel);
                    LocalDateTime timestamp = Instant.ofEpochMilli(weatherForecastModel.getTimestamp()).atZone(ZoneId.systemDefault()).toLocalDateTime();
                    this.assetPredictedDatapointService.updateValue(electricityProducerWindAsset.getId(), ElectricityProducerAsset.POWER_FORECAST.getName(), -powerForecast, timestamp);
                    this.assetPredictedDatapointService.updateValue(electricityProducerWindAsset.getId(), ElectricityProducerAsset.POWER.getName(), -powerForecast, timestamp);
                    for (int i = 0; i < 3; ++i) {
                        timestamp = timestamp.plusMinutes(15L);
                        this.assetPredictedDatapointService.updateValue(electricityProducerWindAsset.getId(), ElectricityProducerAsset.POWER_FORECAST.getName(), -powerForecast, timestamp);
                        this.assetPredictedDatapointService.updateValue(electricityProducerWindAsset.getId(), ElectricityProducerAsset.POWER.getName(), -powerForecast, timestamp);
                    }
                }
                this.rulesService.fireDeploymentsWithPredictedDataForAsset(electricityProducerWindAsset.getId());
            } else {
                StringBuilder message = new StringBuilder("Unknown");
                if (response != null) {
                    message.setLength(0);
                    message.append("Status ");
                    message.append(response.getStatus());
                    message.append(" - ");
                    message.append((String)response.readEntity(String.class));
                }
                LOG.warning("Request failed: " + String.valueOf(message));
            }
        }
        catch (Throwable e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                LOG.log(Level.SEVERE, "Exception when requesting openweathermap data", e.getCause());
            }
            LOG.log(Level.SEVERE, "Exception when requesting openweathermap data", e);
        }
    }

    protected double calculatePower(ElectricityProducerWindAsset electricityProducerWindAsset, WeatherForecastModel weatherForecastModel) {
        double windSpeed = weatherForecastModel.getWindSpeed();
        double powerForecast = 0.0;
        double windSpeedMin = electricityProducerWindAsset.getWindSpeedMin().orElse(0.0);
        double windSpeedMax = electricityProducerWindAsset.getWindSpeedMax().orElse(0.0);
        double windSpeedReference = electricityProducerWindAsset.getWindSpeedReference().orElse(0.0);
        double energyExportMax = electricityProducerWindAsset.getPowerExportMax().orElse(0.0);
        if (windSpeed <= 0.0 || windSpeed < windSpeedMin) {
            powerForecast = 0.0;
        }
        if (windSpeedMin <= windSpeed && windSpeed <= windSpeedReference) {
            powerForecast = Math.pow(windSpeed / windSpeedReference, 2.0) * energyExportMax;
        }
        if (windSpeedReference < windSpeed && windSpeed <= windSpeedMax) {
            powerForecast = energyExportMax;
        }
        if (windSpeed > windSpeedMax) {
            powerForecast = 0.0;
        }
        if (powerForecast < 0.0) {
            powerForecast = 0.0;
        }
        return powerForecast;
    }

    protected static class WeatherForecastResponseModel {
        protected WeatherForecastModel current;
        @JsonProperty(value="hourly")
        protected WeatherForecastModel[] list;

        protected WeatherForecastResponseModel() {
        }

        public WeatherForecastModel[] getList() {
            return this.list;
        }
    }

    protected static class WeatherForecastModel {
        @JsonProperty(value="dt")
        protected long timestamp;
        @JsonProperty(value="temp")
        protected double tempature;
        @JsonProperty(value="humidity")
        protected int humidity;
        @JsonProperty(value="wind_speed")
        protected double windSpeed;
        @JsonProperty(value="wind_deg")
        protected int windDirection;
        @JsonProperty(value="uvi")
        protected double uv;

        protected WeatherForecastModel() {
        }

        public long getTimestamp() {
            return this.timestamp * 1000L;
        }

        public double getTempature() {
            return this.tempature;
        }

        public int getHumidity() {
            return this.humidity;
        }

        public double getWindSpeed() {
            return this.windSpeed;
        }

        public int getWindDirection() {
            return this.windDirection;
        }

        public double getUv() {
            return this.uv;
        }
    }
}

