/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.energy;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.timer.TimerService;
import org.openremote.container.util.MapAccess;
import org.openremote.container.web.WebTargetBuilder;
import org.openremote.manager.asset.AssetProcessingService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.datapoint.AssetPredictedDatapointService;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.gateway.GatewayService;
import org.openremote.manager.rules.RulesService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetFilter;
import org.openremote.model.asset.impl.ElectricityProducerSolarAsset;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.datapoint.ValueDatapoint;
import org.openremote.model.datapoint.query.AssetDatapointAllQuery;
import org.openremote.model.datapoint.query.AssetDatapointQuery;
import org.openremote.model.geo.GeoJSONPoint;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.syslog.SyslogCategory;

public class ForecastSolarService
extends RouteBuilder
implements ContainerService {
    public static final String OR_FORECAST_SOLAR_API_KEY = "OR_FORECAST_SOLAR_API_KEY";
    protected static final DateTimeFormatter ISO_LOCAL_DATE_TIME_WITHOUT_T = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
    protected ScheduledExecutorService scheduledExecutorService;
    protected AssetStorageService assetStorageService;
    protected AssetProcessingService assetProcessingService;
    protected AssetPredictedDatapointService assetPredictedDatapointService;
    protected GatewayService gatewayService;
    protected ClientEventService clientEventService;
    protected RulesService rulesService;
    protected TimerService timerService;
    protected static final Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.DATA, (String)ForecastSolarService.class.getName());
    protected static final AtomicReference<ResteasyClient> resteasyClient = new AtomicReference();
    protected ResteasyWebTarget forecastSolarTarget;
    private String forecastSolarApiKey;
    private final Map<String, ElectricityProducerSolarAsset> electricityProducerSolarAssetMap = new HashMap<String, ElectricityProducerSolarAsset>();

    public void configure() throws Exception {
        this.from("seda://PersistenceTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&size=25000").routeId("Persistence-ForecastSolar").filter(PersistenceService.isPersistenceEventForEntityType(ElectricityProducerSolarAsset.class)).filter(GatewayService.isNotForGateway(this.gatewayService)).process(exchange -> this.processAssetChange((PersistenceEvent<ElectricityProducerSolarAsset>)((PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class))));
    }

    public void init(Container container) throws Exception {
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.assetProcessingService = (AssetProcessingService)container.getService(AssetProcessingService.class);
        this.gatewayService = (GatewayService)container.getService(GatewayService.class);
        this.assetPredictedDatapointService = (AssetPredictedDatapointService)container.getService(AssetPredictedDatapointService.class);
        this.clientEventService = (ClientEventService)container.getService(ClientEventService.class);
        this.scheduledExecutorService = container.getScheduledExecutor();
        this.rulesService = (RulesService)container.getService(RulesService.class);
        this.timerService = (TimerService)container.getService(TimerService.class);
        this.forecastSolarApiKey = MapAccess.getString((Map)container.getConfig(), (String)OR_FORECAST_SOLAR_API_KEY, null);
    }

    public void start(Container container) throws Exception {
        if (this.forecastSolarApiKey == null) {
            LOG.fine("No value found for OR_FORECAST_SOLAR_API_KEY, ForecastSolarService won't start");
            return;
        }
        ForecastSolarService.initClient();
        this.forecastSolarTarget = resteasyClient.get().target("https://api.forecast.solar/" + this.forecastSolarApiKey + "/estimate");
        ((MessageBrokerService)container.getService(MessageBrokerService.class)).getContext().addRoutes((RoutesBuilder)this);
        LOG.fine("Loading electricity producer solar assets...");
        List<ElectricityProducerSolarAsset> electricityProducerSolarAssets = this.assetStorageService.findAll(new AssetQuery().types(ElectricityProducerSolarAsset.class)).stream().map(asset -> (ElectricityProducerSolarAsset)asset).filter(electricityProducerSolarAsset -> electricityProducerSolarAsset.isIncludeForecastSolarService().orElse(false)).toList();
        LOG.fine("Number of electricity producer solar assets with forecast enabled = " + electricityProducerSolarAssets.size());
        for (ElectricityProducerSolarAsset electricityProducerSolarAsset2 : electricityProducerSolarAssets) {
            this.electricityProducerSolarAssetMap.put(electricityProducerSolarAsset2.getId(), electricityProducerSolarAsset2);
            this.getSolarForecast(electricityProducerSolarAsset2);
            this.updateSolarForecastAttribute(electricityProducerSolarAsset2);
        }
        this.scheduledExecutorService.scheduleAtFixedRate(this::processSolarData, 1L, 1L, TimeUnit.MINUTES);
        this.clientEventService.addSubscription(AttributeEvent.class, new AssetFilter().setAssetClasses(Collections.singletonList(ElectricityProducerSolarAsset.class)), this::processElectricityProducerSolarAssetAttributeEvent);
    }

    public void stop(Container container) throws Exception {
        this.scheduledExecutorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initClient() {
        AtomicReference<ResteasyClient> atomicReference = resteasyClient;
        synchronized (atomicReference) {
            if (resteasyClient.get() == null) {
                resteasyClient.set(WebTargetBuilder.createClient((ExecutorService)org.openremote.container.Container.EXECUTOR));
            }
        }
    }

    protected synchronized void processElectricityProducerSolarAssetAttributeEvent(AttributeEvent attributeEvent) {
        ElectricityProducerSolarAsset asset;
        String attributeName = attributeEvent.getName();
        if (ElectricityProducerSolarAsset.POWER.getName().equals(attributeName) || ElectricityProducerSolarAsset.POWER_FORECAST.getName().equals(attributeName)) {
            return;
        }
        if (attributeName.equals(ElectricityProducerSolarAsset.SET_ACTUAL_SOLAR_VALUE_WITH_FORECAST.getName())) {
            boolean enabled = attributeEvent.getValue().orElse(false);
            ElectricityProducerSolarAsset asset2 = (ElectricityProducerSolarAsset)this.assetStorageService.find(attributeEvent.getId());
            if (asset2 != null && enabled) {
                this.assetProcessingService.sendAttributeEvent(new AttributeEvent(asset2.getId(), ElectricityProducerSolarAsset.POWER, (Object)asset2.getPowerForecast().orElse(null)), ((Object)((Object)this)).getClass().getSimpleName());
            } else if (asset2 != null) {
                this.assetProcessingService.sendAttributeEvent(new AttributeEvent(asset2.getId(), ElectricityProducerSolarAsset.POWER, null), ((Object)((Object)this)).getClass().getSimpleName());
            }
            return;
        }
        if (attributeName.equals(ElectricityProducerSolarAsset.INCLUDE_FORECAST_SOLAR_SERVICE.getName())) {
            boolean enabled = attributeEvent.getValue().orElse(false);
            if (enabled && !this.electricityProducerSolarAssetMap.containsKey(attributeEvent.getId())) {
                LOG.info(String.format("Enabled solar forecast for ElectricityProducerSolarAsset: name='%s', ID='%s';", attributeEvent.getAssetName(), attributeEvent.getId()));
                ElectricityProducerSolarAsset asset3 = (ElectricityProducerSolarAsset)this.assetStorageService.find(attributeEvent.getId());
                if (asset3 != null) {
                    this.electricityProducerSolarAssetMap.put(asset3.getId(), asset3);
                    this.getSolarForecast(asset3);
                    this.updateSolarForecastAttribute(asset3);
                }
            } else if (!enabled && this.electricityProducerSolarAssetMap.containsKey(attributeEvent.getId())) {
                LOG.info(String.format("Disabled solar forecast for ElectricityProducerSolarAsset: name='%s', ID='%s';", attributeEvent.getAssetName(), attributeEvent.getId()));
                this.electricityProducerSolarAssetMap.remove(attributeEvent.getId());
            }
        }
        if ((attributeName.equals(ElectricityProducerSolarAsset.PANEL_AZIMUTH.getName()) || attributeName.equals(ElectricityProducerSolarAsset.PANEL_PITCH.getName()) || attributeName.equals(ElectricityProducerSolarAsset.POWER_EXPORT_MAX.getName()) || attributeName.equals(ElectricityProducerSolarAsset.LOCATION.getName())) && (asset = (ElectricityProducerSolarAsset)this.assetStorageService.find(attributeEvent.getId())) != null && asset.isIncludeForecastSolarService().orElse(false).booleanValue()) {
            String valuePreviousStr;
            ElectricityProducerSolarAsset assetPrevious = this.electricityProducerSolarAssetMap.get(asset.getId());
            String valueStr = attributeEvent.getValue().toString();
            if (!valueStr.equals(valuePreviousStr = assetPrevious.getAttributes().get(attributeEvent.getName()).flatMap(Attribute::getValue).toString())) {
                Object value = attributeEvent.getValue().orElse(null);
                if (attributeName.equals(ElectricityProducerSolarAsset.PANEL_AZIMUTH.getName())) {
                    asset.setPanelAzimuth((Integer)value);
                } else if (attributeName.equals(ElectricityProducerSolarAsset.PANEL_PITCH.getName())) {
                    asset.setPanelPitch((Integer)value);
                } else if (attributeName.equals(ElectricityProducerSolarAsset.POWER_EXPORT_MAX.getName())) {
                    asset.setPowerExportMax((Double)value);
                } else if (attributeName.equals(ElectricityProducerSolarAsset.LOCATION.getName())) {
                    asset.setLocation((GeoJSONPoint)value);
                }
                this.getSolarForecast(asset);
                this.updateSolarForecastAttribute(asset);
            }
            this.electricityProducerSolarAssetMap.put(asset.getId(), asset);
        }
    }

    protected void processAssetChange(PersistenceEvent<ElectricityProducerSolarAsset> persistenceEvent) {
        LOG.fine("Processing producer solar asset change: " + String.valueOf(persistenceEvent));
        if (persistenceEvent.getCause() == PersistenceEvent.Cause.CREATE && ((ElectricityProducerSolarAsset)persistenceEvent.getEntity()).isIncludeForecastSolarService().orElse(false).booleanValue()) {
            this.electricityProducerSolarAssetMap.put(((ElectricityProducerSolarAsset)persistenceEvent.getEntity()).getId(), (ElectricityProducerSolarAsset)persistenceEvent.getEntity());
            this.getSolarForecast((ElectricityProducerSolarAsset)persistenceEvent.getEntity());
            this.updateSolarForecastAttribute((ElectricityProducerSolarAsset)persistenceEvent.getEntity());
        } else if (persistenceEvent.getCause() == PersistenceEvent.Cause.DELETE) {
            this.electricityProducerSolarAssetMap.remove(((ElectricityProducerSolarAsset)persistenceEvent.getEntity()).getId());
        }
    }

    protected void processSolarData() {
        if (this.electricityProducerSolarAssetMap.isEmpty()) {
            return;
        }
        int currentMinute = LocalDateTime.now().getMinute();
        if (currentMinute == 0) {
            this.electricityProducerSolarAssetMap.forEach((assetId, electricityProducerSolarAsset) -> this.getSolarForecast((ElectricityProducerSolarAsset)electricityProducerSolarAsset));
        }
        if (currentMinute % 15 == 0) {
            this.electricityProducerSolarAssetMap.forEach((assetId, electricityProducerSolarAsset) -> this.updateSolarForecastAttribute((ElectricityProducerSolarAsset)electricityProducerSolarAsset));
        }
    }

    protected void getSolarForecast(ElectricityProducerSolarAsset electricityProducerSolarAsset) {
        Optional lat = electricityProducerSolarAsset.getAttribute(Asset.LOCATION).flatMap(attr -> attr.getValue().map(GeoJSONPoint::getY));
        Optional lon = electricityProducerSolarAsset.getAttribute(Asset.LOCATION).flatMap(attr -> attr.getValue().map(GeoJSONPoint::getX));
        Optional pitch = electricityProducerSolarAsset.getPanelPitch();
        Optional azimuth = electricityProducerSolarAsset.getPanelAzimuth();
        Optional kwp = electricityProducerSolarAsset.getPowerExportMax();
        if (lat.isEmpty() || lon.isEmpty() || pitch.isEmpty() || azimuth.isEmpty() || kwp.isEmpty()) {
            LOG.warning(String.format("ElectricityProducerSolarAsset: name='%s', ID='%s' doesn't have all needed attributes filled in; latitude='%s', longitude='%s', panelAzimuth='%s', panelPitch='%s', powerExportMax='%s'", electricityProducerSolarAsset.getName(), electricityProducerSolarAsset.getId(), lat, lon, azimuth, pitch, kwp));
            return;
        }
        try (Response response = this.forecastSolarTarget.path(String.format("%f/%f/%d/%d/%f", lat.get(), lon.get(), pitch.get(), azimuth.get(), kwp.get())).request().build("GET").invoke();){
            if (response != null && response.getStatus() == 200) {
                EstimateResponse responseModel = (EstimateResponse)response.readEntity(EstimateResponse.class);
                if (responseModel != null) {
                    HashMap<LocalDateTime, Double> solarForecast = new HashMap<LocalDateTime, Double>();
                    HashMap<LocalDateTime, Double> solarForecastPrevious = new HashMap<LocalDateTime, Double>();
                    List<ValueDatapoint> solarForecastListPrevious = this.assetPredictedDatapointService.getDatapoints(new AttributeRef(electricityProducerSolarAsset.getId(), ElectricityProducerSolarAsset.POWER_FORECAST.getName()));
                    for (ValueDatapoint datapoint : solarForecastListPrevious) {
                        LocalDateTime dateTime2 = LocalDateTime.ofInstant(Instant.ofEpochMilli(datapoint.getTimestamp()), ZoneId.systemDefault());
                        Double powerKiloWatt2 = (Double)datapoint.getValue();
                        solarForecastPrevious.put(dateTime2, powerKiloWatt2);
                    }
                    String minKey = responseModel.result.watts.keySet().stream().min(String::compareTo).orElse("");
                    String maxKey = responseModel.result.watts.keySet().stream().max(String::compareTo).orElse("");
                    LocalDateTime startDateTime = LocalDateTime.parse(minKey, ISO_LOCAL_DATE_TIME_WITHOUT_T).toLocalDate().atStartOfDay();
                    LocalDateTime endDateTime = LocalDateTime.parse(maxKey, ISO_LOCAL_DATE_TIME_WITHOUT_T).toLocalDate().plusDays(1L).atStartOfDay();
                    Object dateTime3 = startDateTime;
                    while (!((LocalDateTime)dateTime3).isAfter(endDateTime)) {
                        solarForecast.put((LocalDateTime)dateTime3, 0.0);
                        dateTime3 = ((LocalDateTime)dateTime3).plusMinutes(15L);
                    }
                    for (Map.Entry entry : responseModel.result.watts.entrySet()) {
                        LocalDateTime dateTime4 = LocalDateTime.parse((CharSequence)entry.getKey(), ISO_LOCAL_DATE_TIME_WITHOUT_T);
                        Double powerKiloWatt3 = -((Double)entry.getValue()).doubleValue() / 1000.0;
                        solarForecast.put(dateTime4, powerKiloWatt3);
                    }
                    LocalDateTime currentDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(this.timerService.getCurrentTimeMillis()), ZoneId.systemDefault());
                    solarForecast.forEach((dateTime, powerKiloWatt) -> {
                        if (dateTime.isAfter(currentDateTime) || solarForecastPrevious.get(dateTime) == null) {
                            this.assetPredictedDatapointService.updateValue(electricityProducerSolarAsset.getId(), ElectricityProducerSolarAsset.POWER_FORECAST.getName(), powerKiloWatt, (LocalDateTime)dateTime);
                            this.assetPredictedDatapointService.updateValue(electricityProducerSolarAsset.getId(), ElectricityProducerSolarAsset.POWER.getName(), powerKiloWatt, (LocalDateTime)dateTime);
                        }
                    });
                }
                this.rulesService.fireDeploymentsWithPredictedDataForAsset(electricityProducerSolarAsset.getId());
            } else {
                StringBuilder message = new StringBuilder("Unknown");
                if (response != null) {
                    message.setLength(0);
                    message.append("Status ");
                    message.append(response.getStatus());
                    message.append(" - ");
                    message.append((String)response.readEntity(String.class));
                }
                LOG.warning("Request failed: " + String.valueOf(message));
            }
        }
        catch (Throwable e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                LOG.log(Level.SEVERE, "Exception when requesting forecast solar data", e.getCause());
            }
            LOG.log(Level.SEVERE, "Exception when requesting forecast solar data", e);
        }
    }

    protected void updateSolarForecastAttribute(ElectricityProducerSolarAsset electricityProducerSolarAsset) {
        long timeMillis;
        Double powerKiloWatt;
        Optional lat = electricityProducerSolarAsset.getAttribute(Asset.LOCATION).flatMap(attr -> attr.getValue().map(GeoJSONPoint::getY));
        Optional lon = electricityProducerSolarAsset.getAttribute(Asset.LOCATION).flatMap(attr -> attr.getValue().map(GeoJSONPoint::getX));
        Optional pitch = electricityProducerSolarAsset.getPanelPitch();
        Optional azimuth = electricityProducerSolarAsset.getPanelAzimuth();
        Optional kwp = electricityProducerSolarAsset.getPowerExportMax();
        if (lat.isEmpty() || lon.isEmpty() || pitch.isEmpty() || azimuth.isEmpty() || kwp.isEmpty()) {
            return;
        }
        long currentTimeMillis = this.timerService.getCurrentTimeMillis();
        long startTimeMillis = currentTimeMillis - currentTimeMillis % 900000L;
        long endTimeMillis = startTimeMillis + 900000L;
        AssetDatapointAllQuery assetDatapointQuery = new AssetDatapointAllQuery(startTimeMillis, endTimeMillis);
        List<ValueDatapoint<?>> solarForecastDatapoints = this.assetPredictedDatapointService.queryDatapoints(electricityProducerSolarAsset.getId(), ElectricityProducerSolarAsset.POWER_FORECAST.getName(), (AssetDatapointQuery)assetDatapointQuery);
        if (solarForecastDatapoints == null || solarForecastDatapoints.size() < 2) {
            LOG.warning(String.format("ElectricityProducerSolarAsset: name='%s', ID='%s' doesn't have a solar forecast", electricityProducerSolarAsset.getName(), electricityProducerSolarAsset.getId()));
            return;
        }
        ValueDatapoint<?> solarForecastDatapointMax = solarForecastDatapoints.get(0);
        ValueDatapoint<?> solarForecastDatapointMin = solarForecastDatapoints.get(solarForecastDatapoints.size() - 1);
        ElectricityProducerSolarAsset asset = (ElectricityProducerSolarAsset)this.assetStorageService.find(electricityProducerSolarAsset.getId());
        long powerForecastAttributeTimeMillis = asset.getAttributes().get(ElectricityProducerSolarAsset.POWER_FORECAST).flatMap(Attribute::getTimestamp).orElse(0L);
        if (solarForecastDatapointMin.getTimestamp() > powerForecastAttributeTimeMillis) {
            powerKiloWatt = (Double)solarForecastDatapointMin.getValue();
            timeMillis = solarForecastDatapointMin.getTimestamp();
        } else {
            long upperTimestamp = solarForecastDatapointMax.getTimestamp();
            long lowerTimestamp = solarForecastDatapointMin.getTimestamp();
            Double upperValue = (Double)solarForecastDatapointMax.getValue();
            Double lowerValue = (Double)solarForecastDatapointMin.getValue();
            if (upperValue == null || lowerValue == null) {
                return;
            }
            double factor = (double)(currentTimeMillis - lowerTimestamp) / (double)(upperTimestamp - lowerTimestamp);
            double interpolatedValue = lowerValue + factor * (upperValue - lowerValue);
            powerKiloWatt = (double)Math.round(interpolatedValue * 1000.0) / 1000.0;
            timeMillis = currentTimeMillis;
        }
        this.assetProcessingService.sendAttributeEvent(new AttributeEvent(electricityProducerSolarAsset.getId(), ElectricityProducerSolarAsset.POWER_FORECAST.getName(), (Object)powerKiloWatt, Long.valueOf(timeMillis)));
        if (electricityProducerSolarAsset.isSetActualSolarValueWithForecast().orElse(false).booleanValue()) {
            this.assetProcessingService.sendAttributeEvent(new AttributeEvent(electricityProducerSolarAsset.getId(), ElectricityProducerSolarAsset.POWER.getName(), (Object)powerKiloWatt, Long.valueOf(timeMillis)));
        }
    }

    protected static class EstimateResponse {
        @JsonProperty
        protected Result result;

        protected EstimateResponse() {
        }
    }

    protected static class Result {
        @JsonProperty
        protected Map<String, Double> wattHours;
        @JsonProperty
        protected Map<String, Double> wattHoursDay;
        @JsonProperty
        protected Map<String, Double> watts;

        protected Result() {
        }
    }
}

