/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.datapoint;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openremote.agent.protocol.ProtocolPredictedDatapointService;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.datapoint.AbstractDatapointService;
import org.openremote.manager.datapoint.AssetPredictedDatapointResourceImpl;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.Container;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.datapoint.AssetPredictedDatapoint;
import org.openremote.model.datapoint.ValueDatapoint;

public class AssetPredictedDatapointService
extends AbstractDatapointService<AssetPredictedDatapoint>
implements ProtocolPredictedDatapointService {
    private static final Logger LOG = Logger.getLogger(AssetPredictedDatapointService.class.getName());

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public void init(Container container) throws Exception {
        super.init(container);
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new AssetPredictedDatapointResourceImpl((TimerService)container.getService(TimerService.class), (ManagerIdentityService)container.getService(ManagerIdentityService.class), (AssetStorageService)container.getService(AssetStorageService.class), this));
    }

    public void start(Container container) throws Exception {
        this.dataPointsPurgeScheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(this::purgeDataPoints, this.getFirstPurgeMillis(this.timerService.getNow()), Duration.ofDays(1L).toMillis(), TimeUnit.MILLISECONDS);
    }

    public void updateValue(AttributeRef attributeRef, Object value, LocalDateTime timestamp) {
        this.updateValue(attributeRef.getId(), attributeRef.getName(), value, timestamp);
    }

    public void updateValue(String assetId, String attributeName, Object value, LocalDateTime timestamp) {
        this.upsertValue(assetId, attributeName, value, timestamp);
    }

    public void updateValues(String assetId, String attributeName, List<ValueDatapoint<?>> valuesAndTimestamps) {
        this.persistenceService.doTransaction(em -> this.upsertValues(assetId, attributeName, valuesAndTimestamps));
    }

    public void purgeValues(String assetId, String attributeName) {
        this.persistenceService.doTransaction(em -> em.createQuery("delete from " + this.getDatapointClass().getSimpleName() + " dp where dp.assetId=?1 and dp.attributeName=?2").setParameter(1, (Object)assetId).setParameter(2, (Object)attributeName).executeUpdate());
    }

    @Override
    protected Class<AssetPredictedDatapoint> getDatapointClass() {
        return AssetPredictedDatapoint.class;
    }

    @Override
    protected String getDatapointTableName() {
        return "asset_predicted_datapoint";
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    protected long getFirstPurgeMillis(Instant currentTime) {
        return super.getFirstPurgeMillis(currentTime) - 1800000L;
    }

    protected void purgeDataPoints() {
        try {
            LOG.finest("Purging predicted data points older than now");
            this.doPurge("where dp.timestamp < :dt", Date.from(this.timerService.getNow().truncatedTo(ChronoUnit.HOURS)));
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to run data points purge", e);
        }
    }
}

