/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.datapoint;

import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.logging.Logger;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.datapoint.AssetPredictedDatapointService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.asset.Asset;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.datapoint.AssetPredictedDatapointResource;
import org.openremote.model.datapoint.ValueDatapoint;
import org.openremote.model.datapoint.query.AssetDatapointQuery;
import org.openremote.model.http.RequestParams;
import org.openremote.model.security.ClientRole;
import org.openremote.model.value.AbstractNameValueDescriptorHolder;
import org.openremote.model.value.MetaItemType;

public class AssetPredictedDatapointResourceImpl
extends ManagerWebResource
implements AssetPredictedDatapointResource {
    private static final Logger LOG = Logger.getLogger(AssetPredictedDatapointResourceImpl.class.getName());
    protected final AssetStorageService assetStorageService;
    protected final AssetPredictedDatapointService assetPredictedDatapointService;

    public AssetPredictedDatapointResourceImpl(TimerService timerService, ManagerIdentityService identityService, AssetStorageService assetStorageService, AssetPredictedDatapointService assetPredictedDatapointService) {
        super(timerService, identityService);
        this.assetStorageService = assetStorageService;
        this.assetPredictedDatapointService = assetPredictedDatapointService;
    }

    public ValueDatapoint<?>[] getPredictedDatapoints(@BeanParam RequestParams requestParams, String assetId, String attributeName, AssetDatapointQuery query) {
        try {
            if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), assetId)) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            Asset<?> asset = this.assetStorageService.find(assetId, true);
            if (asset == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!this.isRealmActiveAndAccessible(asset.getRealm())) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (!this.isAuthenticated() && !asset.isAccessPublicRead()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (this.isAuthenticated() && !this.hasResourceRole(ClientRole.READ_ASSETS.getValue(), "openremote")) {
                LOG.info("Forbidden access for user '" + this.getUsername() + "': " + asset.getRealm());
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            Attribute attribute = (Attribute)asset.getAttribute(attributeName).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
            if (this.isRestrictedUser()) {
                attribute.getMeta().getValue((AbstractNameValueDescriptorHolder)MetaItemType.ACCESS_RESTRICTED_READ).ifPresentOrElse(v -> {
                    if (!v.booleanValue()) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                }, () -> {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                });
            }
            if (!this.isAuthenticated()) {
                attribute.getMeta().getValue((AbstractNameValueDescriptorHolder)MetaItemType.ACCESS_PUBLIC_READ).ifPresentOrElse(v -> {
                    if (!v.booleanValue()) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                }, () -> {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                });
            }
            return (ValueDatapoint[])this.assetPredictedDatapointService.queryDatapoints(assetId, attribute, query).toArray(ValueDatapoint[]::new);
        }
        catch (IllegalStateException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
    }

    public void writePredictedDatapoints(RequestParams requestParams, String assetId, String attributeName, ValueDatapoint<?>[] predictedDatapoints) {
        try {
            if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), assetId)) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            Asset<?> asset = this.assetStorageService.find(assetId, true);
            if (asset == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!this.isRealmActiveAndAccessible(asset.getRealm())) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (!this.isAuthenticated() && !asset.isAccessPublicRead()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (this.isAuthenticated() && !this.hasResourceRole(ClientRole.READ_ASSETS.getValue(), "openremote")) {
                LOG.info("Forbidden access for user '" + this.getUsername() + "': " + asset.getRealm());
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            Attribute attribute = (Attribute)asset.getAttribute(attributeName).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
            if (this.isRestrictedUser()) {
                attribute.getMeta().getValue((AbstractNameValueDescriptorHolder)MetaItemType.ACCESS_RESTRICTED_READ).ifPresentOrElse(v -> {
                    if (!v.booleanValue()) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                }, () -> {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                });
            }
            if (!this.isAuthenticated()) {
                attribute.getMeta().getValue((AbstractNameValueDescriptorHolder)MetaItemType.ACCESS_PUBLIC_READ).ifPresentOrElse(v -> {
                    if (!v.booleanValue()) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                }, () -> {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                });
            }
            this.assetPredictedDatapointService.updateValues(assetId, attributeName, Arrays.asList(predictedDatapoints));
        }
        catch (IllegalStateException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
    }
}

