/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.datapoint;

import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.datapoint.AssetDatapointService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.asset.Asset;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.datapoint.AssetDatapointResource;
import org.openremote.model.datapoint.DatapointPeriod;
import org.openremote.model.datapoint.DatapointQueryTooLargeException;
import org.openremote.model.datapoint.ValueDatapoint;
import org.openremote.model.datapoint.query.AssetDatapointQuery;
import org.openremote.model.http.RequestParams;
import org.openremote.model.security.ClientRole;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.AbstractNameValueDescriptorHolder;
import org.openremote.model.value.MetaItemType;

public class AssetDatapointResourceImpl
extends ManagerWebResource
implements AssetDatapointResource {
    private static final Logger LOG = Logger.getLogger(AssetDatapointResourceImpl.class.getName());
    private static final Logger DATA_EXPORT_LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.DATA, AssetDatapointResourceImpl.class);
    protected final AssetStorageService assetStorageService;
    protected final AssetDatapointService assetDatapointService;

    public AssetDatapointResourceImpl(TimerService timerService, ManagerIdentityService identityService, AssetStorageService assetStorageService, AssetDatapointService assetDatapointService) {
        super(timerService, identityService);
        this.assetStorageService = assetStorageService;
        this.assetDatapointService = assetDatapointService;
    }

    public ValueDatapoint<?>[] getDatapoints(@BeanParam RequestParams requestParams, String assetId, String attributeName, AssetDatapointQuery query) {
        try {
            if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), assetId)) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            Asset<?> asset = this.assetStorageService.find(assetId, true);
            if (asset == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!this.isRealmActiveAndAccessible(asset.getRealm())) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (!this.isAuthenticated() && !asset.isAccessPublicRead()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (this.isAuthenticated() && !this.hasResourceRole(ClientRole.READ_ASSETS.getValue(), "openremote")) {
                LOG.info("Forbidden access for user '" + this.getUsername() + "': " + asset.getRealm());
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            Attribute attribute = (Attribute)asset.getAttribute(attributeName).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
            if (this.isRestrictedUser()) {
                attribute.getMeta().getValue((AbstractNameValueDescriptorHolder)MetaItemType.ACCESS_RESTRICTED_READ).ifPresentOrElse(v -> {
                    if (!v.booleanValue()) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                }, () -> {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                });
            }
            if (!this.isAuthenticated()) {
                attribute.getMeta().getValue((AbstractNameValueDescriptorHolder)MetaItemType.ACCESS_PUBLIC_READ).ifPresentOrElse(v -> {
                    if (!v.booleanValue()) {
                        throw new WebApplicationException(Response.Status.FORBIDDEN);
                    }
                }, () -> {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                });
            }
            if (query != null) {
                return (ValueDatapoint[])this.assetDatapointService.queryDatapoints(assetId, attribute, query).toArray(ValueDatapoint[]::new);
            }
            return (ValueDatapoint[])this.assetDatapointService.getDatapoints(new AttributeRef(assetId, attributeName)).toArray(ValueDatapoint[]::new);
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            throw new BadRequestException((Throwable)ex);
        }
        catch (DatapointQueryTooLargeException dqex) {
            throw new WebApplicationException((Throwable)dqex, Response.Status.REQUEST_ENTITY_TOO_LARGE);
        }
        catch (UnsupportedOperationException ex) {
            throw new NotSupportedException((Throwable)ex);
        }
    }

    public DatapointPeriod getDatapointPeriod(RequestParams requestParams, String assetId, String attributeName) {
        try {
            if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), assetId)) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            Asset<?> asset = this.assetStorageService.find(assetId, true);
            if (asset == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!this.isRealmActiveAndAccessible(asset.getRealm())) {
                LOG.info("Forbidden access for user '" + this.getUsername() + "': " + String.valueOf(asset));
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            Attribute attribute = (Attribute)asset.getAttribute(attributeName).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
            return this.assetDatapointService.getDatapointPeriod(assetId, attributeName);
        }
        catch (IllegalStateException ex) {
            throw new BadRequestException((Throwable)ex);
        }
        catch (UnsupportedOperationException ex) {
            throw new NotSupportedException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDatapointExport(AsyncResponse asyncResponse, String attributeRefsString, long fromTimestamp, long toTimestamp) {
        try {
            AttributeRef[] attributeRefs;
            for (AttributeRef attributeRef : attributeRefs = (AttributeRef[])ValueUtil.JSON.readValue(attributeRefsString, AttributeRef[].class)) {
                if (this.isRestrictedUser() && !this.assetStorageService.isUserAsset(this.getUserId(), attributeRef.getId())) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                Asset<?> asset = this.assetStorageService.find(attributeRef.getId(), true);
                if (asset == null) {
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
                if (!this.isRealmActiveAndAccessible(asset.getRealm())) {
                    DATA_EXPORT_LOG.info("Forbidden access for user '" + this.getUsername() + "': " + String.valueOf(asset));
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                asset.getAttribute(attributeRef.getName()).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
            }
            DATA_EXPORT_LOG.info("User '" + this.getUsername() + "' started data export for " + attributeRefsString + " from " + fromTimestamp + " to " + toTimestamp);
            ScheduledFuture<File> exportFuture = this.assetDatapointService.exportDatapoints(attributeRefs, fromTimestamp, toTimestamp);
            asyncResponse.register(disconnected -> exportFuture.cancel(true));
            File exportFile = null;
            try {
                exportFile = (File)exportFuture.get();
                ZipOutputStream zipOut = new ZipOutputStream((OutputStream)this.response.getOutputStream());
                FileInputStream fin = new FileInputStream(exportFile);
                ZipEntry zipEntry = new ZipEntry(exportFile.getName());
                zipOut.putNextEntry(zipEntry);
                IOUtils.copy((InputStream)fin, (OutputStream)zipOut);
                zipOut.closeEntry();
                zipOut.close();
                fin.close();
                this.response.setContentType("application/zip");
                this.response.setHeader("Content-Disposition", "attachment; filename=\"dataexport.zip\"");
                asyncResponse.resume((Object)this.response);
            }
            catch (Exception ex) {
                exportFuture.cancel(true);
                asyncResponse.resume((Throwable)new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR));
                DATA_EXPORT_LOG.log(Level.SEVERE, "Exception in ScheduledFuture: ", ex);
            }
            finally {
                if (exportFile != null && exportFile.exists()) {
                    try {
                        exportFile.delete();
                    }
                    catch (Exception e) {
                        DATA_EXPORT_LOG.log(Level.SEVERE, "Failed to delete temporary export file: " + exportFile.getPath(), e);
                    }
                }
            }
        }
        catch (JsonProcessingException ex) {
            asyncResponse.resume((Throwable)new BadRequestException((Throwable)ex));
        }
        catch (DatapointQueryTooLargeException dqex) {
            asyncResponse.resume((Throwable)new WebApplicationException((Throwable)dqex, Response.Status.REQUEST_ENTITY_TOO_LARGE));
        }
    }
}

