/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.datapoint;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.validation.constraints.NotNull;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hibernate.Session;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.ReturningWork;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.timer.TimerService;
import org.openremote.container.util.MapAccess;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.asset.Asset;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.datapoint.Datapoint;
import org.openremote.model.datapoint.DatapointPeriod;
import org.openremote.model.datapoint.DatapointQueryTooLargeException;
import org.openremote.model.datapoint.ValueDatapoint;
import org.openremote.model.datapoint.query.AssetDatapointQuery;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;
import org.postgresql.util.PGobject;

public abstract class AbstractDatapointService<T extends Datapoint>
implements ContainerService {
    public static final String OR_DATA_POINTS_QUERY_LIMIT = "OR_DATA_POINTS_QUERY_LIMIT";
    public static final int PRIORITY = 100;
    protected PersistenceService persistenceService;
    protected AssetStorageService assetStorageService;
    protected TimerService timerService;
    protected ScheduledExecutorService scheduledExecutorService;
    protected ScheduledFuture<?> dataPointsPurgeScheduledFuture;
    protected int maxAmountOfQueryPoints;

    public int getPriority() {
        return 100;
    }

    public void init(Container container) throws Exception {
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.timerService = (TimerService)container.getService(TimerService.class);
        this.scheduledExecutorService = container.getScheduledExecutor();
        this.maxAmountOfQueryPoints = MapAccess.getInteger((Map)container.getConfig(), (String)OR_DATA_POINTS_QUERY_LIMIT, (int)100000);
    }

    public void stop(Container container) throws Exception {
        if (this.dataPointsPurgeScheduledFuture != null) {
            this.dataPointsPurgeScheduledFuture.cancel(true);
        }
    }

    public void upsertValue(String assetId, String attributeName, Object value, LocalDateTime timestamp) throws IllegalStateException {
        this.upsertValue(assetId, attributeName, value, timestamp.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
    }

    public void upsertValue(String assetId, String attributeName, Object value, long timestamp) throws IllegalStateException {
        this.persistenceService.doTransaction(em -> ((Session)em.unwrap(Session.class)).doWork(connection -> {
            this.getLogger().log(Level.FINEST, () -> "Storing datapoint for: id=" + assetId + ", name=" + attributeName + ", timestamp=" + timestamp + ", value=" + String.valueOf(value));
            try {
                PreparedStatement st = this.getUpsertPreparedStatement(connection);
                this.setUpsertValues(st, assetId, attributeName, value, timestamp);
                st.executeUpdate();
            }
            catch (Exception e) {
                String msg = "Failed to insert/update data point: ";
                this.getLogger().log(Level.WARNING, msg, e);
                throw new IllegalStateException(msg, e);
            }
        }));
    }

    public void upsertValues(String assetId, String attributeName, List<ValueDatapoint<?>> valuesAndTimestamps) throws IllegalStateException {
        this.persistenceService.doTransaction(em -> ((Session)em.unwrap(Session.class)).doWork(connection -> {
            this.getLogger().finest("Storing datapoints for: id=" + assetId + ", name=" + attributeName + ", count=" + valuesAndTimestamps.size());
            try {
                PreparedStatement st = this.getUpsertPreparedStatement(connection);
                for (ValueDatapoint valueAndTimestamp : valuesAndTimestamps) {
                    this.setUpsertValues(st, assetId, attributeName, valueAndTimestamp.getValue(), valueAndTimestamp.getTimestamp());
                    st.addBatch();
                }
                st.executeBatch();
            }
            catch (Exception e) {
                String msg = "Failed to insert/update data points: " + assetId + ", name=" + attributeName + ", count=" + valuesAndTimestamps.size();
                this.getLogger().log(Level.WARNING, msg, e);
                throw new IllegalStateException(msg, e);
            }
        }));
    }

    public List<ValueDatapoint> getDatapoints(AttributeRef attributeRef) {
        return (List)this.persistenceService.doReturningTransaction(entityManager -> entityManager.createQuery("select new org.openremote.model.datapoint.ValueDatapoint(dp.timestamp, dp.value) from " + this.getDatapointClass().getSimpleName() + " dp where dp.assetId = :assetId and dp.attributeName = :attributeName order by dp.timestamp desc", ValueDatapoint.class).setParameter("assetId", (Object)attributeRef.getId()).setParameter("attributeName", (Object)attributeRef.getName()).getResultList());
    }

    public long getDatapointsCount() {
        return this.getDatapointsCount(null);
    }

    public long getDatapointsCount(AttributeRef attributeRef) {
        return (Long)this.persistenceService.doReturningTransaction(entityManager -> {
            String queryStr = attributeRef == null ? "select count(dp) from " + this.getDatapointClass().getSimpleName() + " dp" : "select count(dp) from " + this.getDatapointClass().getSimpleName() + " dp where dp.assetId = :assetId and dp.attributeName = :attributeName";
            TypedQuery query = entityManager.createQuery(queryStr, Long.class);
            if (attributeRef != null) {
                query.setParameter("assetId", (Object)attributeRef.getId()).setParameter("attributeName", (Object)attributeRef.getName());
            }
            return (Long)query.getSingleResult();
        });
    }

    public List<ValueDatapoint<?>> queryDatapoints(String assetId, String attributeName, AssetDatapointQuery datapointQuery) {
        Asset<?> asset = this.assetStorageService.find(assetId, true);
        if (asset == null) {
            throw new IllegalStateException("Asset not found: " + assetId);
        }
        Attribute assetAttribute = (Attribute)asset.getAttribute(attributeName).orElseThrow(() -> new IllegalStateException("Attribute not found: " + attributeName));
        return this.queryDatapoints(asset.getId(), assetAttribute, datapointQuery);
    }

    public List<ValueDatapoint<?>> queryDatapoints(String assetId, Attribute<?> attribute, @NotNull AssetDatapointQuery datapointQuery) {
        String query;
        AttributeRef attributeRef = new AttributeRef(assetId, attribute.getName());
        HashMap parameters = datapointQuery.getSQLParameters(attributeRef);
        try {
            query = datapointQuery.getSQLQuery(this.getDatapointTableName(), attribute.getTypeClass());
        }
        catch (IllegalStateException ise) {
            this.getLogger().log(Level.WARNING, ise.getMessage());
            throw ise;
        }
        try {
            if (this.canQueryDatapoints(query, parameters, this.maxAmountOfQueryPoints)) {
                this.getLogger().finest("Querying datapoints for: " + String.valueOf(attributeRef));
                return this.doQueryDatapoints(assetId, attribute, query, parameters);
            }
            return Collections.emptyList();
        }
        catch (DatapointQueryTooLargeException dex) {
            String msg = "Could not query data points for " + assetId + ". It exceeds the data limit of " + this.maxAmountOfQueryPoints + " data points.";
            this.getLogger().log(Level.WARNING, msg, dex);
            throw dex;
        }
        catch (IllegalArgumentException | IllegalStateException ex) {
            this.getLogger().log(Level.WARNING, ex.getMessage());
            throw ex;
        }
    }

    protected boolean canQueryDatapoints(String query, Map<Integer, Object> parameters, int datapointLimit) {
        String countQueryStr;
        int amount;
        if (TextUtil.isNullOrEmpty((String)query)) {
            throw new IllegalArgumentException("Query is null or empty");
        }
        if (datapointLimit > 0 && (amount = ((Integer)this.persistenceService.doReturningTransaction(arg_0 -> AbstractDatapointService.lambda$canQueryDatapoints$8(countQueryStr = "SELECT COUNT(*) FROM (" + query + ") AS count_query", parameters, arg_0))).intValue()) > datapointLimit) {
            throw new DatapointQueryTooLargeException();
        }
        return true;
    }

    protected List<ValueDatapoint<?>> doQueryDatapoints(String assetId, final Attribute<?> attribute, final String query, final Map<Integer, Object> parameters) {
        return (List)this.persistenceService.doReturningTransaction(entityManager -> (List)((Session)entityManager.unwrap(Session.class)).doReturningWork((ReturningWork)new AbstractReturningWork<List<ValueDatapoint<?>>>(this){

            public List<ValueDatapoint<?>> execute(Connection connection) throws SQLException {
                Class attributeType = attribute.getTypeClass();
                boolean isNumber = Number.class.isAssignableFrom(attributeType);
                boolean isBoolean = Boolean.class.isAssignableFrom(attributeType);
                try (PreparedStatement st = connection.prepareStatement(query);){
                    ArrayList arrayList;
                    block17: {
                        if (!parameters.isEmpty()) {
                            int paramCount = st.getParameterMetaData().getParameterCount();
                            for (Map.Entry param : parameters.entrySet()) {
                                if ((Integer)param.getKey() > paramCount) continue;
                                if (param.getValue() instanceof String) {
                                    st.setString((Integer)param.getKey(), param.getValue().toString());
                                    continue;
                                }
                                st.setObject((Integer)param.getKey(), param.getValue());
                            }
                        }
                        ResultSet rs = st.executeQuery();
                        try {
                            ArrayList result = new ArrayList();
                            while (rs.next()) {
                                Object value = null;
                                if (rs.getObject(2) != null) {
                                    value = isNumber || isBoolean ? ValueUtil.getValueCoerced((Object)rs.getObject(2), Double.class).orElse(null) : (rs.getObject(2) instanceof PGobject ? ValueUtil.parse((String)((PGobject)rs.getObject(2)).getValue()).orElse(null) : ValueUtil.getValueCoerced((Object)rs.getObject(2), JsonNode.class).orElse(null));
                                }
                                result.add(new ValueDatapoint(rs.getTimestamp(1).getTime(), value));
                            }
                            arrayList = result;
                            if (rs == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return arrayList;
                }
            }
        }));
    }

    public DatapointPeriod getDatapointPeriod(final String assetId, final String attributeName) {
        return (DatapointPeriod)this.persistenceService.doReturningTransaction(em -> (DatapointPeriod)((Session)em.unwrap(Session.class)).doReturningWork((ReturningWork)new AbstractReturningWork<DatapointPeriod>(){

            public DatapointPeriod execute(Connection connection) throws SQLException {
                String tableName = AbstractDatapointService.this.getDatapointTableName();
                String query = "SELECT DISTINCT periods.* FROM (SELECT entity_id, attribute_name, MIN(timestamp) AS oldestTimestamp, MAX(timestamp) AS latestTimestamp FROM " + tableName + " GROUP BY entity_id, attribute_name) AS periods INNER JOIN " + tableName + " ON " + tableName + ".entity_id = periods.entity_id AND " + tableName + ".attribute_name = periods.attribute_name WHERE " + tableName + ".entity_id = ? AND " + tableName + ".attribute_name = ? ";
                try (PreparedStatement st = connection.prepareStatement(query);){
                    DatapointPeriod datapointPeriod;
                    block16: {
                        ResultSet rs;
                        block14: {
                            DatapointPeriod datapointPeriod2;
                            block15: {
                                st.setString(1, assetId);
                                st.setString(2, attributeName);
                                rs = st.executeQuery();
                                try {
                                    if (!rs.next()) break block14;
                                    datapointPeriod2 = new DatapointPeriod(rs.getString(1), rs.getString(2), Long.valueOf(rs.getTimestamp(3).getTime()), Long.valueOf(rs.getTimestamp(4).getTime()));
                                    if (rs == null) break block15;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return datapointPeriod2;
                        }
                        datapointPeriod = new DatapointPeriod(assetId, attributeName, null, null);
                        if (rs == null) break block16;
                        rs.close();
                    }
                    return datapointPeriod;
                }
            }
        }));
    }

    protected PreparedStatement getUpsertPreparedStatement(Connection connection) throws SQLException {
        return connection.prepareStatement("INSERT INTO " + this.getDatapointTableName() + " (entity_id, attribute_name, value, timestamp) VALUES (?, ?, ?, ?) ON CONFLICT (entity_id, attribute_name, timestamp) DO UPDATE SET value = excluded.value");
    }

    protected void setUpsertValues(PreparedStatement st, String assetId, String attributeName, Object value, long timestamp) throws Exception {
        PGobject pgJsonValue = new PGobject();
        pgJsonValue.setType("jsonb");
        pgJsonValue.setValue(ValueUtil.asJSON((Object)value).orElse("null"));
        st.setString(1, assetId);
        st.setString(2, attributeName);
        st.setObject(3, pgJsonValue);
        st.setObject(4, Instant.ofEpochMilli(timestamp).atZone(ZoneId.systemDefault()).toLocalDateTime());
    }

    protected abstract Class<T> getDatapointClass();

    protected abstract String getDatapointTableName();

    protected abstract Logger getLogger();

    protected void doPurge(String whereClause, Date date) {
        this.persistenceService.doTransaction(em -> em.createQuery("delete from " + this.getDatapointClass().getSimpleName() + " dp " + whereClause).setParameter("dt", (Object)date).executeUpdate());
    }

    protected long getFirstPurgeMillis(Instant currentTime) {
        return ChronoUnit.MILLIS.between(currentTime, currentTime.truncatedTo(ChronoUnit.DAYS).plus(27L, ChronoUnit.HOURS));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }

    private static /* synthetic */ Integer lambda$canQueryDatapoints$8(String countQueryStr, Map parameters, EntityManager entityManager) {
        Query countQuery = entityManager.createNativeQuery(countQueryStr);
        if (parameters != null) {
            parameters.forEach((arg_0, arg_1) -> ((Query)countQuery).setParameter(arg_0, arg_1));
        }
        return ((Number)countQuery.getSingleResult()).intValue();
    }
}

