/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.dashboard;

import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.camel.builder.RouteBuilder;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.dashboard.DashboardResourceImpl;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.asset.UserAssetLink;
import org.openremote.model.dashboard.Dashboard;
import org.openremote.model.dashboard.DashboardAccess;
import org.openremote.model.query.DashboardQuery;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.query.filter.StringPredicate;
import org.openremote.model.util.TextUtil;

public class DashboardStorageService
extends RouteBuilder
implements ContainerService {
    protected static final Logger LOG = Logger.getLogger(DashboardStorageService.class.getName());
    protected ManagerIdentityService identityService;
    protected PersistenceService persistenceService;
    protected AssetStorageService assetStorageService;
    protected TimerService timerService;

    public void configure() throws Exception {
    }

    public void init(Container container) throws Exception {
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.timerService = (TimerService)container.getService(TimerService.class);
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new DashboardResourceImpl((TimerService)container.getService(TimerService.class), this.identityService, this, (MessageBrokerService)container.getService(MessageBrokerService.class)));
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    protected Dashboard[] query(DashboardQuery dashboardQuery, String userId) {
        if (dashboardQuery.getRealm() == null) {
            return new Dashboard[0];
        }
        StringBuilder sql = new StringBuilder("SELECT * FROM Dashboard WHERE realm LIKE :realm");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("realm", dashboardQuery.getRealm().name);
        if (dashboardQuery.getIds() != null) {
            this.appendSqlIdFilter(sql, dashboardQuery, parameters);
        }
        if (dashboardQuery.getNames() != null) {
            this.appendSqlNamesFilter(sql, dashboardQuery, parameters);
        }
        if (dashboardQuery.getUserIds() != null) {
            this.appendSqlUserIdsFilter(sql, dashboardQuery, parameters);
        }
        if (dashboardQuery.getConditions().getDashboard() != null) {
            this.appendSqlDashboardConditionsFilter(sql, dashboardQuery, parameters, userId);
        }
        if (dashboardQuery.getConditions().getAsset() != null) {
            this.appendSqlAssetConditionsFilter(sql, dashboardQuery, parameters, userId);
        }
        if (dashboardQuery.start != null) {
            sql.append(" OFFSET :start");
            parameters.put("start", dashboardQuery.start);
        }
        if (dashboardQuery.limit != null) {
            sql.append(" LIMIT :limit");
            parameters.put("limit", dashboardQuery.limit);
        }
        return (Dashboard[])this.persistenceService.doReturningTransaction(em -> {
            Query query = em.createNativeQuery(sql.toString(), Dashboard.class);
            parameters.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
            return query.getResultList().toArray(new Dashboard[0]);
        });
    }

    protected StringBuilder appendSqlIdFilter(StringBuilder sqlBuilder, DashboardQuery query, Map<String, Object> sqlParams) {
        sqlBuilder.append(" AND id IN (:ids)");
        sqlParams.put("ids", List.of(Optional.ofNullable(query.getIds()).orElse(new String[0])));
        return sqlBuilder;
    }

    protected StringBuilder appendSqlNamesFilter(StringBuilder sqlBuilder, DashboardQuery query, Map<String, Object> sqlParams) {
        IntStream.range(0, query.getNames().length).forEach(index -> {
            String key = "name" + index;
            StringPredicate pred = query.getNames()[index];
            sqlBuilder.append(" AND ").append(pred.caseSensitive ? "display_name" : "UPPER(display_name)").append(pred.negate ? " NOT" : "");
            switch (pred.match) {
                case BEGIN: {
                    sqlBuilder.append(" LIKE :").append(key).append(" || '%'");
                    break;
                }
                case CONTAINS: {
                    sqlBuilder.append(" LIKE '%' || :").append(key).append(" || '%'");
                    break;
                }
                case END: {
                    sqlBuilder.append(" LIKE '%' || :").append(key);
                    break;
                }
                default: {
                    sqlBuilder.append(" = :").append(key);
                }
            }
            sqlParams.put(key, pred.value);
        });
        return sqlBuilder;
    }

    protected StringBuilder appendSqlUserIdsFilter(StringBuilder sqlBuilder, DashboardQuery query, Map<String, Object> sqlParams) {
        sqlBuilder.append(" AND owner_id IN (:ownerIds)");
        sqlParams.put("ownerIds", List.of(Optional.ofNullable(query.getUserIds()).orElse(new String[0])));
        return sqlBuilder;
    }

    protected StringBuilder appendSqlDashboardConditionsFilter(StringBuilder sqlBuilder, DashboardQuery query, Map<String, Object> sqlParams, String userId) {
        DashboardQuery.DashboardConditions dashboardConditions = query.getConditions().getDashboard();
        if (dashboardConditions.getAccess() != null) {
            ArrayList<DashboardAccess> access = new ArrayList<DashboardAccess>(Arrays.asList(dashboardConditions.getAccess()));
            sqlBuilder.append(" AND (");
            if (userId != null && access.contains(DashboardAccess.PRIVATE)) {
                access.remove(DashboardAccess.PRIVATE);
                sqlBuilder.append("(access = 2 AND owner_id = :userId) OR ");
                sqlParams.put("userId", userId);
            }
            sqlBuilder.append("(access IN (:access)))");
            sqlParams.put("access", access.stream().map(Enum::ordinal).collect(Collectors.toList()));
        }
        return sqlBuilder;
    }

    protected StringBuilder appendSqlAssetConditionsFilter(StringBuilder sqlBuilder, DashboardQuery query, Map<String, Object> sqlParams, String userId) {
        List<DashboardQuery.AssetAccess> levels;
        DashboardQuery.AssetConditions assetConditions = query.getConditions().getAsset();
        if (assetConditions.getAccess() != null && (levels = Arrays.asList(Optional.ofNullable(assetConditions.getAccess()).orElse(new DashboardQuery.AssetAccess[0]))).size() == 1 && levels.contains(DashboardQuery.AssetAccess.RESTRICTED)) {
            List<UserAssetLink> userAssetLinks = this.assetStorageService.findUserAssetLinks(query.getRealm().name, userId, null);
            List assetIds = userAssetLinks.stream().map(ua -> ua.getId().getAssetId()).collect(Collectors.toList());
            if (assetConditions.getMinAmount() == DashboardQuery.ConditionMinAmount.AT_LEAST_ONE) {
                sqlBuilder.append(" AND (template IS NULL OR template->'widgets' IS NULL OR EXISTS (");
                sqlBuilder.append("SELECT 1 FROM jsonb_array_elements(COALESCE(template->'widgets', '[]')) AS j(widget) ");
                sqlBuilder.append("LEFT JOIN jsonb_array_elements(COALESCE(widget->'widgetConfig'->'attributeRefs', '[]')) AS a(attributeRef) ");
                sqlBuilder.append("ON a->>'id' IN (:assetIds)))");
            } else if (assetConditions.getMinAmount() == DashboardQuery.ConditionMinAmount.ALL) {
                sqlBuilder.append(" AND NOT EXISTS (");
                sqlBuilder.append("SELECT 1 FROM jsonb_array_elements(template->'widgets') AS j(widget), ");
                sqlBuilder.append("jsonb_array_elements(widget->'widgetConfig'->'attributeRefs') AS a(attributeRef) ");
                sqlBuilder.append("WHERE a->>'id' NOT IN (:assetIds))");
            }
            sqlParams.put("assetIds", assetIds);
        }
        return sqlBuilder;
    }

    public Dashboard createNew(Dashboard dashboard) {
        if (dashboard == null) {
            throw new IllegalArgumentException("No dashboard is specified.");
        }
        return (Dashboard)this.persistenceService.doReturningTransaction(em -> {
            Dashboard d;
            if (dashboard.getId() != null && !dashboard.getId().isEmpty() && (d = (Dashboard)em.find(Dashboard.class, (Object)dashboard.getId())) != null) {
                throw new IllegalArgumentException("This dashboard has already been created.");
            }
            return (Dashboard)em.merge((Object)dashboard);
        });
    }

    public Dashboard update(Dashboard dashboard, String realm, String userId) throws IllegalArgumentException {
        if (dashboard == null || TextUtil.isNullOrEmpty((String)dashboard.getId())) {
            throw new IllegalArgumentException("No dashboard is specified.");
        }
        if (realm == null) {
            throw new IllegalArgumentException("No realm is specified.");
        }
        if (userId == null) {
            throw new IllegalArgumentException("No userId is specified.");
        }
        return (Dashboard)this.persistenceService.doReturningTransaction(em -> {
            StringBuilder sb = new StringBuilder("SELECT d.id FROM Dashboard d where id = :id AND (access <> ").append(DashboardAccess.PRIVATE.ordinal()).append(" OR ownerId = :userId)").append(" AND realm = :realm");
            try {
                em.createQuery(sb.toString(), String.class).setParameter("id", (Object)dashboard.getId()).setParameter("userId", (Object)userId).setParameter("realm", (Object)realm).getSingleResult();
                return (Dashboard)em.merge((Object)dashboard);
            }
            catch (NoResultException e) {
                throw new IllegalArgumentException("Dashboard does not exist or is inaccessible.");
            }
        });
    }

    public boolean delete(String dashboardId, String realm, String userId) throws IllegalArgumentException {
        if (dashboardId == null) {
            throw new IllegalArgumentException("No dashboardId is specified.");
        }
        if (realm == null) {
            throw new IllegalArgumentException("No realm is specified.");
        }
        if (userId == null) {
            throw new IllegalArgumentException("No userId is specified.");
        }
        return (Boolean)this.persistenceService.doReturningTransaction(em -> {
            Dashboard[] dashboards = this.query(new DashboardQuery().ids(new String[]{dashboardId}).realm(new RealmPredicate(realm)).limit(Integer.valueOf(1)), userId);
            if (dashboards == null || dashboards.length == 0) {
                throw new IllegalArgumentException("No dashboards could be found.");
            }
            Query query = em.createQuery("DELETE from Dashboard d where d.id=?1 and d.realm =?2");
            query.setParameter(1, (Object)dashboardId);
            query.setParameter(2, (Object)realm);
            query.executeUpdate();
            return true;
        });
    }
}

