/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.dashboard;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.dashboard.DashboardStorageService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.dashboard.Dashboard;
import org.openremote.model.dashboard.DashboardAccess;
import org.openremote.model.dashboard.DashboardResource;
import org.openremote.model.http.RequestParams;
import org.openremote.model.query.DashboardQuery;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.security.ClientRole;
import org.openremote.model.util.ValueUtil;

public class DashboardResourceImpl
extends ManagerWebResource
implements DashboardResource {
    public static final Logger LOG = Logger.getLogger(DashboardResourceImpl.class.getName());
    protected final DashboardStorageService dashboardStorageService;
    protected final MessageBrokerService messageBrokerService;

    public DashboardResourceImpl(TimerService timerService, ManagerIdentityService identityService, DashboardStorageService dashboardStorageService, MessageBrokerService messageBrokerService) {
        super(timerService, identityService);
        this.dashboardStorageService = dashboardStorageService;
        this.messageBrokerService = messageBrokerService;
    }

    public Dashboard[] getAllRealmDashboards(RequestParams requestParams, String realm) {
        if (realm == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!this.isRealmActiveAndAccessible(realm)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return this.dashboardStorageService.query(this.createDashboardQuery(realm), this.getUserId());
    }

    public Dashboard get(RequestParams requestParams, String realm, String dashboardId) {
        if (realm == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Dashboard[] dashboards = this.dashboardStorageService.query(this.createDashboardQuery(realm).ids(new String[]{dashboardId}).limit(Integer.valueOf(1)), this.getUserId());
        if (dashboards.length == 0) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return dashboards[0];
    }

    public Dashboard[] query(RequestParams requestParams, DashboardQuery query) {
        query = query == null ? this.createDashboardQuery(this.getRequestRealmName()) : this.sanitizeDashboardQuery(query);
        return this.dashboardStorageService.query(query, this.getUserId());
    }

    public Dashboard create(RequestParams requestParams, Dashboard dashboard) {
        String realm = dashboard.getRealm();
        if (realm == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!this.isRealmActiveAndAccessible(dashboard.getRealm())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try {
            dashboard.setOwnerId(this.getUserId());
            dashboard.setAccess(DashboardAccess.SHARED);
            return this.dashboardStorageService.createNew((Dashboard)ValueUtil.clone((Object)dashboard));
        }
        catch (IllegalStateException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public Dashboard update(RequestParams requestParams, Dashboard dashboard) {
        String realm = dashboard.getRealm();
        if (realm == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!this.isRealmActiveAndAccessible(realm)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try {
            return this.dashboardStorageService.update((Dashboard)ValueUtil.clone((Object)dashboard), realm, this.getUserId());
        }
        catch (IllegalArgumentException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (IllegalStateException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public void delete(RequestParams requestParams, String realm, String dashboardId) {
        if (realm == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (!this.isRealmActiveAndAccessible(realm)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try {
            this.dashboardStorageService.delete(dashboardId, realm, this.getUserId());
        }
        catch (IllegalArgumentException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.NOT_FOUND);
        }
        catch (IllegalStateException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected DashboardQuery sanitizeDashboardQuery(DashboardQuery query) {
        HashSet<DashboardAccess> userAccess = new HashSet<DashboardAccess>(Set.of(Optional.ofNullable(query.getConditions().getDashboard().getAccess()).orElse(new DashboardAccess[0])));
        HashSet<DashboardQuery.AssetAccess> assetAccess = new HashSet<DashboardQuery.AssetAccess>(Set.of(Optional.ofNullable(query.getConditions().getAsset().getAccess()).orElse(new DashboardQuery.AssetAccess[0])));
        if (query.getRealm() == null || query.getRealm().name == null) {
            query.realm(new RealmPredicate(this.getRequestRealmName()));
        }
        if (this.isAuthenticated() && !this.isSuperUser() && !query.getRealm().name.equals(this.getAuthenticatedRealmName())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        userAccess.add(DashboardAccess.PUBLIC);
        assetAccess.add(DashboardQuery.AssetAccess.REALM);
        if (this.isAuthenticated()) {
            assetAccess.add(DashboardQuery.AssetAccess.LINKED);
            if (!this.hasResourceRole(ClientRole.READ_INSIGHTS.getValue(), "openremote")) {
                userAccess.remove(DashboardAccess.SHARED);
                userAccess.remove(DashboardAccess.PRIVATE);
            }
            if (this.isRestrictedUser()) {
                assetAccess = new HashSet<DashboardQuery.AssetAccess>(Set.of(DashboardQuery.AssetAccess.RESTRICTED));
            }
        } else {
            userAccess = new HashSet<DashboardAccess>(Set.of(DashboardAccess.PUBLIC));
            assetAccess = new HashSet<DashboardQuery.AssetAccess>(Set.of(DashboardQuery.AssetAccess.REALM));
        }
        return query.conditions(new DashboardQuery.Conditions(new DashboardQuery.DashboardConditions().access(userAccess.toArray(new DashboardAccess[0])), new DashboardQuery.AssetConditions().access(assetAccess.toArray(new DashboardQuery.AssetAccess[0]))));
    }

    protected DashboardQuery createDashboardQuery(String realm) {
        if (realm == null) {
            realm = this.getRequestRealmName();
        }
        return this.sanitizeDashboardQuery(new DashboardQuery().realm(new RealmPredicate(realm)));
    }
}

