/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.asset.console;

import jakarta.ws.rs.BadRequestException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetEvent;
import org.openremote.model.asset.UserAssetLink;
import org.openremote.model.asset.impl.ConsoleAsset;
import org.openremote.model.asset.impl.GroupAsset;
import org.openremote.model.console.ConsoleProviders;
import org.openremote.model.console.ConsoleRegistration;
import org.openremote.model.console.ConsoleResource;
import org.openremote.model.http.RequestParams;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.filter.AttributePredicate;
import org.openremote.model.query.filter.ParentPredicate;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.query.filter.StringPredicate;
import org.openremote.model.query.filter.ValuePredicate;
import org.openremote.model.security.Realm;
import org.openremote.model.util.TextUtil;

public class ConsoleResourceImpl
extends ManagerWebResource
implements ConsoleResource {
    public static final String CONSOLE_PARENT_ASSET_NAME = "Consoles";
    protected Map<String, String> realmConsoleParentMap = new ConcurrentHashMap<String, String>();
    protected AssetStorageService assetStorageService;

    public ConsoleResourceImpl(TimerService timerService, ManagerIdentityService identityService, AssetStorageService assetStorageService, ClientEventService clientEventService) {
        super(timerService, identityService);
        this.assetStorageService = assetStorageService;
        clientEventService.addSubscription(AssetEvent.class, null, this::onAssetChange);
    }

    protected void onAssetChange(AssetEvent event) {
        if (event.getCause() == AssetEvent.Cause.DELETE) {
            this.realmConsoleParentMap.values().remove(event.getId());
        }
    }

    public ConsoleRegistration register(RequestParams requestParams, ConsoleRegistration consoleRegistration) {
        boolean providersChanged;
        if (this.getRequestRealm() == null) {
            throw new BadRequestException("Invalid realm");
        }
        ConsoleAsset consoleAsset = null;
        if (!TextUtil.isNullOrEmpty((String)consoleRegistration.getId())) {
            Asset<?> existingAsset = this.assetStorageService.find(consoleRegistration.getId(), true);
            if (existingAsset != null && !(existingAsset instanceof ConsoleAsset)) {
                throw new BadRequestException("Console registration ID is not for a Console asset: " + consoleRegistration.getId());
            }
            consoleAsset = (ConsoleAsset)existingAsset;
        }
        boolean mergeConsole = false;
        if (consoleAsset == null) {
            mergeConsole = true;
            consoleAsset = ConsoleResourceImpl.initConsoleAsset(consoleRegistration);
            consoleAsset.setRealm(this.getRequestRealmName());
            consoleAsset.setParentId(this.getConsoleParentAssetId(this.getRequestRealmName()));
            consoleAsset.setId(consoleRegistration.getId());
            if (!this.isAuthenticated()) {
                consoleAsset.setAccessPublicRead(true);
            }
        }
        if (mergeConsole || !Objects.equals(consoleAsset.getConsoleName().orElse(null), consoleRegistration.getName())) {
            mergeConsole = true;
            consoleAsset.setConsoleName(consoleRegistration.getName());
        }
        boolean bl = providersChanged = mergeConsole || consoleAsset.getConsoleProviders().map(providers -> providers.equals((Object)consoleRegistration.getProviders())).orElseGet(() -> consoleRegistration.getProviders() != null) == false;
        if (providersChanged) {
            mergeConsole = true;
            consoleAsset.setConsoleProviders(new ConsoleProviders(consoleRegistration.getProviders()));
        }
        if (mergeConsole || !Objects.equals(consoleAsset.getConsoleVersion().orElse(null), consoleRegistration.getVersion())) {
            mergeConsole = true;
            consoleAsset.setConsoleVersion(consoleRegistration.getVersion());
        }
        if (mergeConsole || !Objects.equals(consoleAsset.getConsolePlatform().orElse(null), consoleRegistration.getPlatform())) {
            mergeConsole = true;
            consoleAsset.setConsolePlatform(consoleRegistration.getPlatform());
        }
        if (mergeConsole) {
            consoleAsset = this.assetStorageService.merge(consoleAsset);
        }
        consoleRegistration.setId(consoleAsset.getId());
        if (this.isAuthenticated()) {
            List<UserAssetLink> userAssetLinks = this.assetStorageService.findUserAssetLinks(this.getAuthenticatedRealmName(), null, consoleAsset.getId());
            List<UserAssetLink> otherUserAssetLinks = userAssetLinks.stream().filter(link -> !this.getUserId().equals(link.getId().getUserId())).toList();
            if (!otherUserAssetLinks.isEmpty()) {
                this.assetStorageService.deleteUserAssetLinks(otherUserAssetLinks);
            }
            this.assetStorageService.storeUserAssetLinks(List.of(new UserAssetLink(this.getAuthenticatedRealmName(), this.getUserId(), consoleAsset.getId())));
        }
        return consoleRegistration;
    }

    public static ConsoleAsset initConsoleAsset(ConsoleRegistration consoleRegistration) {
        return new ConsoleAsset(consoleRegistration.getName());
    }

    public synchronized String getConsoleParentAssetId(String realm) {
        String id = this.realmConsoleParentMap.get(realm);
        if (TextUtil.isNullOrEmpty((String)id)) {
            Asset<?> consoleParent = ConsoleResourceImpl.getConsoleParentAsset(this.assetStorageService, this.getRequestRealm());
            id = consoleParent.getId();
            this.realmConsoleParentMap.put(realm, id);
        }
        return id;
    }

    public static Asset<?> getConsoleParentAsset(AssetStorageService assetStorageService, Realm realm) {
        GroupAsset consoleParent = (GroupAsset)assetStorageService.find(new AssetQuery().select(new AssetQuery.Select().excludeAttributes()).names(new String[]{CONSOLE_PARENT_ASSET_NAME}).parents(new ParentPredicate[]{new ParentPredicate(null)}).types(GroupAsset.class).realm(new RealmPredicate(realm.getName())).attributes(new AttributePredicate[]{new AttributePredicate("childAssetType", (ValuePredicate)new StringPredicate(ConsoleAsset.DESCRIPTOR.getName()))}));
        if (consoleParent == null) {
            consoleParent = new GroupAsset(CONSOLE_PARENT_ASSET_NAME, ConsoleAsset.class);
            consoleParent.setChildAssetType(ConsoleAsset.DESCRIPTOR.getName());
            consoleParent.setRealm(realm.getName());
            consoleParent = assetStorageService.merge(consoleParent);
        }
        return consoleParent;
    }
}

