/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.asset;

import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.logging.Logger;
import org.openremote.manager.agent.AgentService;
import org.openremote.manager.asset.AssetProcessingException;
import org.openremote.manager.asset.AssetProcessingService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.gateway.GatewayService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.asset.Asset;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeInfo;
import org.openremote.model.attribute.AttributeLink;
import org.openremote.model.attribute.AttributeRef;
import org.openremote.model.protocol.ProtocolUtil;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.util.Pair;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.MetaItemType;
import org.openremote.model.value.ValueFilter;

public class AttributeLinkingService
implements ContainerService {
    private static final Logger LOG = Logger.getLogger(AttributeLinkingService.class.getName());
    protected AssetProcessingService assetProcessingService;
    protected AssetStorageService assetStorageService;
    protected AgentService agentService;
    protected GatewayService gatewayService;

    public void init(Container container) throws Exception {
        this.assetProcessingService = (AssetProcessingService)container.getService(AssetProcessingService.class);
        this.assetStorageService = (AssetStorageService)container.getService(AssetStorageService.class);
        this.agentService = (AgentService)container.getService(AgentService.class);
        this.gatewayService = (GatewayService)container.getService(GatewayService.class);
        ClientEventService clientEventService = (ClientEventService)container.getService(ClientEventService.class);
        clientEventService.addSubscription(AttributeEvent.class, null, this::onAttributeEvent);
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public void onAttributeEvent(AttributeEvent event) {
        if (this.getClass().getSimpleName().equals(event.getSource())) {
            LOG.finest("Attribute update came from this service so ignoring to avoid infinite loops: ref=" + String.valueOf(event.getRef()));
            return;
        }
        if (this.gatewayService.getLocallyRegisteredGatewayId(event.getId(), null) != null) {
            return;
        }
        event.getMetaValue(MetaItemType.ATTRIBUTE_LINKS).ifPresent(attributeLinks -> Arrays.stream(attributeLinks).forEach(attributeLink -> this.processLinkedAttributeUpdate((AttributeInfo)event, (AttributeLink)attributeLink)));
    }

    protected void sendAttributeEvent(AttributeEvent attributeEvent) {
        LOG.finest("Sending attribute event for linked attribute: " + String.valueOf(attributeEvent));
        this.assetProcessingService.sendAttributeEvent(attributeEvent, this.getClass().getSimpleName());
    }

    protected void processLinkedAttributeUpdate(AttributeInfo attributeInfo, AttributeLink attributeLink) {
        if (attributeLink == null) {
            return;
        }
        LOG.finest("Processing attribute links for updated attribute ref=" + String.valueOf(attributeInfo.getRef()));
        Pair<Boolean, Object> sendConvertedValue = this.convertValueForLinkedAttribute(this.assetStorageService, attributeInfo, attributeLink);
        if (((Boolean)sendConvertedValue.key).booleanValue()) {
            LOG.finest("Value converter matched ignore value");
            return;
        }
        Object[] value = new Object[]{sendConvertedValue.value};
        AttributeLinkingService.getAttribute(this.assetStorageService, attributeInfo.getRealm(), attributeLink.getAttributeRef()).ifPresent(attr -> {
            if (value[0] != null && !attr.getTypeClass().isAssignableFrom(value[0].getClass())) {
                Object val = ValueUtil.convert((Object)value[0], (Class)attr.getTypeClass());
                if (val == null) {
                    LOG.warning("Failed to convert value into attribute value type (" + String.valueOf(value[0].getClass()) + " -> " + String.valueOf(attr.getTypeClass()) + "): " + String.valueOf(attributeInfo.getRef()));
                    return;
                }
                value[0] = val;
            }
            this.sendAttributeEvent(new AttributeEvent(attributeLink.getAttributeRef(), value[0]));
        });
    }

    protected Pair<Boolean, Object> convertValueForLinkedAttribute(AssetStorageService assetStorageService, AttributeInfo attributeInfo, AttributeLink attributeLink) throws AssetProcessingException {
        Object originalValue = attributeInfo.getValue().orElse(null);
        if (attributeLink.getFilters() != null) {
            originalValue = ValueUtil.applyValueFilters(originalValue, (ValueFilter[])attributeLink.getFilters());
        }
        Object finalOriginalValue = originalValue;
        return attributeLink.getConverter().map(converter -> {
            Pair converterValue = ProtocolUtil.applyValueConverter((Object)finalOriginalValue, (Map)converter);
            if (((Boolean)converterValue.key).booleanValue()) {
                return converterValue;
            }
            return AttributeLinkingService.getSpecialConverter(converterValue.value).map(specialConverter -> AttributeLinkingService.doSpecialConversion(assetStorageService, attributeInfo, specialConverter, attributeLink.getAttributeRef())).orElse(converterValue);
        }).orElse(new Pair((Object)false, originalValue));
    }

    protected static Optional<AttributeLink.ConverterType> getSpecialConverter(Object value) {
        if (value != null && ValueUtil.isString(value.getClass())) {
            return AttributeLink.ConverterType.fromValue((String)ValueUtil.getValue((Object)value, String.class).orElse(""));
        }
        return Optional.empty();
    }

    protected static Pair<Boolean, Object> doSpecialConversion(AssetStorageService assetStorageService, AttributeInfo attributeInfo, AttributeLink.ConverterType converter, AttributeRef linkedAttributeRef) throws RuntimeException {
        switch (converter) {
            case TOGGLE: {
                try {
                    Attribute<?> currentAttribute = AttributeLinkingService.getAttribute(assetStorageService, attributeInfo.getRealm(), linkedAttributeRef).orElseThrow(() -> new RuntimeException("Cannot toggle value as attribute cannot be found: " + String.valueOf(linkedAttributeRef)));
                    if (!ValueUtil.isBoolean((Class)currentAttribute.getTypeClass())) {
                        throw new RuntimeException("Cannot toggle value as attribute is not of type BOOLEAN: " + String.valueOf(linkedAttributeRef));
                    }
                    return new Pair((Object)false, (Object)(currentAttribute.getValue(Boolean.class).orElse(false) == false ? 1 : 0));
                }
                catch (NoSuchElementException e) {
                    LOG.fine("The attribute doesn't exist so ignoring toggle value request: " + String.valueOf(linkedAttributeRef));
                    return new Pair((Object)true, null);
                }
            }
            case INCREMENT: 
            case DECREMENT: {
                try {
                    Attribute<?> currentAttribute = AttributeLinkingService.getAttribute(assetStorageService, attributeInfo.getRealm(), linkedAttributeRef).orElseThrow(() -> new RuntimeException("Cannot toggle value as attribute cannot be found: " + String.valueOf(linkedAttributeRef)));
                    if (!ValueUtil.isNumber((Class)currentAttribute.getTypeClass())) {
                        throw new RuntimeException("Cannot increment/decrement value as attribute is not of type NUMBER: " + String.valueOf(linkedAttributeRef));
                    }
                    int change = converter == AttributeLink.ConverterType.INCREMENT ? 1 : -1;
                    return new Pair((Object)false, (Object)(ValueUtil.getValueCoerced(currentAttribute.getValue().orElse(null), Double.class).orElse(0.0) + (double)change));
                }
                catch (NoSuchElementException e) {
                    LOG.fine("The attribute doesn't exist so ignoring increment/decrement value request: " + String.valueOf(linkedAttributeRef));
                    return new Pair((Object)true, null);
                }
            }
        }
        throw new RuntimeException("Converter is not supported ref=" + String.valueOf(linkedAttributeRef) + ": " + String.valueOf(converter));
    }

    protected static Optional<Attribute<?>> getAttribute(AssetStorageService assetStorageService, String realm, AttributeRef attributeRef) {
        Attribute attribute;
        Asset<?> asset = assetStorageService.find(new AssetQuery().realm(new RealmPredicate(realm)).ids(new String[]{attributeRef.getId()}));
        Attribute attribute2 = attribute = asset != null ? (Attribute)asset.getAttributes().get(attributeRef.getName()).orElse(null) : null;
        if (attribute == null) {
            LOG.warning("Attribute or asset could not be found: " + String.valueOf(attributeRef));
        }
        return Optional.ofNullable(attribute);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }
}

