/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.asset;

import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.validation.ConstraintViolationException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.hibernate.Session;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.ReturningWork;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.security.AuthContext;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetResourceImpl;
import org.openremote.manager.asset.console.ConsoleResourceImpl;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.event.EventSubscriptionAuthorizer;
import org.openremote.manager.gateway.GatewayService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.PersistenceEvent;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetEvent;
import org.openremote.model.asset.AssetFilter;
import org.openremote.model.asset.AssetInfo;
import org.openremote.model.asset.AssetsEvent;
import org.openremote.model.asset.HasAssetQuery;
import org.openremote.model.asset.ReadAssetEvent;
import org.openremote.model.asset.ReadAssetsEvent;
import org.openremote.model.asset.ReadAttributeEvent;
import org.openremote.model.asset.UserAssetLink;
import org.openremote.model.asset.impl.GatewayAsset;
import org.openremote.model.asset.impl.GroupAsset;
import org.openremote.model.asset.impl.ThingAsset;
import org.openremote.model.asset.impl.UnknownAsset;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeMap;
import org.openremote.model.event.RespondableEvent;
import org.openremote.model.event.shared.EventFilter;
import org.openremote.model.event.shared.EventSubscription;
import org.openremote.model.event.shared.SharedEvent;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.LogicGroup;
import org.openremote.model.query.filter.ArrayPredicate;
import org.openremote.model.query.filter.AttributePredicate;
import org.openremote.model.query.filter.BooleanPredicate;
import org.openremote.model.query.filter.CalendarEventPredicate;
import org.openremote.model.query.filter.DateTimePredicate;
import org.openremote.model.query.filter.GeofencePredicate;
import org.openremote.model.query.filter.NameValuePredicate;
import org.openremote.model.query.filter.NumberPredicate;
import org.openremote.model.query.filter.ParentPredicate;
import org.openremote.model.query.filter.RadialGeofencePredicate;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.query.filter.RectangularGeofencePredicate;
import org.openremote.model.query.filter.StringPredicate;
import org.openremote.model.query.filter.ValueEmptyPredicate;
import org.openremote.model.query.filter.ValuePredicate;
import org.openremote.model.security.ClientRole;
import org.openremote.model.security.User;
import org.openremote.model.util.LockByKey;
import org.openremote.model.util.Pair;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.AbstractNameValueDescriptorHolder;
import org.openremote.model.value.MetaItemType;
import org.postgresql.util.PGobject;

public class AssetStorageService
extends RouteBuilder
implements ContainerService {
    private static final Logger LOG = Logger.getLogger(AssetStorageService.class.getName());
    public static final int PRIORITY = 0;
    protected TimerService timerService;
    protected PersistenceService persistenceService;
    protected ManagerIdentityService identityService;
    protected ClientEventService clientEventService;
    protected GatewayService gatewayService;
    protected ExecutorService executorService;
    protected final LockByKey assetLocks = new LockByKey();

    public static <T extends SharedEvent> EventSubscriptionAuthorizer assetInfoAuthorizer(ManagerIdentityService identityService, AssetStorageService assetStorageService) {
        return (requestRealm, auth, sub) -> {
            String realm;
            String userId;
            EventSubscription subscription = sub;
            if (subscription.getFilter() != null && !(subscription.getFilter() instanceof AssetFilter)) {
                return false;
            }
            AssetFilter filter = (AssetFilter)subscription.getFilter();
            if (filter == null) {
                filter = new AssetFilter();
                subscription.setFilter((EventFilter)filter);
            }
            if (auth != null && auth.isSuperUser()) {
                return true;
            }
            requestRealm = filter.getRealm() != null ? filter.getRealm() : requestRealm;
            boolean isAnonymous = auth == null;
            boolean isRestricted = identityService.getIdentityProvider().isRestrictedUser(auth);
            String string = userId = !isAnonymous ? auth.getUserId() : null;
            String string2 = requestRealm != null ? requestRealm : (realm = !isAnonymous ? auth.getAuthenticatedRealmName() : null);
            if (realm == null) {
                LOG.info("Anonymous AssetInfo subscriptions must specify a realm");
                return false;
            }
            if (isAnonymous || requestRealm != null && !requestRealm.equals(auth.getAuthenticatedRealmName())) {
                filter.setPublicEvents(true);
            }
            if (!(filter.isPublicEvents() || !isAnonymous && auth.hasResourceRole(ClientRole.READ_ASSETS.getValue(), "openremote"))) {
                return false;
            }
            filter.setRealm(realm);
            if (isRestricted) {
                filter.setRestrictedEvents(true);
                filter.setUserAssetIds(assetStorageService.findUserAssetLinks(realm, userId, null).stream().map(userAssetLink -> userAssetLink.getId().getAssetId()).toList());
            }
            if (filter.getAssetIds() != null) {
                for (String assetId : filter.getAssetIds()) {
                    Asset<?> asset = assetStorageService.find(assetId, false);
                    if (asset == null) {
                        return false;
                    }
                    if (!(isRestricted ? !filter.getUserAssetIds().contains(assetId) : !asset.getRealm().equals(realm))) continue;
                    return false;
                }
            }
            return true;
        };
    }

    protected static boolean calendarEventPredicateMatches(Supplier<Long> currentMillisSupplier, AssetQuery query, Asset<?> asset) {
        if (query.attributes == null) {
            return true;
        }
        return AssetStorageService.calendarEventPredicateMatches(currentMillisSupplier, (LogicGroup<AttributePredicate>)query.attributes, asset);
    }

    protected static boolean calendarEventPredicateMatches(Supplier<Long> currentMillisSupplier, LogicGroup<AttributePredicate> group, Asset<?> asset) {
        boolean isOr = group.operator == LogicGroup.Operator.OR;
        boolean matches = true;
        if (group.items != null) {
            for (AttributePredicate attributePredicate : group.items) {
                if (!(attributePredicate.value instanceof CalendarEventPredicate)) continue;
                Predicate namePredicate = ValuePredicate.asPredicateOrTrue(currentMillisSupplier, (ValuePredicate)attributePredicate.name);
                Predicate valuePredicate = ValuePredicate.asPredicateOrTrue(currentMillisSupplier, (ValuePredicate)attributePredicate.value);
                List<Attribute> matchedAttributes = asset.getAttributes().stream().filter(attr -> namePredicate.test(attr.getName())).toList();
                matches = true;
                if (!matchedAttributes.isEmpty()) {
                    for (Attribute attribute : matchedAttributes) {
                        matches = valuePredicate.test(attribute.getValue().orElse(null));
                        if ((!isOr || !matches) && (isOr || matches)) continue;
                        break;
                    }
                }
                if ((!isOr || !matches) && (isOr || matches)) continue;
                break;
            }
        }
        if (isOr && matches) {
            return true;
        }
        if (!isOr && !matches) {
            return false;
        }
        if (group.groups != null) {
            for (LogicGroup childGroup : group.groups) {
                matches = AssetStorageService.calendarEventPredicateMatches(currentMillisSupplier, (LogicGroup<AttributePredicate>)childGroup, asset);
                if ((!isOr || !matches) && (isOr || matches)) continue;
                break;
            }
        }
        return matches;
    }

    public int getPriority() {
        return 0;
    }

    public void init(Container container) throws Exception {
        this.timerService = (TimerService)container.getService(TimerService.class);
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.clientEventService = (ClientEventService)container.getService(ClientEventService.class);
        this.gatewayService = (GatewayService)container.getService(GatewayService.class);
        this.executorService = container.getExecutor();
        EventSubscriptionAuthorizer assetEventAuthorizer = AssetStorageService.assetInfoAuthorizer(this.identityService, this);
        this.clientEventService.addSubscriptionAuthorizer((realm, auth, subscription) -> {
            if (!subscription.isEventType(AssetEvent.class)) {
                return false;
            }
            return assetEventAuthorizer.authorise(realm, auth, subscription);
        });
        this.clientEventService.addEventAuthorizer((realm, auth, event) -> {
            ReadAttributeEvent readAttributeEvent;
            boolean authorize = event instanceof HasAssetQuery;
            if (event instanceof ReadAssetEvent) {
                ReadAssetEvent readAssetEvent = (ReadAssetEvent)event;
                if (readAssetEvent.getAssetQuery() == null) {
                    LOG.info("Read asset event must specify an asset ID");
                    return false;
                }
            } else if (event instanceof ReadAttributeEvent && (readAttributeEvent = (ReadAttributeEvent)event).getAssetQuery() == null) {
                LOG.info("Read attribute event must specify an asset ID");
                return false;
            }
            return authorize && this.authorizeAssetQuery(((HasAssetQuery)event).getAssetQuery(), auth, realm);
        });
        this.clientEventService.addSubscription(ReadAssetEvent.class, this::onReadRequest);
        this.clientEventService.addSubscription(ReadAssetsEvent.class, this::onReadRequest);
        this.clientEventService.addSubscription(ReadAttributeEvent.class, this::onReadRequest);
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new AssetResourceImpl((TimerService)container.getService(TimerService.class), this.identityService, this, (MessageBrokerService)container.getService(MessageBrokerService.class), this.clientEventService));
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new ConsoleResourceImpl((TimerService)container.getService(TimerService.class), this.identityService, this, this.clientEventService));
        ((MessageBrokerService)container.getService(MessageBrokerService.class)).getContext().addRoutes((RoutesBuilder)this);
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public void configure() throws Exception {
        this.from("seda://PersistenceTopic?multipleConsumers=true&concurrentConsumers=1&waitForTaskToComplete=NEVER&purgeWhenStopping=true&discardIfNoConsumers=true&size=25000").routeId("Persistence-Asset").filter(PersistenceService.isPersistenceEventForEntityType(Asset.class)).process(exchange -> this.publishModificationEvents((PersistenceEvent)exchange.getIn().getBody(PersistenceEvent.class)));
    }

    public boolean authorizeAssetQuery(AssetQuery query, AuthContext authContext, String requestRealm) {
        String realm;
        boolean isAnonymous = authContext == null;
        boolean isSuperUser = authContext != null && authContext.isSuperUser();
        boolean isRestricted = this.identityService.getIdentityProvider().isRestrictedUser(authContext);
        String string = query.realm != null ? query.realm.name : (requestRealm != null ? requestRealm : (realm = !isSuperUser && authContext != null ? authContext.getAuthenticatedRealmName() : null));
        if (!isSuperUser) {
            if (TextUtil.isNullOrEmpty((String)realm)) {
                String msg = "Realm must be specified to read assets";
                LOG.finest(msg);
                return false;
            }
            if (isAnonymous) {
                if (query.access != null && query.access != AssetQuery.Access.PUBLIC) {
                    String msg = "Only public access allowed for anonymous requests";
                    LOG.finest(msg);
                    return false;
                }
                query.access = AssetQuery.Access.PUBLIC;
            } else if (isRestricted) {
                if (query.access == AssetQuery.Access.PRIVATE) {
                    String msg = "Only public or restricted access allowed for restricted requests";
                    LOG.finest(msg);
                    return false;
                }
                if (query.access == null) {
                    query.access = AssetQuery.Access.PROTECTED;
                }
            }
            if (query.access != AssetQuery.Access.PUBLIC && !authContext.hasResourceRole(ClientRole.READ_ASSETS.getValue(), "openremote")) {
                String msg = "User must have '" + ClientRole.READ_ASSETS.getValue() + "' role to read non public assets";
                LOG.finest(msg);
                return false;
            }
            if (query.access != AssetQuery.Access.PUBLIC && !realm.equals(authContext.getAuthenticatedRealmName())) {
                String msg = "Realm must match authenticated realm for non public access queries";
                LOG.finest(msg);
                return false;
            }
            query.realm = new RealmPredicate(realm);
            if (query.access == AssetQuery.Access.PROTECTED) {
                query.userIds(new String[]{authContext.getUserId()});
            }
        }
        if (!this.identityService.getIdentityProvider().isRealmActiveAndAccessible(authContext, realm)) {
            String msg = "Realm is not present or is inactive";
            LOG.finest(msg);
            return false;
        }
        return true;
    }

    public Asset<?> find(String assetId) {
        if (assetId == null) {
            throw new IllegalArgumentException("Can't query null asset identifier");
        }
        return this.find(new AssetQuery().ids(new String[]{assetId}));
    }

    public <T extends Asset<?>> T find(String assetId, Class<T> assetType) {
        Asset<?> asset = this.find(assetId);
        if (asset != null && !assetType.isAssignableFrom(asset.getClass())) {
            asset = null;
        }
        return (T)asset;
    }

    public Asset<?> find(String assetId, boolean loadComplete) {
        if (assetId == null) {
            throw new IllegalArgumentException("Can't query null asset identifier");
        }
        return this.find(new AssetQuery().select(loadComplete ? null : new AssetQuery.Select().excludeAttributes()).ids(new String[]{assetId}));
    }

    public <T extends Asset<?>> T find(String assetId, boolean loadComplete, Class<T> assetType) {
        Asset<?> asset = this.find(assetId, loadComplete);
        if (asset != null && !assetType.isAssignableFrom(asset.getClass())) {
            asset = null;
        }
        return (T)asset;
    }

    public Asset<?> find(EntityManager em, String assetId, boolean loadComplete) {
        return this.find(em, assetId, loadComplete, AssetQuery.Access.PRIVATE);
    }

    public Asset<?> find(String assetId, boolean loadComplete, AssetQuery.Access access) {
        if (assetId == null) {
            throw new IllegalArgumentException("Can't query null asset identifier");
        }
        return this.find(new AssetQuery().select(loadComplete ? null : new AssetQuery.Select().excludeAttributes()).ids(new String[]{assetId}).access(access));
    }

    public Asset<?> find(AssetQuery query) {
        return (Asset)this.persistenceService.doReturningTransaction(em -> this.find((EntityManager)em, query));
    }

    public Asset<?> find(EntityManager em, AssetQuery query) {
        query.limit = 1;
        List<Asset<?>> result = this.findAll(em, query);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public List<Asset<?>> findAll(AssetQuery query) {
        return (List)this.persistenceService.doReturningTransaction(em -> this.findAll((EntityManager)em, query));
    }

    public List<String> findNames(String ... ids) {
        if (ids == null || ids.length == 0) {
            return new ArrayList<String>();
        }
        return (List)this.persistenceService.doReturningTransaction(em -> {
            List result = em.createQuery("select a.id, a.name from Asset a where a.id in :ids", Object[].class).setParameter("ids", Arrays.asList(ids)).getResultList();
            ArrayList<String> names = new ArrayList<String>();
            block0: for (String id : ids) {
                for (Object[] tuple : result) {
                    if (!tuple[0].equals(id)) continue;
                    names.add((String)tuple[1]);
                    continue block0;
                }
            }
            return names;
        });
    }

    public <T extends Asset<?>> T merge(T asset) throws IllegalStateException, ConstraintViolationException {
        return this.merge(asset, false);
    }

    public <T extends Asset<?>> T merge(T asset, boolean overrideVersion) throws IllegalStateException, ConstraintViolationException {
        return this.merge(asset, overrideVersion, null, null);
    }

    public <T extends Asset<?>> T merge(T asset, String userName) throws IllegalStateException, ConstraintViolationException {
        return this.merge(asset, false, null, userName);
    }

    public <T extends Asset<?>> T merge(T asset, boolean overrideVersion, GatewayAsset requestingGatewayAsset, String userName) throws IllegalStateException, ConstraintViolationException {
        String assetId;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Merging asset: " + String.valueOf(asset));
        }
        long startTime = System.currentTimeMillis();
        String string = assetId = asset.getId() != null ? asset.getId() : "";
        if (requestingGatewayAsset != null) {
            if (asset.getId() == null || asset.getParentId() == null || asset.getRealm() == null) {
                String msg = "GatewayAsset descendant must have an ID, parent ID and realm defined: asset=" + String.valueOf(asset);
                LOG.warning(msg);
                throw new IllegalStateException(msg);
            }
        } else {
            String gatewayId = null;
            if (asset.getId() != null || asset.getParentId() != null) {
                gatewayId = this.gatewayService.getLocallyRegisteredGatewayId(asset.getId(), asset.getParentId());
            }
            if (gatewayId != null) {
                String msg = "Cannot directly add or modify a descendant asset on a gateway asset, do this on the gateway itself: Gateway ID=" + gatewayId;
                LOG.info(msg);
                throw new IllegalStateException(msg);
            }
            if (asset.getRealm() == null) {
                String msg = "Asset realm must be set : asset=" + String.valueOf(asset);
                LOG.warning(msg);
                throw new IllegalStateException(msg);
            }
            Set validationFailures = ValueUtil.validate(asset, (Class[])new Class[0]);
            if (!validationFailures.isEmpty()) {
                String msg = "Asset merge failed as asset has failed constraint validation: asset=" + String.valueOf(asset);
                ConstraintViolationException ex = new ConstraintViolationException(validationFailures);
                LOG.log(Level.WARNING, msg + ", exception=" + ex.getMessage());
                throw ex;
            }
        }
        return (T)this.withAssetLock(assetId, () -> (Asset)this.persistenceService.doReturningTransaction(em -> {
            Asset updatedAsset;
            String childAssetType;
            Asset existingAsset;
            Asset asset2 = existingAsset = TextUtil.isNullOrEmpty((String)asset.getId()) ? null : (Asset)em.find(Asset.class, (Object)asset.getId());
            if (existingAsset != null) {
                if (!existingAsset.getType().equals(asset.getType())) {
                    String msg = "Asset type cannot be changed: asset=" + String.valueOf(asset);
                    LOG.warning(msg);
                    throw new IllegalStateException(msg);
                }
                if (!existingAsset.getRealm().equals(asset.getRealm())) {
                    String msg = "Asset realm cannot be changed: asset=" + String.valueOf(asset);
                    LOG.warning(msg);
                    throw new IllegalStateException(msg);
                }
                asset.getAttributes().stream().forEach(attr -> existingAsset.getAttribute(attr.getName()).ifPresent(existingAttr -> {
                    if (!attr.deepEquals(existingAttr) && attr.getTimestamp().orElse(0L) <= existingAttr.getTimestamp().orElse(0L)) {
                        attr.setTimestamp(Math.max(existingAttr.getTimestamp().orElse(0L) + 1L, this.timerService.getCurrentTimeMillis()));
                    }
                }));
                if (overrideVersion) {
                    asset.setVersion(existingAsset.getVersion());
                }
            }
            if (!this.identityService.getIdentityProvider().realmExists(asset.getRealm())) {
                String msg = "Asset realm not found or is inactive: asset=" + String.valueOf(asset);
                LOG.warning(msg);
                throw new IllegalStateException(msg);
            }
            if (asset.getParentId() != null && asset.getParentId().equals(asset.getId())) {
                String msg = "Asset parent cannot be the asset: asset=" + String.valueOf(asset);
                LOG.warning(msg);
                throw new IllegalStateException(msg);
            }
            if (existingAsset == null && asset.getParentId() != null || existingAsset != null && asset.getParentId() != null && !asset.getParentId().equals(existingAsset.getParentId())) {
                Asset<?> parent = this.find((EntityManager)em, asset.getParentId(), true);
                if (parent == null) {
                    String msg = "Asset parent not found: asset=" + String.valueOf(asset);
                    LOG.warning(msg);
                    throw new IllegalStateException(msg);
                }
                if (parent.pathContains(asset.getId())) {
                    String msg = "Asset parent cannot be a descendant of the asset: asset=" + String.valueOf(asset);
                    LOG.warning(msg);
                    throw new IllegalStateException(msg);
                }
                if (!parent.getRealm().equals(asset.getRealm())) {
                    String msg = "Asset parent must be in the same realm: asset=" + String.valueOf(asset);
                    LOG.warning(msg);
                    throw new IllegalStateException(msg);
                }
                if (parent instanceof GroupAsset) {
                    Class<?> clazz;
                    childAssetType = (String)parent.getAttributes().getValue((AbstractNameValueDescriptorHolder)GroupAsset.CHILD_ASSET_TYPE).orElseThrow(() -> {
                        String msg = "Asset parent is of type GROUP but the childAssetType attribute is invalid: asset=" + String.valueOf(asset);
                        LOG.warning(msg);
                        return new IllegalStateException(msg);
                    });
                    boolean typeMatch = childAssetType.equals(clazz.getSimpleName());
                    for (clazz = asset.getClass(); !typeMatch && clazz != Asset.class; clazz = clazz.getSuperclass()) {
                        typeMatch = childAssetType.equals(clazz.getSimpleName());
                    }
                    if (!typeMatch) {
                        String msg = "Asset type does not match parent GROUP asset's childAssetType attribute: asset=" + String.valueOf(asset);
                        LOG.warning(msg);
                        throw new IllegalStateException(msg);
                    }
                }
            }
            if (asset instanceof GroupAsset) {
                String existingChildAssetType;
                GroupAsset groupAsset = (GroupAsset)asset;
                childAssetType = groupAsset.getChildAssetType().orElseGet(() -> {
                    groupAsset.setChildAssetType("");
                    return "";
                });
                String string = existingChildAssetType = existingAsset != null ? (String)((GroupAsset)existingAsset).getChildAssetType().orElseThrow(() -> {
                    String msg = "Asset of type GROUP childAssetType attribute must be a valid string: asset=" + String.valueOf(asset);
                    LOG.warning(msg);
                    return new IllegalStateException(msg);
                }) : childAssetType;
                if (!(childAssetType.isEmpty() || existingChildAssetType.isEmpty() || childAssetType.equals(existingChildAssetType))) {
                    String msg = "Asset of type GROUP so childAssetType attribute cannot be changed: asset=" + String.valueOf(asset);
                    LOG.warning(msg);
                    throw new IllegalStateException(msg);
                }
            }
            asset.getAttributes().forEach(attribute -> {
                if (!attribute.hasExplicitTimestamp()) {
                    attribute.setTimestamp(this.timerService.getCurrentTimeMillis());
                }
            });
            User user = null;
            if (!TextUtil.isNullOrEmpty((String)userName) && (user = this.identityService.getIdentityProvider().getUserByUsername(asset.getRealm(), userName)) == null) {
                String msg = "User not found: " + userName;
                LOG.warning(msg);
                throw new IllegalStateException(msg);
            }
            if (existingAsset instanceof UnknownAsset && !(asset instanceof UnknownAsset)) {
                existingAsset.setAttributes(asset.getAttributes());
                existingAsset.setName(asset.getName());
                existingAsset.setVersion(asset.getVersion());
                existingAsset.setParentId(asset.getParentId());
                existingAsset.setAccessPublicRead(asset.isAccessPublicRead());
                updatedAsset = (Asset)em.merge((Object)existingAsset);
            } else {
                updatedAsset = (Asset)em.merge((Object)asset);
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Asset merge took: " + (System.currentTimeMillis() - startTime) + "ms");
            }
            if (user != null) {
                this.createUserAssetLinks((EntityManager)em, Collections.singletonList(new UserAssetLink(user.getRealm(), user.getId(), updatedAsset.getId())));
            }
            if (existingAsset == null && updatedAsset instanceof ThingAsset && !ThingAsset.DESCRIPTOR.getName().equals(updatedAsset.getType())) {
                em.createNativeQuery("update ASSET set type = ? where id = ?;").setParameter(1, (Object)updatedAsset.getType()).setParameter(2, (Object)updatedAsset.getId()).executeUpdate();
            }
            return updatedAsset;
        }));
    }

    public boolean delete(List<String> assetIds) {
        return this.delete(assetIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(List<String> assetIds, boolean skipGatewayCheck) {
        ArrayList<String> ids = new ArrayList<String>(assetIds);
        if (!skipGatewayCheck) {
            boolean gatewayDescendant = ids.stream().anyMatch(id -> this.gatewayService.getLocallyRegisteredGatewayId((String)id, null) != null);
            if (gatewayDescendant) {
                String msg = "Cannot delete one or more requested assets as they are descendants of a gateway asset";
                LOG.info(msg);
                throw new IllegalStateException(msg);
            }
            List<String> gatewayIds = ids.stream().filter(id -> this.gatewayService.isLocallyRegisteredGateway((String)id)).toList();
            if (!gatewayIds.isEmpty()) {
                ids.removeAll(gatewayIds);
                for (String gatewayId : gatewayIds) {
                    try {
                        boolean deleted = this.gatewayService.deleteGateway(gatewayId);
                        if (deleted) continue;
                        return false;
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, "Failed to delete gateway asset: " + gatewayId, e);
                        return false;
                    }
                }
            }
        }
        if (!ids.isEmpty()) {
            try {
                ids.forEach(arg_0 -> ((LockByKey)this.assetLocks).lock(arg_0));
                this.persistenceService.doTransaction(em -> {
                    List<Asset> assets = em.createQuery("select a from Asset a where not exists(select child.id from Asset child where child.parentId = a.id and not child.id in :ids) and a.id in :ids", Asset.class).setParameter("ids", (Object)ids).getResultList().stream().map(asset -> asset).collect(Collectors.toList());
                    if (ids.size() != assets.size()) {
                        throw new IllegalArgumentException("Cannot delete one or more requested assets as they either have children or don't exist");
                    }
                    assets.sort(Comparator.comparingInt(asset -> asset.getPath() == null ? 0 : asset.getPath().length).reversed());
                    assets.forEach(arg_0 -> ((EntityManager)em).remove(arg_0));
                    em.flush();
                });
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to delete one or more requested assets: " + Arrays.toString(assetIds.toArray()), e);
                boolean bl = false;
                return bl;
            }
            finally {
                ids.forEach(arg_0 -> ((LockByKey)this.assetLocks).unlock(arg_0));
            }
        }
        return true;
    }

    public boolean isUserAsset(String assetId) {
        return this.isUserAsset((String)null, assetId);
    }

    public boolean isUserAsset(String userId, String assetId) {
        if (TextUtil.isNullOrEmpty((String)userId) || TextUtil.isNullOrEmpty((String)assetId)) {
            return false;
        }
        return (Boolean)this.persistenceService.doReturningTransaction(entityManager -> {
            try {
                String queryStr = TextUtil.isNullOrEmpty((String)userId) ? "select count(ual) from UserAssetLink ual where ual.id.assetId = :assetId" : "select count(ual) from UserAssetLink ual where ual.id.userId = :userId and ual.id.assetId = :assetId";
                TypedQuery query = entityManager.createQuery(queryStr, Long.class).setParameter("assetId", (Object)assetId);
                if (!TextUtil.isNullOrEmpty((String)userId)) {
                    query.setParameter("userId", (Object)userId);
                }
                return (Long)query.getSingleResult() > 0L;
            }
            catch (NoResultException ex) {
                return false;
            }
        });
    }

    public boolean isUserAsset(List<String> userIds, String assetId) {
        if (userIds == null || userIds.isEmpty() || TextUtil.isNullOrEmpty((String)assetId)) {
            return false;
        }
        return (Boolean)this.persistenceService.doReturningTransaction(entityManager -> {
            try {
                return (Long)entityManager.createQuery("select count(ual) from UserAssetLink ual where ual.id.userId in :userIds and ual.id.assetId = :assetId", Long.class).setParameter("userIds", (Object)userIds).setParameter("assetId", (Object)assetId).getSingleResult() > 0L;
            }
            catch (NoResultException ex) {
                return false;
            }
        });
    }

    public boolean isUserAssets(String userId, List<String> assetIds) {
        if (TextUtil.isNullOrEmpty((String)userId) || assetIds == null || assetIds.isEmpty()) {
            return false;
        }
        return (Boolean)this.persistenceService.doReturningTransaction(entityManager -> {
            try {
                return (Long)entityManager.createQuery("select count(ual) from UserAssetLink ual where ual.id.userId = :userId and ual.id.assetId in :assetIds", Long.class).setParameter("userId", (Object)userId).setParameter("assetIds", (Object)assetIds).getSingleResult() == (long)assetIds.size();
            }
            catch (NoResultException ex) {
                return false;
            }
        });
    }

    public boolean isRealmAsset(String realm, String assetId) {
        return this.isRealmAssets(realm, Collections.singletonList(assetId));
    }

    public boolean isRealmAssets(String realm, List<String> assetIds) {
        if (TextUtil.isNullOrEmpty((String)realm) || assetIds == null || assetIds.isEmpty()) {
            return false;
        }
        return (Boolean)this.persistenceService.doReturningTransaction(entityManager -> {
            try {
                return (Long)entityManager.createQuery("select count(a) from Asset a where a.realm = :realm and a.id in :assetIds", Long.class).setParameter("realm", (Object)realm).setParameter("assetIds", (Object)assetIds).getSingleResult() == (long)assetIds.size();
            }
            catch (NoResultException ex) {
                return false;
            }
        });
    }

    public boolean isDescendantAsset(String parentAssetId, String assetId) {
        return this.isDescendantAssets(parentAssetId, Collections.singletonList(assetId));
    }

    public boolean isDescendantAssets(final String parentAssetId, final List<String> assetIds) {
        return (Boolean)this.persistenceService.doReturningTransaction(entityManager -> (Boolean)((Session)entityManager.unwrap(Session.class)).doReturningWork((ReturningWork)new AbstractReturningWork<Boolean>(this){

            public Boolean execute(Connection connection) throws SQLException {
                Boolean bl;
                block8: {
                    PreparedStatement st = connection.prepareStatement("select count(*) from Asset a where a.path ~ lquery(?) AND a.id = ANY(?)");
                    try {
                        st.setString(1, "*." + parentAssetId + ".*");
                        st.setArray(2, st.getConnection().createArrayOf("text", assetIds.toArray()));
                        ResultSet rs = st.executeQuery();
                        bl = rs.next() && rs.getInt(1) == assetIds.size();
                        if (st == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (st != null) {
                                try {
                                    st.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (SQLException ex) {
                            LOG.log(Level.SEVERE, "Failed to execute isDescendantAssets query", ex);
                            return false;
                        }
                    }
                    st.close();
                }
                return bl;
            }
        }));
    }

    public List<UserAssetLink> findUserAssetLinks(String realm, String userId, String assetId) {
        return this.findUserAssetLinks(realm, userId != null ? Collections.singletonList(userId) : null, assetId != null ? Collections.singletonList(assetId) : null);
    }

    public List<UserAssetLink> findUserAssetLinks(String realm, Collection<String> userIds, Collection<String> assetIds) {
        if (realm == null && (userIds == null || userIds.isEmpty()) && (assetIds == null || assetIds.isEmpty())) {
            return Collections.emptyList();
        }
        return (List)this.persistenceService.doReturningTransaction(em -> this.buildFindUserAssetLinksQuery((EntityManager)em, realm, userIds, assetIds).getResultList());
    }

    protected TypedQuery<UserAssetLink> buildFindUserAssetLinksQuery(EntityManager em, String realm, Collection<String> userIds, Collection<String> assetIds) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        sb.append("select ua from UserAssetLink ua where 1=1");
        if (!TextUtil.isNullOrEmpty((String)realm)) {
            sb.append(" and ua.id.realm in :realm");
            parameters.put("realm", realm);
        }
        if (userIds != null && !userIds.isEmpty()) {
            sb.append(" and ua.id.userId in :userId");
            parameters.put("userId", userIds);
        }
        if (assetIds != null && !assetIds.isEmpty()) {
            sb.append(" and ua.id.assetId in :assetId");
            parameters.put("assetId", assetIds);
        }
        sb.append(" order by ua.createdOn desc");
        TypedQuery query = em.createQuery(sb.toString(), UserAssetLink.class);
        parameters.forEach((arg_0, arg_1) -> ((TypedQuery)query).setParameter(arg_0, arg_1));
        return query;
    }

    public void deleteUserAssetLinks(List<UserAssetLink> userAssetLinks) {
        if (userAssetLinks == null || userAssetLinks.isEmpty()) {
            return;
        }
        HashSet assetIds = new HashSet(userAssetLinks.size());
        HashSet userIds = new HashSet(userAssetLinks.size());
        userAssetLinks.forEach(userAssetLink -> {
            userIds.add(userAssetLink.getId().getUserId());
            assetIds.add(userAssetLink.getId().getAssetId());
        });
        ArrayList existingLinks = new ArrayList();
        this.persistenceService.doTransaction(entityManager -> {
            existingLinks.addAll(this.buildFindUserAssetLinksQuery((EntityManager)entityManager, null, (Collection<String>)userIds.stream().toList(), (Collection<String>)assetIds.stream().toList()).getResultList().stream().filter(userAssetLinks::contains).toList());
            if (existingLinks.size() != userAssetLinks.size()) {
                throw new IllegalArgumentException("Cannot delete one or more requested user asset links as they don't exist");
            }
            StringBuilder sb = new StringBuilder("DELETE FROM user_asset_link WHERE (1=0");
            IntStream.range(0, userAssetLinks.size()).forEach(i -> sb.append(" OR (asset_id=?").append(3 * i + 1).append(" AND user_id=?").append(3 * i + 2).append(" AND realm=?").append(3 * i + 3).append(")"));
            sb.append(")");
            Query query = entityManager.createNativeQuery(sb.toString());
            IntStream.range(0, userAssetLinks.size()).forEach(i -> {
                UserAssetLink userAssetLink = (UserAssetLink)userAssetLinks.get(i);
                query.setParameter(3 * i + 1, (Object)userAssetLink.getId().getAssetId());
                query.setParameter(3 * i + 2, (Object)userAssetLink.getId().getUserId());
                query.setParameter(3 * i + 3, (Object)userAssetLink.getId().getRealm());
            });
            int deleteCount = query.executeUpdate();
            if (deleteCount != userAssetLinks.size()) {
                throw new IllegalArgumentException("Cannot delete one or more requested user asset links as they don't exist");
            }
        });
        existingLinks.forEach(userAssetLink -> this.persistenceService.publishPersistenceEvent(PersistenceEvent.Cause.DELETE, null, userAssetLink, UserAssetLink.class, null, null));
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Deleted user asset links: count=" + userAssetLinks.size() + ", links=" + userAssetLinks.stream().map(Object::toString).collect(Collectors.joining(", ")));
        }
    }

    public void deleteUserAssetLinks(String userId) {
        this.persistenceService.doTransaction(entityManager -> {
            Query query = entityManager.createQuery("DELETE FROM UserAssetLink ual WHERE ual.id.userId = ?1");
            query.setParameter(1, (Object)userId);
            int deleteCount = query.executeUpdate();
            LOG.fine("Deleted all user asset links for user: user ID=" + userId + ", count=" + deleteCount);
        });
    }

    public void storeUserAssetLinks(List<UserAssetLink> userAssetLinks) {
        if (userAssetLinks == null || userAssetLinks.isEmpty()) {
            return;
        }
        HashSet assetIds = new HashSet(userAssetLinks.size());
        HashSet userIds = new HashSet(userAssetLinks.size());
        userAssetLinks.forEach(userAssetLink -> {
            userIds.add(userAssetLink.getId().getUserId());
            assetIds.add(userAssetLink.getId().getAssetId());
        });
        this.persistenceService.doTransaction(em -> {
            List existingLinks = this.buildFindUserAssetLinksQuery((EntityManager)em, null, (Collection<String>)userIds.stream().toList(), (Collection<String>)assetIds.stream().toList()).getResultList();
            List<UserAssetLink> newLinks = userAssetLinks.stream().filter(userAssetLink -> !existingLinks.contains(userAssetLink)).toList();
            this.createUserAssetLinks((EntityManager)em, newLinks);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R withAssetLock(String assetId, Supplier<R> action) {
        try {
            this.assetLocks.lock(assetId);
            R r = action.get();
            return r;
        }
        finally {
            this.assetLocks.unlock(assetId);
        }
    }

    protected void createUserAssetLinks(EntityManager em, List<UserAssetLink> userAssets) {
        ((Session)em.unwrap(Session.class)).doWork(connection -> {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Storing user asset links: count=" + userAssets.size() + ", links=" + userAssets.stream().map(Object::toString).collect(Collectors.joining(", ")));
            }
            try {
                PreparedStatement st = connection.prepareStatement("INSERT INTO USER_ASSET_LINK (asset_id, realm, user_id, created_on) VALUES (?, ?, ?, ?) ON CONFLICT (asset_id, realm, user_id) DO NOTHING");
                for (UserAssetLink userAssetLink2 : userAssets) {
                    st.setString(1, userAssetLink2.getId().getAssetId());
                    st.setString(2, userAssetLink2.getId().getRealm());
                    st.setObject(3, userAssetLink2.getId().getUserId());
                    st.setTimestamp(4, new Timestamp(this.timerService.getCurrentTimeMillis()));
                    st.addBatch();
                }
                st.executeBatch();
                userAssets.forEach(userAssetLink -> this.persistenceService.publishPersistenceEvent(PersistenceEvent.Cause.CREATE, userAssetLink, null, UserAssetLink.class, null, null));
            }
            catch (Exception e) {
                String msg = "Failed to create user asset links: count=" + userAssets.size();
                LOG.log(Level.WARNING, msg, e);
                throw new IllegalStateException(msg, e);
            }
        });
    }

    protected Asset<?> find(EntityManager em, String assetId, boolean loadComplete, AssetQuery.Access access) {
        if (assetId == null) {
            throw new IllegalArgumentException("Can't query null asset identifier");
        }
        return this.find(em, new AssetQuery().select(loadComplete ? null : new AssetQuery.Select().excludeAttributes()).ids(new String[]{assetId}).access(access));
    }

    protected List<Asset<?>> findAll(EntityManager em, AssetQuery query) {
        long startMillis = System.currentTimeMillis();
        if (query.access == null) {
            query.access = AssetQuery.Access.PRIVATE;
        }
        if (query.ids != null && query.ids.length == 0) {
            return Collections.emptyList();
        }
        if (query.paths != null && query.paths.length == 0) {
            return Collections.emptyList();
        }
        if (query.types != null && query.types.length == 0) {
            return Collections.emptyList();
        }
        if (query.names != null && query.names.length == 0) {
            return Collections.emptyList();
        }
        if (query.userIds != null && query.userIds.length == 0) {
            return Collections.emptyList();
        }
        if (query.parents != null && query.parents.length == 0) {
            return Collections.emptyList();
        }
        if (query.orderBy == null && query.ids == null) {
            query.orderBy = new AssetQuery.OrderBy(AssetQuery.OrderBy.Property.CREATED_ON);
        }
        Pair<PreparedAssetQuery, Boolean> queryAndContainsCalendarPredicate = AssetStorageService.buildQuery(query, () -> ((TimerService)this.timerService).getCurrentTimeMillis());
        PreparedAssetQuery querySql = (PreparedAssetQuery)queryAndContainsCalendarPredicate.key;
        boolean containsCalendarPredicate = (Boolean)queryAndContainsCalendarPredicate.value;
        if (containsCalendarPredicate && query.select != null && query.select.attributes == null) {
            LOG.warning("Asset query contains a calendar event predicate which requires the attribute values and types to be included in the select (as calendar event predicate is applied post DB query)");
            throw new IllegalArgumentException("Asset query contains a calendar event predicate which requires the attribute values and types to be included in the select (as calendar event predicate is applied post DB query)");
        }
        org.hibernate.query.Query jpql = ((org.hibernate.query.Query)em.createNativeQuery(querySql.querySql, Asset.class).unwrap(org.hibernate.query.Query.class)).setHint("org.hibernate.readOnly", (Object)true);
        querySql.apply(em, (org.hibernate.query.Query<Object[]>)jpql);
        List assets = jpql.getResultList();
        if (containsCalendarPredicate) {
            return assets.stream().filter(asset -> AssetStorageService.calendarEventPredicateMatches(() -> ((TimerService)this.timerService).getCurrentTimeMillis(), query, asset)).toList();
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Asset query took " + (System.currentTimeMillis() - startMillis) + "ms: return count=" + assets.size());
        }
        return assets;
    }

    protected boolean updateAttributeValue(EntityManager em, AttributeEvent event) throws ConstraintViolationException {
        long timestamp = event.getTimestamp() > 0L ? event.getTimestamp() : this.timerService.getCurrentTimeMillis();
        try {
            boolean success;
            PGobject valueTimestampJSON = new PGobject();
            valueTimestampJSON.setType("jsonb");
            valueTimestampJSON.setValue("{\"value\":" + ValueUtil.asJSON(event.getValue().orElse(null)).orElse("null") + ",\"timestamp\":" + timestamp + "}");
            Query query = em.createNativeQuery("UPDATE asset SET attributes[?] = attributes[?] || ?\\:\\:jsonb where id = ?").setParameter(1, (Object)event.getName()).setParameter(2, (Object)event.getName()).setParameter(3, (Object)("{\"value\":" + ValueUtil.asJSON(event.getValue().orElse(null)).orElse("null") + ",\"timestamp\":" + timestamp + "}")).setParameter(4, (Object)event.getId());
            int affectedRows = query.executeUpdate();
            boolean bl = success = affectedRows == 1;
            if (success) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Updated attribute value assetID=" + event.getId() + ", attributeName=" + event.getName() + ", timestamp=" + timestamp);
                }
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Failed to update attribute value assetID=" + event.getId() + ", attributeName=" + event.getName() + ", timestamp=" + timestamp);
            }
            if (success) {
                this.clientEventService.publishEvent(event);
            }
            return success;
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to store attribute value", e);
            return false;
        }
    }

    protected void publishModificationEvents(PersistenceEvent<Asset<?>> persistenceEvent) {
        Asset asset = (Asset)persistenceEvent.getEntity();
        switch (persistenceEvent.getCause()) {
            case CREATE: {
                Asset<?> loadedAsset = this.find(new AssetQuery().ids(new String[]{asset.getId()}));
                if (loadedAsset == null) {
                    return;
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Asset created: " + loadedAsset.toStringAll());
                } else {
                    LOG.fine("Asset created: " + String.valueOf(loadedAsset));
                }
                this.clientEventService.publishEvent(new AssetEvent(AssetEvent.Cause.CREATE, loadedAsset, null));
                asset.getAttributes().forEach(newAttribute -> this.clientEventService.publishEvent(new AttributeEvent((AssetInfo)asset, newAttribute, ((Object)((Object)this)).getClass().getSimpleName(), newAttribute.getValue().orElse(null), newAttribute.getTimestamp().orElse(0L), newAttribute.getValue().orElse(null), newAttribute.getTimestamp().orElse(0L)).setSource(((Object)((Object)this)).getClass().getSimpleName())));
                break;
            }
            case UPDATE: {
                AttributeMap newAttributes;
                boolean nonAttributeChange = persistenceEvent.getPropertyNames().size() > 1 || !persistenceEvent.hasPropertyChanged("attributes");
                boolean attributesChanged = persistenceEvent.hasPropertyChanged("attributes");
                LOG.finest(() -> "Asset updated: " + String.valueOf(persistenceEvent));
                this.clientEventService.publishEvent(new AssetEvent(AssetEvent.Cause.UPDATE, asset, (String[])persistenceEvent.getPropertyNames().toArray(String[]::new)));
                AttributeMap oldAttributes = attributesChanged ? (AttributeMap)persistenceEvent.getPreviousState("attributes") : asset.getAttributes();
                AttributeMap attributeMap = newAttributes = attributesChanged ? (AttributeMap)persistenceEvent.getCurrentState("attributes") : asset.getAttributes();
                if (attributesChanged) {
                    oldAttributes.stream().filter(oldAttribute -> newAttributes.stream().noneMatch(newAttribute -> oldAttribute.getName().equals(newAttribute.getName()))).forEach(obsoleteAttribute -> this.clientEventService.publishEvent(new AttributeEvent((AssetInfo)asset, obsoleteAttribute, ((Object)((Object)this)).getClass().getSimpleName(), null, Long.valueOf(this.timerService.getCurrentTimeMillis()), null, Long.valueOf(0L)).setSource(((Object)((Object)this)).getClass().getSimpleName()).setDeleted(true)));
                }
                Stream attributeStream = nonAttributeChange ? newAttributes.values().stream() : Attribute.getAddedOrModifiedAttributes((Collection)oldAttributes.values(), (Collection)newAttributes.values());
                attributeStream.forEach(newOrModifiedAttribute -> {
                    Optional oldAttribute = oldAttributes.get(newOrModifiedAttribute.getName());
                    this.clientEventService.publishEvent(new AttributeEvent((AssetInfo)asset, newOrModifiedAttribute, ((Object)((Object)this)).getClass().getSimpleName(), newOrModifiedAttribute.getValue().orElse(null), newOrModifiedAttribute.getTimestamp().orElse(0L), oldAttribute.flatMap(Attribute::getValue).orElse(null), oldAttribute.flatMap(Attribute::getTimestamp).orElse(0L)).setSource(((Object)((Object)this)).getClass().getSimpleName()));
                });
                break;
            }
            case DELETE: {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Asset deleted: " + asset.toStringAll());
                } else {
                    LOG.fine("Asset deleted: " + String.valueOf(asset));
                }
                this.clientEventService.publishEvent(new AssetEvent(AssetEvent.Cause.DELETE, asset, null));
                AttributeMap deletedAttributes = asset.getAttributes();
                deletedAttributes.forEach(obsoleteAttribute -> this.clientEventService.publishEvent(new AttributeEvent((AssetInfo)asset, obsoleteAttribute, ((Object)((Object)this)).getClass().getSimpleName(), null, Long.valueOf(this.timerService.getCurrentTimeMillis()), null, Long.valueOf(0L)).setSource(((Object)((Object)this)).getClass().getSimpleName()).setDeleted(true)));
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{}";
    }

    protected static Pair<PreparedAssetQuery, Boolean> buildQuery(AssetQuery query, Supplier<Long> timeProvider) {
        LOG.finest("Building: " + String.valueOf(query));
        StringBuilder sb = new StringBuilder();
        boolean recursive = query.recursive;
        ArrayList<ParameterBinder> binders = new ArrayList<ParameterBinder>();
        sb.append(AssetStorageService.buildSelectString(query, 1, binders, timeProvider));
        sb.append(AssetStorageService.buildFromString(query, 1));
        boolean containsCalendarPredicate = AssetStorageService.appendWhereClause(sb, query, 1, binders, timeProvider);
        if (recursive) {
            sb.insert(0, "WITH RECURSIVE top_level_assets AS ((");
            sb.append(") UNION (");
            sb.append(AssetStorageService.buildSelectString(query, 2, binders, timeProvider));
            sb.append(AssetStorageService.buildFromString(query, 2));
            containsCalendarPredicate = !containsCalendarPredicate && AssetStorageService.appendWhereClause(sb, query, 2, binders, timeProvider);
            sb.append("))");
            sb.append(AssetStorageService.buildSelectString(query, 3, binders, timeProvider));
            sb.append(AssetStorageService.buildFromString(query, 3));
            containsCalendarPredicate = !containsCalendarPredicate && AssetStorageService.appendWhereClause(sb, query, 3, binders, timeProvider);
        }
        sb.append(AssetStorageService.buildOrderByString(query));
        sb.append(AssetStorageService.buildLimitString(query));
        return new Pair((Object)new PreparedAssetQuery(sb.toString(), binders), (Object)containsCalendarPredicate);
    }

    protected static String buildSelectString(AssetQuery query, int level, List<ParameterBinder> binders, Supplier<Long> timeProvider) {
        StringBuilder sb = new StringBuilder();
        AssetQuery.Select select = query.select;
        sb.append("select A.ID as ID, A.NAME as NAME, A.ACCESS_PUBLIC_READ as ACCESS_PUBLIC_READ");
        sb.append(", A.CREATED_ON AS CREATED_ON, A.TYPE AS TYPE, A.PARENT_ID AS PARENT_ID");
        sb.append(", A.REALM AS REALM, A.VERSION as VERSION");
        if (!query.recursive || level == 3) {
            sb.append(", A.PATH as PATH");
        } else {
            sb.append(", NULL as PATH");
        }
        if (select == null || select.attributes == null || select.attributes.length > 0) {
            if (query.recursive && level != 3) {
                sb.append(", A.ATTRIBUTES as ATTRIBUTES");
            } else {
                sb.append(AssetStorageService.buildAttributeSelect(query, binders, timeProvider));
            }
        } else {
            sb.append(", NULL as ATTRIBUTES");
        }
        return sb.toString();
    }

    protected static String buildAttributeSelect(AssetQuery query, List<ParameterBinder> binders, Supplier<Long> timeProvider) {
        boolean hasAttributeFilter;
        AssetQuery.Select select = query.select;
        boolean bl = hasAttributeFilter = select != null && select.attributes != null && select.attributes.length > 0;
        if (!hasAttributeFilter && query.access == AssetQuery.Access.PRIVATE) {
            return ", A.ATTRIBUTES as ATTRIBUTES";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(", (");
        sb.append("select json_object_agg(AX.key, AX.value) from jsonb_each(A.attributes) as AX");
        sb.append(" where true");
        if (select != null && select.attributes != null && select.attributes.length > 0) {
            int pos = binders.size() + 1;
            sb.append(" AND AX.key = ANY(").append("?").append(pos).append(")");
            binders.add((em, st) -> st.setParameter(pos, (Object)select.attributes));
        }
        if (query.access != AssetQuery.Access.PRIVATE) {
            String metaName = query.access == AssetQuery.Access.PROTECTED ? MetaItemType.ACCESS_RESTRICTED_READ.getName() : MetaItemType.ACCESS_PUBLIC_READ.getName();
            sb.append(" AND AX.VALUE #>> '{meta,").append(metaName).append("}' = 'true'");
        }
        sb.append(") AS ATTRIBUTES");
        return sb.toString();
    }

    protected static String buildFromString(AssetQuery query, int level) {
        StringBuilder sb = new StringBuilder();
        boolean recursive = query.recursive;
        if (level == 1) {
            sb.append(" from Asset A ");
        } else if (level == 2) {
            sb.append(" from top_level_assets P ");
            sb.append("join Asset A on A.PARENT_ID = P.ID ");
        } else {
            sb.append(" from top_level_assets A ");
        }
        if (!(recursive && level != 3 || query.userIds == null)) {
            sb.append("right join USER_ASSET_LINK UA on A.ID = UA.ASSET_ID ");
        }
        return sb.toString();
    }

    protected static String buildOrderByString(AssetQuery query) {
        StringBuilder sb = new StringBuilder();
        if (query.ids != null && !query.recursive) {
            return sb.toString();
        }
        if (query.orderBy != null && query.orderBy.property != null) {
            sb.append(" order by ");
            switch (query.orderBy.property) {
                case CREATED_ON: {
                    sb.append(" A.CREATED_ON ");
                    break;
                }
                case ASSET_TYPE: {
                    sb.append(" A.TYPE ");
                    break;
                }
                case NAME: {
                    sb.append(" A.NAME ");
                    break;
                }
                case PARENT_ID: {
                    sb.append(" A.PARENT_ID ");
                    break;
                }
                case REALM: {
                    sb.append(" A.REALM ");
                }
            }
            sb.append(query.orderBy.descending ? "desc " : "asc ");
        }
        return sb.toString();
    }

    protected static String buildLimitString(AssetQuery query) {
        if (query.limit > 0) {
            return " LIMIT " + query.limit;
        }
        return "";
    }

    protected static boolean appendWhereClause(StringBuilder sb, AssetQuery query, int level, List<ParameterBinder> binders, Supplier<Long> timeProvider) {
        int pos;
        boolean isFirst;
        boolean containsCalendarPredicate = false;
        boolean recursive = query.recursive;
        sb.append(" where true");
        if (level == 2) {
            return false;
        }
        if (level == 1 && query.ids != null) {
            int pos2 = binders.size() + 1;
            sb.append(" and A.ID = ANY(?").append(pos2).append(")");
            binders.add((em, st) -> st.setParameter(pos2, (Object)query.ids));
        }
        if (level == 1 && query.names != null) {
            sb.append(" and (");
            isFirst = true;
            for (StringPredicate stringPredicate : query.names) {
                if (!isFirst) {
                    sb.append(" or ");
                }
                isFirst = false;
                pos = binders.size() + 1;
                sb.append(stringPredicate.caseSensitive ? "A.NAME " : "upper(A.NAME)");
                sb.append(StringPredicate.toSQLParameter((StringPredicate)stringPredicate, (int)pos, (boolean)false));
                binders.add((em, st) -> st.setParameter(pos, (Object)pred.prepareValue()));
            }
            sb.append(")");
        }
        if (query.parents != null) {
            sb.append(" and (");
            isFirst = true;
            for (StringPredicate stringPredicate : query.parents) {
                if (!isFirst) {
                    sb.append(" or (");
                } else {
                    sb.append("(");
                }
                isFirst = false;
                if (level == 1 && stringPredicate.id != null) {
                    pos = binders.size() + 1;
                    sb.append("A.PARENT_ID = ?").append(pos);
                    binders.add((arg_0, arg_1) -> AssetStorageService.lambda$appendWhereClause$51(pos, (ParentPredicate)stringPredicate, arg_0, arg_1));
                } else if (level == 1) {
                    sb.append("A.PARENT_ID is null");
                } else {
                    sb.append("true");
                }
                sb.append(")");
            }
            sb.append(")");
        }
        if (level == 1 && query.paths != null) {
            sb.append(" and (");
            Arrays.stream(query.paths).map(p -> String.join((CharSequence)".", p.path)).forEach(lqueryStr -> {
                int pos = binders.size() + 1;
                sb.append("A.PATH ~ lquery(?").append(pos).append(") or ");
                binders.add((em, st) -> st.setParameter(pos, (Object)("*." + lqueryStr + ".*")));
            });
            sb.append("false)");
        }
        if (!recursive || level == 3) {
            int pos2;
            if (query.realm != null && !TextUtil.isNullOrEmpty((String)query.realm.name)) {
                pos2 = binders.size() + 1;
                sb.append(" and A.REALM = ?").append(pos2);
                binders.add((em, st) -> st.setParameter(pos2, (Object)query.realm.name));
            }
            if (query.userIds != null) {
                pos2 = binders.size() + 1;
                sb.append(" and UA.USER_ID = ANY(?").append(pos2).append(")");
                binders.add((em, st) -> st.setParameter(pos2, (Object)query.userIds));
            }
            if (query.access == AssetQuery.Access.PUBLIC) {
                sb.append(" and A.ACCESS_PUBLIC_READ is true");
            }
            if (query.types != null) {
                String[] resolvedTypes = AssetQuery.getResolvedAssetTypes((String[])query.types);
                int pos3 = binders.size() + 1;
                sb.append(" and A.TYPE = ANY(?").append(pos3).append(")");
                binders.add((em, st) -> st.setParameter(pos3, (Object)resolvedTypes));
            }
            if (query.attributes != null) {
                sb.append(" and A.id in (select A.id from ");
                AtomicInteger offset = new AtomicInteger(sb.length());
                Consumer<String> selectInserter = str -> sb.insert(offset.getAndAdd(str.length()), (String)str);
                sb.append(" where true AND ");
                containsCalendarPredicate = AssetStorageService.addAttributePredicateGroupQuery(sb, binders, 0, selectInserter, (LogicGroup<AttributePredicate>)query.attributes, timeProvider);
                sb.append(")");
            }
        }
        return containsCalendarPredicate;
    }

    protected static boolean addAttributePredicateGroupQuery(StringBuilder sb, List<ParameterBinder> binders, int groupIndex, Consumer<String> selectInserter, LogicGroup<AttributePredicate> attributePredicateGroup, Supplier<Long> timeProvider) {
        boolean containsCalendarPredicate = false;
        LogicGroup.Operator operator = attributePredicateGroup.operator;
        if (operator == null) {
            operator = LogicGroup.Operator.AND;
        }
        sb.append("(");
        if (!attributePredicateGroup.getItems().isEmpty()) {
            Collection<Object> grouped;
            if (operator == LogicGroup.Operator.AND) {
                grouped = attributePredicateGroup.getItems().stream().collect(Collectors.groupingBy(predicate -> predicate.name != null ? predicate.name : "")).values();
            } else {
                grouped = new ArrayList<List>();
                grouped.add(attributePredicateGroup.getItems());
            }
            boolean isFirst = true;
            for (List list : grouped) {
                if (!isFirst) {
                    sb.append(operator == LogicGroup.Operator.OR ? " or " : " and ");
                }
                isFirst = false;
                selectInserter.accept((groupIndex > 0 ? ", " : "") + "jsonb_each(A.attributes) as AX" + groupIndex);
                containsCalendarPredicate = !containsCalendarPredicate && AssetStorageService.addNameValuePredicates(list, sb, binders, "AX" + groupIndex, selectInserter, operator == LogicGroup.Operator.OR, timeProvider);
                ++groupIndex;
            }
        }
        if (attributePredicateGroup.groups != null && attributePredicateGroup.groups.size() > 0) {
            for (LogicGroup group : attributePredicateGroup.groups) {
                sb.append(operator == LogicGroup.Operator.OR ? " or " : " and ");
                boolean containsCalPred = AssetStorageService.addAttributePredicateGroupQuery(sb, binders, groupIndex, selectInserter, (LogicGroup<AttributePredicate>)group, timeProvider);
                if (containsCalendarPredicate || !containsCalPred) continue;
                containsCalendarPredicate = true;
            }
        }
        sb.append(")");
        return containsCalendarPredicate;
    }

    protected static boolean addNameValuePredicates(List<? extends NameValuePredicate> nameValuePredicates, StringBuilder sb, List<ParameterBinder> binders, String jsonObjName, Consumer<String> selectInserter, boolean useOr, Supplier<Long> timeProvider) {
        boolean containsCalendarPredicate = false;
        boolean isFirst = true;
        int metaIndex = 0;
        for (NameValuePredicate nameValuePredicate : nameValuePredicates) {
            if (!containsCalendarPredicate && nameValuePredicate.value instanceof CalendarEventPredicate) {
                containsCalendarPredicate = true;
            }
            if (!isFirst) {
                sb.append(useOr ? " or " : " and ");
            }
            isFirst = false;
            sb.append("(");
            sb.append(AssetStorageService.buildNameValuePredicateFilter(nameValuePredicate, jsonObjName, binders, timeProvider));
            if (nameValuePredicate instanceof AttributePredicate) {
                AttributePredicate attributePredicate = (AttributePredicate)nameValuePredicate;
                if (attributePredicate.meta != null && attributePredicate.meta.length > 0) {
                    String metaJsonObjName = jsonObjName + "_AM" + metaIndex++;
                    selectInserter.accept(" LEFT JOIN jsonb_each(jsonb_strip_nulls(" + jsonObjName + ".VALUE) #> '{meta}') as " + metaJsonObjName + " ON true");
                    sb.append(" and (");
                    AssetStorageService.addNameValuePredicates(Arrays.asList((NameValuePredicate[])attributePredicate.meta.clone()), sb, binders, metaJsonObjName, selectInserter, true, timeProvider);
                    sb.append(")");
                }
            }
            sb.append(")");
        }
        return containsCalendarPredicate;
    }

    protected static String buildNameValuePredicateFilter(NameValuePredicate nameValuePredicate, String jsonObjName, List<ParameterBinder> binders, Supplier<Long> timeProvider) {
        if (nameValuePredicate.name == null && nameValuePredicate.value == null) {
            return "TRUE";
        }
        StringBuilder attributeBuilder = new StringBuilder();
        if (nameValuePredicate.negated && (nameValuePredicate.value == null || nameValuePredicate.name == null)) {
            attributeBuilder.append("NOT (");
        }
        if (nameValuePredicate.name != null) {
            attributeBuilder.append(nameValuePredicate.name.caseSensitive ? jsonObjName + ".key" : "upper(" + jsonObjName + ".key)");
            int pos = binders.size() + 1;
            attributeBuilder.append(StringPredicate.toSQLParameter((StringPredicate)nameValuePredicate.name, (int)pos, (boolean)false));
            binders.add((em, st) -> st.setParameter(pos, (Object)nameValuePredicate.name.prepareValue()));
        }
        if (nameValuePredicate.value != null) {
            BiConsumer<StringBuilder, List> valuePathInserter;
            String operator;
            if (nameValuePredicate.name != null) {
                attributeBuilder.append(" and ");
                if (nameValuePredicate.negated) {
                    attributeBuilder.append(" NOT(");
                }
            }
            boolean isAttributePredicate = nameValuePredicate instanceof AttributePredicate;
            boolean isTextCompare = nameValuePredicate.value instanceof ValueEmptyPredicate || nameValuePredicate.value instanceof StringPredicate;
            String string = operator = isTextCompare ? "#>>" : "#>";
            if (nameValuePredicate.path == null || nameValuePredicate.path.getPaths().length == 0) {
                valuePathInserter = (sb, b) -> {
                    if (isAttributePredicate) {
                        sb.append("(").append(jsonObjName).append(".VALUE ").append(operator).append(" '{value}')");
                    } else {
                        sb.append(jsonObjName).append(".VALUE");
                        if (isTextCompare) {
                            sb.append(" #>> '{}'");
                        }
                    }
                };
            } else {
                ArrayList<String> paths = new ArrayList<String>();
                if (isAttributePredicate) {
                    paths.add("value");
                }
                paths.addAll(Arrays.stream(nameValuePredicate.path.getPaths()).map(Object::toString).toList());
                valuePathInserter = (sb, b) -> {
                    int pos = binders.size() + 1;
                    sb.append("(").append(jsonObjName).append(".VALUE ").append(operator).append(" ?").append(pos).append(")");
                    binders.add((em, st) -> st.setParameter(pos, (Object)paths.toArray(new String[0])));
                };
            }
            ValuePredicate valuePredicate = nameValuePredicate.value;
            if (valuePredicate instanceof StringPredicate) {
                StringPredicate stringPredicate = (StringPredicate)valuePredicate;
                if (!stringPredicate.caseSensitive) {
                    attributeBuilder.append("upper(");
                }
                valuePathInserter.accept(attributeBuilder, binders);
                if (!stringPredicate.caseSensitive) {
                    attributeBuilder.append(")");
                }
                int pos = binders.size() + 1;
                attributeBuilder.append(StringPredicate.toSQLParameter((StringPredicate)stringPredicate, (int)pos, (boolean)false));
                binders.add((em, st) -> st.setParameter(pos, (Object)stringPredicate.prepareValue()));
            } else {
                ValuePredicate pos = nameValuePredicate.value;
                if (pos instanceof BooleanPredicate) {
                    BooleanPredicate booleanPredicate = (BooleanPredicate)pos;
                    valuePathInserter.accept(attributeBuilder, binders);
                    attributeBuilder.append(" = to_jsonb(").append(booleanPredicate.value).append(")");
                } else {
                    pos = nameValuePredicate.value;
                    if (pos instanceof DateTimePredicate) {
                        DateTimePredicate dateTimePredicate = (DateTimePredicate)pos;
                        attributeBuilder.append("(");
                        valuePathInserter.accept(attributeBuilder, binders);
                        attributeBuilder.append(" #>> '{}')\\:\\:timestamp");
                        fromAndTo = dateTimePredicate.asFromAndTo(timeProvider.get().longValue());
                        int pos2 = binders.size() + 1;
                        binders.add((arg_0, arg_1) -> AssetStorageService.lambda$buildNameValuePredicateFilter$65(pos2, (Pair)fromAndTo, arg_0, arg_1));
                        attributeBuilder.append(AssetStorageService.buildOperatorFilter(dateTimePredicate.operator, dateTimePredicate.negate, pos2));
                        if (dateTimePredicate.operator == AssetQuery.Operator.BETWEEN) {
                            int pos22 = binders.size() + 1;
                            binders.add((arg_0, arg_1) -> AssetStorageService.lambda$buildNameValuePredicateFilter$66(pos22, (Pair)fromAndTo, arg_0, arg_1));
                        }
                    } else {
                        fromAndTo = nameValuePredicate.value;
                        if (fromAndTo instanceof NumberPredicate) {
                            NumberPredicate numberPredicate = (NumberPredicate)fromAndTo;
                            attributeBuilder.append("(");
                            valuePathInserter.accept(attributeBuilder, binders);
                            attributeBuilder.append(" #>> '{}')\\:\\:numeric");
                            int pos3 = binders.size() + 1;
                            attributeBuilder.append(AssetStorageService.buildOperatorFilter(numberPredicate.operator, numberPredicate.negate, pos3));
                            binders.add((em, st) -> st.setParameter(pos3, (Object)numberPredicate.value));
                            if (numberPredicate.operator == AssetQuery.Operator.BETWEEN) {
                                int pos2 = binders.size() + 1;
                                binders.add((em, st) -> st.setParameter(pos2, (Object)numberPredicate.rangeValue));
                            }
                        } else {
                            pos = nameValuePredicate.value;
                            if (pos instanceof ArrayPredicate) {
                                ArrayPredicate arrayPredicate = (ArrayPredicate)pos;
                                if (arrayPredicate.negated) {
                                    attributeBuilder.append("NOT(");
                                }
                                if (arrayPredicate.value != null) {
                                    valuePathInserter.accept(attributeBuilder, binders);
                                    if (arrayPredicate.index != null) {
                                        attributeBuilder.append(" -> ").append(arrayPredicate.index);
                                    }
                                    int pos4 = binders.size() + 1;
                                    attributeBuilder.append(" @> ?").append(pos4).append(" \\:\\:jsonb");
                                    binders.add((em, st) -> st.setParameter(pos4, (Object)ValueUtil.asJSON((Object)arrayPredicate.value).orElse("null")));
                                } else {
                                    attributeBuilder.append("true");
                                }
                                if (arrayPredicate.lengthEquals != null) {
                                    attributeBuilder.append(" and jsonb_array_length(");
                                    valuePathInserter.accept(attributeBuilder, binders);
                                    attributeBuilder.append(") = ").append(arrayPredicate.lengthEquals);
                                }
                                if (arrayPredicate.lengthGreaterThan != null) {
                                    attributeBuilder.append(" and jsonb_array_length(");
                                    valuePathInserter.accept(attributeBuilder, binders);
                                    attributeBuilder.append(") > ").append(arrayPredicate.lengthGreaterThan);
                                }
                                if (arrayPredicate.lengthLessThan != null) {
                                    attributeBuilder.append(" and jsonb_array_length(");
                                    valuePathInserter.accept(attributeBuilder, binders);
                                    attributeBuilder.append(") < ").append(arrayPredicate.lengthLessThan);
                                }
                                if (arrayPredicate.negated) {
                                    attributeBuilder.append(")");
                                }
                            } else if (nameValuePredicate.value instanceof GeofencePredicate) {
                                ValuePredicate valuePredicate2 = nameValuePredicate.value;
                                if (valuePredicate2 instanceof RadialGeofencePredicate) {
                                    RadialGeofencePredicate location = (RadialGeofencePredicate)valuePredicate2;
                                    attributeBuilder.append("ST_DistanceSphere(ST_MakePoint((");
                                    valuePathInserter.accept(attributeBuilder, binders);
                                    attributeBuilder.append(" #>> '{coordinates,0}')\\:\\:numeric").append(", (");
                                    valuePathInserter.accept(attributeBuilder, binders);
                                    attributeBuilder.append(" #>> '{coordinates,1}')\\:\\:numeric").append("), ST_MakePoint(").append(location.lng).append(",").append(location.lat).append(location.negated ? ")) > " : ")) <= ").append(location.radius);
                                } else {
                                    valuePredicate2 = nameValuePredicate.value;
                                    if (valuePredicate2 instanceof RectangularGeofencePredicate) {
                                        RectangularGeofencePredicate location = (RectangularGeofencePredicate)valuePredicate2;
                                        if (location.negated) {
                                            attributeBuilder.append("NOT");
                                        }
                                        attributeBuilder.append(" ST_Within(ST_MakePoint((");
                                        valuePathInserter.accept(attributeBuilder, binders);
                                        attributeBuilder.append(" #>> '{coordinates,0}')\\:\\:numeric").append(", (");
                                        valuePathInserter.accept(attributeBuilder, binders);
                                        attributeBuilder.append(" #>> '{coordinates,1}')\\:\\:numeric").append(")").append(", ST_MakeEnvelope(").append(location.lngMin).append(",").append(location.latMin).append(",").append(location.lngMax).append(",").append(location.latMax).append("))");
                                    }
                                }
                            } else if (nameValuePredicate.value instanceof ValueEmptyPredicate) {
                                valuePathInserter.accept(attributeBuilder, binders);
                                attributeBuilder.append(((ValueEmptyPredicate)nameValuePredicate.value).negate ? " IS NOT NULL" : " IS NULL");
                            } else if (nameValuePredicate.value instanceof CalendarEventPredicate) {
                                int pos5 = binders.size() + 1;
                                Timestamp when = new Timestamp(((CalendarEventPredicate)nameValuePredicate.value).timestamp.getTime());
                                attributeBuilder.append("(jsonb_typeof(");
                                valuePathInserter.accept(attributeBuilder, binders);
                                attributeBuilder.append(" #> '{start}') = 'number' AND jsonb_typeof(");
                                valuePathInserter.accept(attributeBuilder, binders);
                                attributeBuilder.append(" #> '{end}') = 'number' AND to_timestamp((");
                                valuePathInserter.accept(attributeBuilder, binders);
                                attributeBuilder.append(" #>> '{start}')\\:\\:float / 1000) <= ?").append(pos5).append(" AND (to_timestamp((");
                                valuePathInserter.accept(attributeBuilder, binders);
                                attributeBuilder.append(" #>> '{end}')\\:\\:float / 1000) > ?").append(pos5 + 1).append(" OR jsonb_typeof(");
                                valuePathInserter.accept(attributeBuilder, binders);
                                attributeBuilder.append(" #> '{recurrence}') = 'string'))");
                                binders.add((em, st) -> st.setParameter(pos5, (Object)when));
                                binders.add((em, st) -> st.setParameter(pos5 + 1, (Object)when));
                            } else {
                                throw new UnsupportedOperationException("Attribute value predicate is not supported: " + String.valueOf(nameValuePredicate.value));
                            }
                        }
                    }
                }
            }
        }
        if (nameValuePredicate.negated) {
            attributeBuilder.append(")");
            if (nameValuePredicate.value == null) {
                attributeBuilder.append(" or ").append(jsonObjName).append(".key IS NULL");
            }
        }
        return attributeBuilder.toString();
    }

    protected static String buildOperatorFilter(AssetQuery.Operator operator, boolean negate, int pos) {
        switch (operator) {
            case EQUALS: {
                if (negate) {
                    return " <> ?" + pos + " ";
                }
                return " = ?" + pos + " ";
            }
            case GREATER_THAN: {
                if (negate) {
                    return " <= ?" + pos + " ";
                }
                return " > ?" + pos + " ";
            }
            case GREATER_EQUALS: {
                if (negate) {
                    return " < ?" + pos + " ";
                }
                return " >= ?" + pos + " ";
            }
            case LESS_THAN: {
                if (negate) {
                    return " >= ?" + pos + " ";
                }
                return " < ?" + pos + " ";
            }
            case LESS_EQUALS: {
                if (negate) {
                    return " > ?" + pos + " ";
                }
                return " <= ?" + pos + " ";
            }
            case BETWEEN: {
                if (negate) {
                    return " NOT BETWEEN ?" + pos + " AND ?" + (pos + 1) + " ";
                }
                return " BETWEEN ?" + pos + " AND ?" + (pos + 1) + " ";
            }
        }
        throw new IllegalArgumentException("Unsupported operator: " + String.valueOf(operator));
    }

    protected <T extends HasAssetQuery & RespondableEvent> void onReadRequest(T event) {
        AssetQuery assetQuery = event.getAssetQuery();
        AssetsEvent response = null;
        if (((RespondableEvent)event).getResponseConsumer() == null) {
            LOG.warning("Cannot respond to read request event as response consumer is not set");
            return;
        }
        if (event instanceof ReadAssetsEvent) {
            List<Asset<?>> assets = this.findAll(assetQuery);
            response = new AssetsEvent(assets);
        } else {
            Asset<?> asset = this.find(assetQuery);
            String attributeName = null;
            if (asset != null) {
                String assetId;
                if (event instanceof ReadAttributeEvent) {
                    ReadAttributeEvent readAttributeEvent = (ReadAttributeEvent)event;
                    assetId = readAttributeEvent.getAttributeRef().getId();
                    attributeName = readAttributeEvent.getAttributeRef().getName();
                } else {
                    assetId = ((ReadAssetEvent)event).getAssetId();
                }
                if (!TextUtil.isNullOrEmpty(attributeName)) {
                    Attribute assetAttribute = asset.getAttributes().get(attributeName).orElse(null);
                    if (assetAttribute != null && (assetQuery.access == null || assetQuery.access == AssetQuery.Access.PRIVATE || assetQuery.access == AssetQuery.Access.PUBLIC && assetAttribute.getMetaValue(MetaItemType.ACCESS_PUBLIC_READ).orElse(false).booleanValue() || assetQuery.access == AssetQuery.Access.PROTECTED && assetAttribute.getMetaValue(MetaItemType.ACCESS_RESTRICTED_READ).orElse(false).booleanValue())) {
                        response = new AttributeEvent(assetId, attributeName, assetAttribute.getValue().orElse(null), assetAttribute.getTimestamp().orElse(0L));
                    }
                } else {
                    response = new AssetEvent(AssetEvent.Cause.READ, asset, null);
                }
            }
        }
        if (response != null) {
            if (!TextUtil.isNullOrEmpty((String)((SharedEvent)event).getMessageID())) {
                response.setMessageID(((SharedEvent)event).getMessageID());
            }
            ((RespondableEvent)event).getResponseConsumer().accept(response);
        }
    }

    private static /* synthetic */ void lambda$buildNameValuePredicateFilter$66(int pos2, Pair fromAndTo, EntityManager em, org.hibernate.query.Query st) throws SQLException {
        st.setParameter(pos2, (Object)new Timestamp(fromAndTo.value != null ? (Long)fromAndTo.value : Long.MAX_VALUE));
    }

    private static /* synthetic */ void lambda$buildNameValuePredicateFilter$65(int pos, Pair fromAndTo, EntityManager em, org.hibernate.query.Query st) throws SQLException {
        st.setParameter(pos, (Object)new Timestamp(fromAndTo.key != null ? (Long)fromAndTo.key : 0L));
    }

    private static /* synthetic */ void lambda$appendWhereClause$51(int pos, ParentPredicate pred, EntityManager em, org.hibernate.query.Query st) throws SQLException {
        st.setParameter(pos, (Object)pred.id);
    }

    protected static class PreparedAssetQuery {
        protected final String querySql;
        protected final List<ParameterBinder> binders;

        public PreparedAssetQuery(String querySql, List<ParameterBinder> binders) {
            this.querySql = querySql;
            this.binders = binders;
        }

        protected void apply(EntityManager em, org.hibernate.query.Query<Object[]> query) {
            for (ParameterBinder binder : this.binders) {
                binder.accept(em, query);
            }
        }
    }

    public static interface ParameterBinder
    extends BiConsumer<EntityManager, org.hibernate.query.Query<Object[]>> {
        @Override
        default public void accept(EntityManager em, org.hibernate.query.Query<Object[]> st) {
            try {
                this.acceptStatement(em, st);
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void acceptStatement(EntityManager var1, org.hibernate.query.Query<Object[]> var2) throws SQLException;
    }
}

