/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.asset;

import com.fasterxml.jackson.databind.node.NullNode;
import jakarta.persistence.OptimisticLockException;
import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import org.jboss.resteasy.plugins.validation.ResteasyViolationExceptionImpl;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetProcessingException;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetResource;
import org.openremote.model.asset.UserAssetLink;
import org.openremote.model.attribute.Attribute;
import org.openremote.model.attribute.AttributeEvent;
import org.openremote.model.attribute.AttributeState;
import org.openremote.model.attribute.AttributeWriteFailure;
import org.openremote.model.attribute.AttributeWriteResult;
import org.openremote.model.attribute.MetaItem;
import org.openremote.model.attribute.MetaMap;
import org.openremote.model.http.RequestParams;
import org.openremote.model.query.AssetQuery;
import org.openremote.model.query.filter.RealmPredicate;
import org.openremote.model.security.ClientRole;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.AbstractNameValueHolder;
import org.openremote.model.value.MetaItemType;

public class AssetResourceImpl
extends ManagerWebResource
implements AssetResource {
    private static final Logger LOG = Logger.getLogger(AssetResourceImpl.class.getName());
    protected final AssetStorageService assetStorageService;
    protected final MessageBrokerService messageBrokerService;
    protected final ClientEventService clientEventService;

    public AssetResourceImpl(TimerService timerService, ManagerIdentityService identityService, AssetStorageService assetStorageService, MessageBrokerService messageBrokerService, ClientEventService clientEventService) {
        super(timerService, identityService);
        this.assetStorageService = assetStorageService;
        this.messageBrokerService = messageBrokerService;
        this.clientEventService = clientEventService;
    }

    public Asset<?>[] getCurrentUserAssets(RequestParams requestParams) {
        try {
            if (this.isSuperUser()) {
                return new Asset[0];
            }
            if (!this.isAuthenticated()) {
                throw new NotAuthorizedException((Object)"Must be authenticated", new Object[0]);
            }
            AssetQuery query = new AssetQuery().userIds(new String[]{this.getUserId()});
            if (!this.assetStorageService.authorizeAssetQuery(query, this.getAuthContext(), this.getRequestRealmName())) {
                throw new ForbiddenException("User not authorized to execute specified query");
            }
            List<Asset<?>> assets = this.assetStorageService.findAll(query);
            this.request.setAttribute("Content-Encoding", (Object)"gzip");
            return assets.toArray(new Asset[0]);
        }
        catch (IllegalStateException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
    }

    public UserAssetLink[] getUserAssetLinks(RequestParams requestParams, String realm, String userId, String assetId) {
        try {
            realm = TextUtil.isNullOrEmpty((String)realm) ? this.getAuthenticatedRealmName() : realm;
            boolean hasAdminReadRole = this.hasResourceRole(ClientRole.READ_ADMIN.getValue(), "openremote");
            if (realm == null) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (!this.isSuperUser() && !this.getAuthenticatedRealmName().equals(realm)) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (!hasAdminReadRole && userId != null && !Objects.equals(this.getUserId(), userId)) {
                throw new ForbiddenException("Can only retrieve own asset links unless you have role '" + String.valueOf(ClientRole.READ_ADMIN) + "'");
            }
            if (userId != null && !this.identityService.getIdentityProvider().isUserInRealm(userId, realm)) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            UserAssetLink[] result = this.assetStorageService.findUserAssetLinks(realm, userId, assetId).toArray(new UserAssetLink[0]);
            this.request.setAttribute("Content-Encoding", (Object)"gzip");
            return result;
        }
        catch (IllegalStateException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
    }

    public void createUserAssetLinks(RequestParams requestParams, List<UserAssetLink> userAssetLinks) {
        if (this.isRestrictedUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        String realm = userAssetLinks.get(0).getId().getRealm();
        String userId = userAssetLinks.get(0).getId().getUserId();
        String[] assetIds = new String[userAssetLinks.size()];
        IntStream.range(0, userAssetLinks.size()).forEach(i -> {
            UserAssetLink userAssetLink = (UserAssetLink)userAssetLinks.get(i);
            assetIds[i] = userAssetLink.getId().getAssetId();
            if (!userAssetLink.getId().getRealm().equals(realm) || !userAssetLink.getId().getUserId().equals(userId)) {
                throw new BadRequestException("All user asset links must be for the same user");
            }
        });
        if (!this.isSuperUser() && !realm.equals(this.getAuthenticatedRealmName())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (!this.identityService.getIdentityProvider().isUserInRealm(userId, realm)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        List<Asset<?>> assets = this.assetStorageService.findAll(new AssetQuery().select(new AssetQuery.Select().excludeAttributes()).realm(new RealmPredicate(realm)).ids(assetIds));
        if (assets.size() != userAssetLinks.size()) {
            throw new BadRequestException("One or more asset IDs are invalid");
        }
        try {
            this.assetStorageService.storeUserAssetLinks(userAssetLinks);
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    public void deleteUserAssetLink(RequestParams requestParams, String realm, String userId, String assetId) {
        this.deleteUserAssetLinks(requestParams, Collections.singletonList(new UserAssetLink(realm, userId, assetId)));
    }

    public void deleteAllUserAssetLinks(RequestParams requestParams, String realm, String userId) {
        if (this.isRestrictedUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (!this.isSuperUser() && !this.getAuthenticatedRealm().getName().equals(realm)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        if (!this.identityService.getIdentityProvider().isUserInRealm(userId, realm)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        this.assetStorageService.deleteUserAssetLinks(userId);
    }

    public void deleteUserAssetLinks(RequestParams requestParams, List<UserAssetLink> userAssetLinks) {
        if (this.isRestrictedUser()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        String realm = userAssetLinks.get(0).getId().getRealm();
        String userId = userAssetLinks.get(0).getId().getUserId();
        if (userAssetLinks.stream().anyMatch(userAssetLink -> !userAssetLink.getId().getRealm().equals(realm) || !userAssetLink.getId().getUserId().equals(userId))) {
            throw new BadRequestException("All user asset links must be for the same user");
        }
        if (!this.isSuperUser() && !this.getAuthenticatedRealm().getName().equals(realm)) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        try {
            this.assetStorageService.deleteUserAssetLinks(userAssetLinks);
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Failed to delete user asset links", e);
            throw new BadRequestException();
        }
    }

    public Asset<?> getPartial(RequestParams requestParams, String assetId) {
        return this.get(requestParams, assetId, false);
    }

    public Asset<?> get(RequestParams requestParams, String assetId) {
        return this.get(requestParams, assetId, true);
    }

    public Asset<?> get(RequestParams requestParams, String assetId, boolean loadComplete) {
        try {
            Asset<?> asset;
            if (this.isRestrictedUser()) {
                if (!this.assetStorageService.isUserAsset(this.getUserId(), assetId)) {
                    LOG.fine("Forbidden access for restricted user: username=" + this.getUsername() + ", assetID=" + assetId);
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                asset = this.assetStorageService.find(assetId, loadComplete, AssetQuery.Access.PROTECTED);
            } else {
                asset = this.assetStorageService.find(assetId, loadComplete);
            }
            if (asset == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!this.isRealmActiveAndAccessible(asset.getRealm())) {
                LOG.fine("Forbidden access (realm '" + asset.getRealm() + "' nonexistent, inactive or inaccessible) for user: " + this.getUsername());
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            this.request.setAttribute("Content-Encoding", (Object)"gzip");
            return asset;
        }
        catch (IllegalStateException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
    }

    public Asset<?> update(RequestParams requestParams, String assetId, Asset<?> asset) {
        LOG.fine("Updating asset: assetID=" + assetId);
        try {
            Asset<?> storageAsset = this.assetStorageService.find(assetId, true);
            if (storageAsset == null) {
                LOG.fine("Asset not found: assetID=" + assetId);
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!this.isRealmActiveAndAccessible(storageAsset.getRealm())) {
                LOG.fine("Realm '" + storageAsset.getRealm() + "' is nonexistent, inactive or inaccessible: username=" + this.getUsername() + ", assetID=" + assetId);
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (!storageAsset.getRealm().equals(asset.getRealm())) {
                LOG.fine("Cannot change asset's realm: existingRealm=" + storageAsset.getRealm() + ", requestedRealm=" + asset.getRealm());
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (!storageAsset.getType().equals(asset.getType())) {
                LOG.fine("Cannot change asset's type: existingType=" + storageAsset.getType() + ", requestedType=" + asset.getType());
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            boolean isRestrictedUser = this.isRestrictedUser();
            storageAsset.setVersion(asset.getVersion());
            if (!isRestrictedUser) {
                storageAsset.setName(asset.getName());
                storageAsset.setParentId(asset.getParentId());
                storageAsset.setAccessPublicRead(asset.isAccessPublicRead());
                storageAsset.setAttributes(asset.getAttributes());
            }
            if (isRestrictedUser) {
                if (!this.assetStorageService.isUserAsset(this.getUserId(), assetId)) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                for (Attribute updatedAttribute : asset.getAttributes().values()) {
                    String updatedAttributeName = updatedAttribute.getName();
                    Optional serverAttribute = storageAsset.getAttribute(updatedAttributeName);
                    if (serverAttribute.isPresent()) {
                        Attribute existingAttribute2 = (Attribute)serverAttribute.get();
                        if (!existingAttribute2.getMetaValue(MetaItemType.ACCESS_RESTRICTED_WRITE).orElse(false).booleanValue()) {
                            LOG.fine("Existing attribute not writable by restricted client, ignoring update of: " + updatedAttributeName);
                            continue;
                        }
                        MetaMap updatedMetaItems = updatedAttribute.getMeta();
                        updatedMetaItems.removeIf(mi -> {
                            if (mi.getName().equals(MetaItemType.ACCESS_RESTRICTED_READ.getName())) {
                                return true;
                            }
                            if (mi.getName().equals(MetaItemType.ACCESS_RESTRICTED_WRITE.getName())) {
                                return true;
                            }
                            if (mi.getName().equals(MetaItemType.ACCESS_PUBLIC_READ.getName())) {
                                return true;
                            }
                            return mi.getName().equals(MetaItemType.ACCESS_PUBLIC_WRITE.getName());
                        });
                        MetaMap existingMetaItems = (MetaMap)ValueUtil.clone((Object)existingAttribute2.getMeta());
                        existingMetaItems.addOrReplace((Map)updatedMetaItems);
                        updatedAttribute.setMeta(existingMetaItems);
                        storageAsset.getAttributes().addOrReplace((AbstractNameValueHolder)updatedAttribute);
                        continue;
                    }
                    updatedAttribute.addOrReplaceMeta(new MetaItem[]{new MetaItem(MetaItemType.ACCESS_RESTRICTED_READ, (Object)true)});
                    updatedAttribute.addOrReplaceMeta(new MetaItem[]{new MetaItem(MetaItemType.ACCESS_RESTRICTED_WRITE, (Object)true)});
                    storageAsset.getAttributes().addOrReplace((AbstractNameValueHolder)updatedAttribute);
                }
                storageAsset.getAttributes().removeIf(existingAttribute -> !asset.hasAttribute(existingAttribute.getName()) && existingAttribute.getMetaValue(MetaItemType.ACCESS_RESTRICTED_WRITE).orElse(false) != false);
            }
            return this.assetStorageService.merge(storageAsset, isRestrictedUser ? this.getUsername() : null);
        }
        catch (IllegalStateException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.FORBIDDEN);
        }
        catch (ConstraintViolationException ex) {
            throw new ResteasyViolationExceptionImpl(ex.getConstraintViolations(), requestParams.headers.getAcceptableMediaTypes());
        }
        catch (OptimisticLockException opEx) {
            throw new WebApplicationException("Refresh the asset from the server and try to update the changes again", (Throwable)opEx, Response.Status.CONFLICT);
        }
    }

    public Response writeAttributeValue(RequestParams requestParams, String assetId, String attributeName, Object value) {
        return this.writeAttributeValue(requestParams, assetId, attributeName, null, value);
    }

    public Response writeAttributeValue(RequestParams requestParams, String assetId, String attributeName, Long timestamp, Object value) {
        Response.Status status = Response.Status.OK;
        if (value instanceof NullNode) {
            value = null;
        }
        AttributeEvent event = new AttributeEvent(assetId, attributeName, value, timestamp);
        if (!this.clientEventService.authorizeEventWrite(this.getRequestRealmName(), this.getAuthContext(), event)) {
            throw new ForbiddenException("Cannot write specified attribute: " + String.valueOf(event));
        }
        AttributeWriteResult result = this.doAttributeWrite(event);
        if (result.getFailure() != null) {
            status = switch (result.getFailure()) {
                case AttributeWriteFailure.ASSET_NOT_FOUND, AttributeWriteFailure.ATTRIBUTE_NOT_FOUND -> Response.Status.NOT_FOUND;
                case AttributeWriteFailure.INVALID_VALUE -> Response.Status.NOT_ACCEPTABLE;
                case AttributeWriteFailure.QUEUE_FULL -> Response.Status.TOO_MANY_REQUESTS;
                default -> Response.Status.BAD_REQUEST;
            };
        }
        return Response.status((Response.Status)status).entity((Object)result).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    public AttributeWriteResult[] writeAttributeValues(RequestParams requestParams, AttributeState[] attributeStates) {
        return this.writeAttributeEvents(requestParams, (AttributeEvent[])Arrays.stream(attributeStates).map(AttributeEvent::new).toArray(AttributeEvent[]::new));
    }

    public AttributeWriteResult[] writeAttributeEvents(RequestParams requestParams, AttributeEvent[] attributeEvents) {
        return (AttributeWriteResult[])Arrays.stream(attributeEvents).map(event -> {
            if (!this.clientEventService.authorizeEventWrite(this.getRequestRealmName(), this.getAuthContext(), event)) {
                return new AttributeWriteResult(event.getRef(), AttributeWriteFailure.INSUFFICIENT_ACCESS);
            }
            return this.doAttributeWrite((AttributeEvent)event);
        }).toArray(AttributeWriteResult[]::new);
    }

    public Asset<?> create(RequestParams requestParams, Asset<?> asset) {
        try {
            if (this.isRestrictedUser()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (asset == null) {
                LOG.finest("No asset in request");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (asset.getRealm() == null || asset.getRealm().isEmpty()) {
                asset.setRealm(this.getAuthenticatedRealm().getName());
            } else if (!this.isRealmActiveAndAccessible(asset.getRealm())) {
                LOG.fine("Forbidden access for user '" + this.getUsername() + "', can't create: " + String.valueOf(asset));
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            Asset newAsset = (Asset)ValueUtil.clone(asset);
            if (asset.getId() != null) {
                newAsset.setId(asset.getId());
            }
            return this.assetStorageService.merge(newAsset);
        }
        catch (ConstraintViolationException ex) {
            throw new ResteasyViolationExceptionImpl(ex.getConstraintViolations(), requestParams.headers.getAcceptableMediaTypes());
        }
        catch (IllegalStateException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
    }

    public void delete(RequestParams requestParams, List<String> assetIds) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Deleting assets: " + String.valueOf(assetIds));
        }
        try {
            if (assetIds == null || assetIds.isEmpty()) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (this.isRestrictedUser()) {
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            List<Asset<?>> assets = this.assetStorageService.findAll(new AssetQuery().ids(assetIds.toArray(new String[0])).select(new AssetQuery.Select().excludeAttributes()));
            if (assets == null || assets.size() != assetIds.size()) {
                LOG.fine("Request to delete one or more invalid assets");
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            if (assets.stream().map(Asset::getRealm).distinct().anyMatch(asset -> !this.isRealmActiveAndAccessible((String)asset))) {
                LOG.fine("One or more assets in an nonexistent, inactive or inaccessible realm: username=" + this.getUsername());
                throw new WebApplicationException(Response.Status.FORBIDDEN);
            }
            if (!this.assetStorageService.delete(assetIds, false)) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
        catch (IllegalStateException ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.BAD_REQUEST);
        }
    }

    public Asset<?>[] queryAssets(RequestParams requestParams, AssetQuery query) {
        if (query == null) {
            query = new AssetQuery();
        }
        if (!this.assetStorageService.authorizeAssetQuery(query, this.getAuthContext(), this.getRequestRealmName())) {
            throw new ForbiddenException("User not authorized to execute specified query");
        }
        List<Asset<?>> result = this.assetStorageService.findAll(query);
        this.request.setAttribute("Content-Encoding", (Object)"gzip");
        return result.toArray(new Asset[0]);
    }

    protected AttributeWriteResult doAttributeWrite(AttributeEvent event) {
        AttributeWriteFailure failure = null;
        if (event.getTimestamp() <= 0L) {
            event.setTimestamp(this.timerService.getCurrentTimeMillis());
        }
        try {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Write attribute value request: " + String.valueOf(event));
            }
            event.setSource(AssetResource.class.getSimpleName());
            Object result = this.messageBrokerService.getFluentProducerTemplate().withBody((Object)event).to("direct://AttributeEventProcessor").request();
            if (result instanceof AssetProcessingException) {
                AssetProcessingException processingException = (AssetProcessingException)result;
                failure = processingException.getReason();
            }
        }
        catch (AssetProcessingException e) {
            failure = e.getReason();
        }
        catch (IllegalStateException ex) {
            failure = AttributeWriteFailure.UNKNOWN;
        }
        return new AttributeWriteResult(event.getRef(), failure);
    }

    public void updateParent(RequestParams requestParams, String parentId, List<String> assetIds) {
        AssetQuery query = new AssetQuery();
        query.ids = (String[])assetIds.toArray(String[]::new);
        List<Asset<?>> assets = this.assetStorageService.findAll(query);
        LOG.fine("Updating parent for assets: count=" + assets.size() + ", newParentID=" + parentId);
        for (Asset<?> asset : assets) {
            asset.setParentId(parentId);
            LOG.fine("Updating asset parent: assetID=" + asset.getId() + ", newParentID=" + parentId);
            this.assetStorageService.merge(asset);
        }
    }

    public void updateNoneParent(RequestParams requestParams, List<String> assetIds) {
        AssetQuery query = new AssetQuery();
        query.ids = (String[])assetIds.toArray(String[]::new);
        List<Asset<?>> assets = this.assetStorageService.findAll(query);
        LOG.fine("Updating parent for assets: count=" + assets.size() + ", newParentID=NONE");
        for (Asset<?> asset : assets) {
            asset.setParentId(null);
            LOG.fine("Updating asset parent: assetID=" + asset.getId() + ", newParentID=NONE");
            this.assetStorageService.merge(asset);
        }
    }
}

