/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.asset;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.openremote.container.message.MessageBrokerService;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.asset.AssetModelResourceImpl;
import org.openremote.manager.event.ClientEventService;
import org.openremote.manager.gateway.GatewayService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.AssetModelProvider;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.asset.AssetDescriptor;
import org.openremote.model.asset.AssetTypeInfo;
import org.openremote.model.syslog.SyslogCategory;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;
import org.openremote.model.value.AttributeDescriptor;
import org.openremote.model.value.MetaItemDescriptor;
import org.openremote.model.value.ValueDescriptor;

public class AssetModelService
extends RouteBuilder
implements ContainerService,
AssetModelProvider {
    protected static ObjectMapper JSON = ValueUtil.JSON.copy().addMixIn(AssetTypeInfo.class, AssetTypeInfoMixin.class);
    protected static Logger LOG = SyslogCategory.getLogger((SyslogCategory)SyslogCategory.MODEL_AND_VALUES, AssetModelService.class);
    public static final String DIRECTORY_NAME = "asset_model";
    protected ManagerIdentityService identityService;
    protected ClientEventService clientEventService;
    protected GatewayService gatewayService;
    protected PersistenceService persistenceService;
    protected Map<String, AssetTypeInfo> dynamicAssetTypeInfos;
    protected Path storageDir;

    public int getPriority() {
        return -2147483538;
    }

    public void configure() throws Exception {
    }

    public void init(Container container) throws Exception {
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.clientEventService = (ClientEventService)container.getService(ClientEventService.class);
        this.gatewayService = (GatewayService)container.getService(GatewayService.class);
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new AssetModelResourceImpl((TimerService)container.getService(TimerService.class), this.identityService, this));
        ((MessageBrokerService)container.getService(MessageBrokerService.class)).getContext().addRoutes((RoutesBuilder)this);
    }

    protected void initDynamicModel() {
        try {
            Path rootStorageDir = this.persistenceService.getStorageDir();
            this.storageDir = rootStorageDir.resolve(DIRECTORY_NAME);
            if (!Files.exists(this.storageDir, new LinkOption[0])) {
                try {
                    Files.createDirectories(this.storageDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Failed to create asset model storage directory", e);
                    throw new RuntimeException(e);
                }
            } else if (!Files.isDirectory(this.storageDir, new LinkOption[0])) {
                throw new IllegalStateException("Asset model storage directory is not a directory: " + String.valueOf(this.storageDir));
            }
            this.dynamicAssetTypeInfos = this.loadDescriptors(AssetTypeInfo.class, this.storageDir).collect(Collectors.toMap(ati -> ati.getAssetDescriptor().getName(), ati -> ati));
            LOG.fine("Loaded asset type infos from '" + String.valueOf(this.storageDir) + "': count = " + this.dynamicAssetTypeInfos.size());
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to load custom asset types from '" + String.valueOf(this.storageDir) + "':" + e.getMessage());
        }
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public boolean useAutoScan() {
        return false;
    }

    public AssetDescriptor<?>[] getAssetDescriptors() {
        if (this.dynamicAssetTypeInfos == null) {
            return null;
        }
        return (AssetDescriptor[])this.dynamicAssetTypeInfos.values().stream().map(AssetTypeInfo::getAssetDescriptor).toArray(AssetDescriptor[]::new);
    }

    public Map<String, Collection<AttributeDescriptor<?>>> getAttributeDescriptors() {
        if (this.dynamicAssetTypeInfos == null) {
            this.initDynamicModel();
        }
        return this.dynamicAssetTypeInfos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, es -> ((AssetTypeInfo)es.getValue()).getAttributeDescriptors().values()));
    }

    public Map<String, Collection<MetaItemDescriptor<?>>> getMetaItemDescriptors() {
        if (this.dynamicAssetTypeInfos == null) {
            this.initDynamicModel();
        }
        return this.dynamicAssetTypeInfos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, es -> Arrays.asList(((AssetTypeInfo)es.getValue()).getMetaItemDescriptors())));
    }

    public Map<String, Collection<ValueDescriptor<?>>> getValueDescriptors() {
        if (this.dynamicAssetTypeInfos == null) {
            this.initDynamicModel();
        }
        return this.dynamicAssetTypeInfos.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, es -> Arrays.asList(((AssetTypeInfo)es.getValue()).getValueDescriptors())));
    }

    public boolean isDynamic() {
        return true;
    }

    public AssetTypeInfo[] getAssetInfos(String parentId, String parentType) {
        if (!TextUtil.isNullOrEmpty((String)parentId) && this.gatewayService.getLocallyRegisteredGatewayId(parentId, null) != null) {
            return new AssetTypeInfo[0];
        }
        return ValueUtil.getAssetInfos((String)parentType);
    }

    public AssetTypeInfo getAssetInfo(String parentId, String assetType) {
        if (!TextUtil.isNullOrEmpty((String)parentId) && this.gatewayService.getLocallyRegisteredGatewayId(parentId, null) != null) {
            return null;
        }
        return ValueUtil.getAssetInfo((String)assetType).orElse(null);
    }

    public AssetDescriptor<?>[] getAssetDescriptors(String parentId, String parentType) {
        if (!TextUtil.isNullOrEmpty((String)parentId) && this.gatewayService.getLocallyRegisteredGatewayId(parentId, null) != null) {
            return new AssetDescriptor[0];
        }
        return ValueUtil.getAssetDescriptors((String)parentType);
    }

    public Map<String, ValueDescriptor<?>> getValueDescriptors(String parentId) {
        if (!TextUtil.isNullOrEmpty((String)parentId) && this.gatewayService.getLocallyRegisteredGatewayId(parentId, null) != null) {
            return null;
        }
        return ValueUtil.getValueDescriptors();
    }

    public Map<String, MetaItemDescriptor<?>> getMetaItemDescriptors(String parentId) {
        if (!TextUtil.isNullOrEmpty((String)parentId) && this.gatewayService.getLocallyRegisteredGatewayId(parentId, null) != null) {
            return null;
        }
        return ValueUtil.getMetaItemDescriptors();
    }

    protected <T> T parse(String jsonString, Class<T> type) throws JsonProcessingException {
        return (T)JSON.readValue(jsonString, JSON.constructType(type));
    }

    protected <T> Stream<T> loadDescriptors(Class<T> descriptorClazz, Path descriptorPath) {
        try {
            return Files.list(descriptorPath).map(descriptorFile -> {
                LOG.log(Level.FINE, "Reading descriptor from: " + String.valueOf(descriptorFile));
                try {
                    String descriptorStr = Files.readString(descriptorFile);
                    if (descriptorStr != null) {
                        return this.parse(descriptorStr, descriptorClazz);
                    }
                }
                catch (JsonProcessingException e) {
                    LOG.log(Level.SEVERE, "Failed to parse descriptor file '" + String.valueOf(descriptorFile) + "': " + e.getMessage());
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Failed to read descriptor file '" + String.valueOf(descriptorFile) + "': " + e.getMessage());
                }
                return null;
            }).filter(Objects::nonNull);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @JsonDeserialize(using=AssetTypeInfoDeserializer.class)
    private static final class AssetTypeInfoMixin {
        @JsonDeserialize
        @JsonSerialize
        MetaItemDescriptor<?>[] metaItemDescriptors;
        @JsonDeserialize
        @JsonSerialize
        ValueDescriptor<?>[] valueDescriptors;

        private AssetTypeInfoMixin() {
        }
    }

    private static final class AssetTypeInfoDeserializer
    extends StdDeserializer<AssetTypeInfo> {
        private static final JavaType VALUE_DESCRIPTOR_TYPE = TypeFactory.defaultInstance().constructType(ValueDescriptor[].class);
        private static final JavaType META_ITEM_DESCRIPTOR_TYPE = TypeFactory.defaultInstance().constructType(MetaItemDescriptor[].class);
        private static final JavaType ATTRIBUTE_DESCRIPTOR_TYPE = TypeFactory.defaultInstance().constructType(AttributeDescriptor[].class);
        private static final JavaType ASSET_DESCRIPTOR_TYPE = TypeFactory.defaultInstance().constructType(AssetDescriptor.class);

        private AssetTypeInfoDeserializer() {
            super(AssetTypeInfo.class);
        }

        public AssetTypeInfo deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JacksonException {
            JsonParser parser;
            if (!jp.isExpectedStartObjectToken()) {
                throw JsonMappingException.from((JsonParser)jp, (String)"Must be an object");
            }
            TokenBuffer attributeDescriptorBuffer = null;
            TokenBuffer metaItemDescriptorBuffer = null;
            AssetDescriptor assetDescriptor = null;
            AttributeDescriptor[] attributeDescriptors = null;
            AtomicReference<ValueDescriptor[]> valueDescriptors = new AtomicReference<ValueDescriptor[]>();
            AtomicReference<MetaItemDescriptor[]> metaItemDescriptors = new AtomicReference<MetaItemDescriptor[]>();
            Function<String, ValueDescriptor> valueDescriptorProvider = name -> {
                ValueDescriptor found = null;
                if (valueDescriptors.get() != null) {
                    found = Arrays.stream((ValueDescriptor[])valueDescriptors.get()).filter(vd -> vd.getName().equals(name)).findFirst().orElse(null);
                }
                if (found == null) {
                    found = ValueUtil.getValueDescriptor((String)name).orElse(null);
                }
                return found;
            };
            Function<String, MetaItemDescriptor> metaDescriptorProvider = name -> {
                if (metaItemDescriptors.get() != null) {
                    return Arrays.stream((MetaItemDescriptor[])metaItemDescriptors.get()).filter(mid -> mid.getName().equals(name)).findFirst().orElse(null);
                }
                return null;
            };
            ctxt.setAttribute((Object)"value-descriptor-provider", valueDescriptorProvider);
            ctxt.setAttribute((Object)"meta-descriptor-provider", metaDescriptorProvider);
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String propName = jp.currentName();
                if (jp.currentToken() == JsonToken.FIELD_NAME) {
                    jp.nextToken();
                }
                if (jp.currentToken() == JsonToken.VALUE_NULL) continue;
                switch (propName) {
                    case "attributeDescriptors": {
                        if (metaItemDescriptors.get() == null) {
                            attributeDescriptorBuffer = new TokenBuffer(jp, ctxt);
                            attributeDescriptorBuffer.copyCurrentStructure(jp);
                            break;
                        }
                        attributeDescriptors = (AttributeDescriptor[])ctxt.findRootValueDeserializer(ATTRIBUTE_DESCRIPTOR_TYPE).deserialize(jp, ctxt);
                        break;
                    }
                    case "metaItemDescriptors": {
                        if (valueDescriptors.get() == null) {
                            metaItemDescriptorBuffer = new TokenBuffer(jp, ctxt);
                            metaItemDescriptorBuffer.copyCurrentStructure(jp);
                            break;
                        }
                        metaItemDescriptors.set((MetaItemDescriptor[])ctxt.findRootValueDeserializer(META_ITEM_DESCRIPTOR_TYPE).deserialize(jp, ctxt));
                        break;
                    }
                    case "valueDescriptors": {
                        valueDescriptors.set((ValueDescriptor[])ctxt.findRootValueDeserializer(VALUE_DESCRIPTOR_TYPE).deserialize(jp, ctxt));
                        break;
                    }
                    case "assetDescriptor": {
                        assetDescriptor = (AssetDescriptor)ctxt.findRootValueDeserializer(ASSET_DESCRIPTOR_TYPE).deserialize(jp, ctxt);
                    }
                }
            }
            if (metaItemDescriptorBuffer != null) {
                parser = metaItemDescriptorBuffer.asParser();
                parser.nextToken();
                metaItemDescriptors.set((MetaItemDescriptor[])ctxt.findRootValueDeserializer(META_ITEM_DESCRIPTOR_TYPE).deserialize(parser, ctxt));
            }
            if (attributeDescriptorBuffer != null) {
                parser = attributeDescriptorBuffer.asParser();
                parser.nextToken();
                attributeDescriptors = (AttributeDescriptor[])ctxt.findRootValueDeserializer(ATTRIBUTE_DESCRIPTOR_TYPE).deserialize(parser, ctxt);
            }
            if (assetDescriptor == null) {
                throw new JsonParseException(jp, "Must contain an asset descriptor");
            }
            return new AssetTypeInfo(assetDescriptor, attributeDescriptors, metaItemDescriptors.get() != null ? (MetaItemDescriptor[])metaItemDescriptors.get() : new MetaItemDescriptor[]{}, valueDescriptors.get() != null ? (ValueDescriptor[])valueDescriptors.get() : new ValueDescriptor[]{});
        }
    }
}

