/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.apps;

import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.timer.TimerService;
import org.openremote.container.util.MapAccess;
import org.openremote.container.web.WebService;
import org.openremote.manager.apps.AppResourceImpl;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;

public class ConsoleAppService
implements ContainerService {
    private static final Logger LOG = Logger.getLogger(ConsoleAppService.class.getName());
    protected TimerService timerService;
    protected ManagerWebService managerWebService;
    protected ManagerIdentityService identityService;
    protected PersistenceService persistenceService;
    Path consoleAppDocRoot;

    public void init(Container container) throws Exception {
        this.timerService = (TimerService)container.getService(TimerService.class);
        this.managerWebService = (ManagerWebService)container.getService(ManagerWebService.class);
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new AppResourceImpl(this));
        this.consoleAppDocRoot = Paths.get(MapAccess.getString((Map)container.getConfig(), (String)"OR_CUSTOM_APP_DOCROOT", (String)"deployment/manager/app"), new String[0]);
        if (Files.isDirectory(this.consoleAppDocRoot, new LinkOption[0])) {
            HttpHandler customBaseFileHandler = ManagerWebService.createFileHandler(container, (ResourceManager)new PathResourceManager(this.consoleAppDocRoot), null);
            PathHandler pathHandler = new PathHandler().addPrefixPath("info", customBaseFileHandler);
            this.managerWebService.getRequestHandlers().add(0, WebService.pathStartsWithHandler((String)"Console app info files", (String)"info", (HttpHandler)pathHandler));
        }
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public String[] getInstalled() throws Exception {
        return (String[])Stream.concat(Files.list(this.managerWebService.getBuiltInAppDocRoot()), Files.list(this.managerWebService.getCustomAppDocRoot())).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> !new File(path.toString(), ".appignore").exists()).map(dir -> dir.getFileName().toString()).distinct().toArray(String[]::new);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{consoleAppDocRoot=" + String.valueOf(this.consoleAppDocRoot) + "}";
    }
}

