/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.apps;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Map;
import java.util.stream.Collectors;
import org.openremote.container.web.WebResource;
import org.openremote.manager.apps.ConsoleAppService;
import org.openremote.model.apps.AppResource;
import org.openremote.model.apps.ConsoleAppConfig;
import org.openremote.model.http.RequestParams;
import org.openremote.model.util.ValueUtil;

public class AppResourceImpl
extends WebResource
implements AppResource {
    protected final ConsoleAppService consoleAppService;
    protected Map<String, Object> consoleAppInfoMap;
    protected Object consoleConfig;

    public AppResourceImpl(ConsoleAppService consoleAppService) {
        this.consoleAppService = consoleAppService;
    }

    public String[] getApps(RequestParams requestParams) {
        try {
            return this.consoleAppService.getInstalled();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public Response getAppInfos(RequestParams requestParams) {
        if (!Files.isDirectory(this.consoleAppService.consoleAppDocRoot, new LinkOption[0])) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("%s is not a directory", this.consoleAppService.consoleAppDocRoot)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        if (this.consoleAppInfoMap == null) {
            try {
                this.consoleAppInfoMap = Files.find(this.consoleAppService.consoleAppDocRoot, 2, (filePath, fileAttr) -> filePath.getFileName().toString().endsWith("info.json") && fileAttr.isRegularFile(), new FileVisitOption[0]).collect(Collectors.toMap(dir -> dir.getName(dir.getNameCount() - 2).toString(), dir -> {
                    try {
                        return ValueUtil.JSON.readValue(dir.toFile(), Object.class);
                    }
                    catch (IOException e) {
                        throw new WebApplicationException((Throwable)e);
                    }
                }));
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        return Response.ok(this.consoleAppInfoMap, (String)"application/json").build();
    }

    public Response getConsoleConfig(RequestParams requestParams) {
        if (!Files.isDirectory(this.consoleAppService.consoleAppDocRoot, new LinkOption[0])) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format("%s is not a directory", this.consoleAppService.consoleAppDocRoot)).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        if (!Files.exists(this.consoleAppService.consoleAppDocRoot.resolve("console_config.json"), new LinkOption[0])) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (this.consoleConfig == null) {
            try {
                this.consoleConfig = ValueUtil.JSON.readValue(new File(this.consoleAppService.consoleAppDocRoot.resolve("console_config.json").toString()), Object.class);
            }
            catch (IOException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        return Response.ok((Object)this.consoleConfig, (String)"application/json").build();
    }

    @Deprecated
    protected ConsoleAppConfig getAppConfig(String realm) {
        try {
            if (!Files.isDirectory(this.consoleAppService.consoleAppDocRoot, new LinkOption[0])) {
                return null;
            }
            return Files.list(this.consoleAppService.consoleAppDocRoot).filter(dir -> dir.getFileName().toString().startsWith(realm)).map(dir -> {
                try {
                    return (ConsoleAppConfig)ValueUtil.JSON.readValue(dir.toFile(), ConsoleAppConfig.class);
                }
                catch (IOException e) {
                    throw new WebApplicationException((Throwable)e);
                }
            }).findFirst().orElseThrow(NotFoundException::new);
        }
        catch (IOException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

