/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.app;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openremote.container.persistence.PersistenceService;
import org.openremote.container.timer.TimerService;
import org.openremote.container.util.CodecUtil;
import org.openremote.container.util.MapAccess;
import org.openremote.manager.app.ConfigurationResourceImpl;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebService;
import org.openremote.model.Container;
import org.openremote.model.ContainerService;
import org.openremote.model.file.FileInfo;
import org.openremote.model.manager.ManagerAppConfig;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;

public class ConfigurationService
implements ContainerService {
    public static final String OR_MAP_SETTINGS_PATH = "OR_MAP_SETTINGS_PATH";
    public static final String OR_MAP_SETTINGS_PATH_DEFAULT = "manager/src/map/mapsettings.json";
    public static final String OR_MAP_TILES_PATH = "OR_MAP_TILES_PATH";
    public static final String OR_MAP_TILES_PATH_DEFAULT = "manager/src/map/mapdata.mbtiles";
    protected ManagerIdentityService identityService;
    protected PersistenceService persistenceService;
    protected Path pathPublicRoot;
    private static final Logger LOG = Logger.getLogger(ConfigurationService.class.getName());
    protected Path mapTilesPath;
    protected Path mapSettingsPath;
    protected Path managerConfigPath;
    protected AtomicReference<ManagerAppConfig> managerAppConfig;

    public void init(Container container) throws Exception {
        this.identityService = (ManagerIdentityService)container.getService(ManagerIdentityService.class);
        this.persistenceService = (PersistenceService)container.getService(PersistenceService.class);
        this.pathPublicRoot = Paths.get(MapAccess.getString((Map)container.getConfig(), (String)"OR_CUSTOM_APP_DOCROOT", (String)"deployment/manager/app"), new String[0]);
        ((ManagerWebService)container.getService(ManagerWebService.class)).addApiSingleton((Object)new ConfigurationResourceImpl((TimerService)container.getService(TimerService.class), this.identityService, this));
        this.mapSettingsPath = Stream.of(this.getPersistedMapConfigPath().toString(), MapAccess.getString((Map)container.getConfig(), (String)OR_MAP_SETTINGS_PATH, (String)OR_MAP_SETTINGS_PATH_DEFAULT), "/opt/map/mapsettings.json", OR_MAP_SETTINGS_PATH_DEFAULT).map(x$0 -> Path.of(x$0, new String[0])).map(Path::toAbsolutePath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().orElse(null);
        this.mapTilesPath = Stream.of(MapAccess.getString((Map)container.getConfig(), (String)OR_MAP_TILES_PATH, (String)OR_MAP_TILES_PATH_DEFAULT), "/deployment/map/mapdata.mbtiles", "/opt/map/mapdata.mbtiles", OR_MAP_TILES_PATH_DEFAULT).map(x$0 -> Path.of(x$0, new String[0])).map(Path::toAbsolutePath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().orElse(null);
        this.managerConfigPath = Stream.of(this.getPersistedManagerConfigPath(), this.pathPublicRoot.resolve("manager_config.json")).map(Path::toAbsolutePath).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().orElse(null);
        if (this.mapSettingsPath == null) {
            LOG.warning("Could not find map settings");
            return;
        }
        LOG.info("Configuration Service Used files:");
        LOG.info("\t- manager_config.json: " + String.valueOf(this.managerConfigPath));
        LOG.info("\t- mapsettings.json: " + String.valueOf(this.mapSettingsPath));
        LOG.info("\t- mapdata.mbtiles: " + String.valueOf(Optional.of(this.getCustomMapTilesPath(true)).map(p -> p.toFile().isDirectory() ? null : p).orElse(this.mapTilesPath)));
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public String toString() {
        return "ConfigurationService{mapTilesPath=" + String.valueOf(this.mapTilesPath) + ", mapSettingsPath=" + String.valueOf(this.mapSettingsPath) + ", managerConfigPath=" + String.valueOf(this.managerConfigPath) + "}";
    }

    public ObjectNode getMapConfig() {
        if (this.mapSettingsPath == null) {
            return null;
        }
        try {
            return (ObjectNode)ValueUtil.JSON.readTree(this.mapSettingsPath.toFile());
        }
        catch (IOException e) {
            LOG.severe("Could not read map_settings.json from " + String.valueOf(this.mapSettingsPath));
            return null;
        }
    }

    public void saveMapConfig(ObjectNode mapConfiguration) throws RuntimeException {
        LOG.log(Level.INFO, "Saving map_settings.json to: " + String.valueOf(this.getPersistedMapConfigPath()));
        try {
            Path p = this.getPersistedMapConfigPath();
            File file = p.toAbsolutePath().toFile();
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            Files.writeString(p, (CharSequence)ValueUtil.JSON.writeValueAsString((Object)mapConfiguration), StandardCharsets.UTF_8, new OpenOption[0]);
            this.mapSettingsPath = p;
        }
        catch (Exception exception) {
            String msg = "Error saving map_settings.json: msg=" + exception.getMessage();
            LOG.log(Level.WARNING, msg);
            throw new IllegalStateException(msg);
        }
    }

    public Path getMapTilesPath() {
        return this.mapTilesPath;
    }

    public Path getCustomMapTilesPath(boolean findMBTilesFile) throws IOException {
        Path parentDir = this.getPersistedCustomTilesPath();
        try {
            if (!Files.exists(parentDir, new LinkOption[0])) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Could not create parent directory for custom tiles", e);
            throw e;
        }
        if (!findMBTilesFile) {
            return parentDir;
        }
        Path defaultMapTilesFilename = Optional.ofNullable(this.mapTilesPath).map(Path::toAbsolutePath).orElse(null);
        return Arrays.stream(Objects.requireNonNull(parentDir.toFile().listFiles((dir, name) -> name.endsWith(".mbtiles")))).map(File::toPath).filter(p -> !p.toAbsolutePath().equals(defaultMapTilesFilename)).findFirst().orElse(parentDir);
    }

    public ManagerAppConfig getManagerConfig() {
        if (this.managerAppConfig != null) {
            return this.managerAppConfig.get();
        }
        if (this.managerConfigPath == null) {
            return null;
        }
        try {
            String managerConfigStr = Files.readString(this.managerConfigPath, StandardCharsets.UTF_8);
            return ValueUtil.parse((String)managerConfigStr, ManagerAppConfig.class).orElse(null);
        }
        catch (Exception e) {
            LOG.severe("Could not read manager_config.json from " + String.valueOf(this.managerConfigPath));
            return null;
        }
    }

    public void saveManagerConfig(ManagerAppConfig managerAppConfig) throws Exception {
        LOG.log(Level.INFO, "Saving manager_config.json to: " + String.valueOf(this.getPersistedManagerConfigPath()));
        try {
            managerAppConfig = this.checkAndFixImageReferences(managerAppConfig);
            Path p = this.getPersistedManagerConfigPath();
            File file = p.toAbsolutePath().toFile();
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            Files.writeString(p, (CharSequence)ValueUtil.JSON.writeValueAsString((Object)managerAppConfig), StandardCharsets.UTF_8, new OpenOption[0]);
            this.managerConfigPath = p;
            if (this.managerAppConfig == null) {
                this.managerAppConfig = new AtomicReference<ManagerAppConfig>(managerAppConfig);
            } else {
                this.managerAppConfig.set(managerAppConfig);
            }
        }
        catch (Exception exception) {
            String msg = "Error saving manager_config.json: msg=" + exception.getMessage();
            LOG.log(Level.WARNING, msg);
            throw new Exception(msg);
        }
    }

    public void saveManagerConfigImage(String path, FileInfo fileInfo) throws Exception {
        LOG.log(Level.INFO, "Saving image in manager_config.json: " + String.valueOf(fileInfo));
        path = path.replace("/images/", "");
        path = path.charAt(0) == '/' ? path.substring(1) : path;
        Path resolvedPath = Path.of(path, new String[0]);
        resolvedPath = this.getPersistedManagerConfigImagePath().resolve(resolvedPath);
        Path filePath = this.getPersistedManagerConfigImagePath().resolve(path);
        File file = filePath.toAbsolutePath().toFile();
        try {
            boolean isValid = resolvedPath.toFile().getCanonicalPath().contains(this.getPersistedManagerConfigImagePath().toFile().getCanonicalPath() + File.separator);
            if (!isValid) {
                String msg = "Failed to save manager config image path outside permitted directory: " + String.valueOf(resolvedPath);
                LOG.warning(msg);
                throw new Exception("Failed to save manager config image path outside permitted directory: " + String.valueOf(resolvedPath));
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            Files.write(filePath, CodecUtil.decodeBase64((String)fileInfo.getContents()), new OpenOption[0]);
        }
        catch (Exception exception) {
            String msg = "Error saving image in manager_config.json '" + String.valueOf(filePath) + "': msg=" + exception.getMessage();
            LOG.log(Level.WARNING, msg);
            throw new Exception(msg);
        }
    }

    public Optional<File> getManagerConfigImage(String filename) {
        File file = this.getPersistedManagerConfigImagePath().resolve(filename).toFile();
        try {
            String checkPath;
            if (file.isFile()) {
                checkPath = this.getPersistedManagerConfigImagePath().toFile().getCanonicalPath();
            } else {
                file = this.pathPublicRoot.resolve("images").resolve(filename).toFile();
                checkPath = this.pathPublicRoot.toFile().getCanonicalPath();
            }
            boolean isValid = file.getCanonicalPath().contains(checkPath + File.separator);
            if (!isValid) {
                return Optional.empty();
            }
        }
        catch (IOException e) {
            return Optional.empty();
        }
        return file.isFile() ? Optional.of(file) : Optional.empty();
    }

    protected Path getPersistedManagerConfigPath() {
        return this.persistenceService.getStorageDir().resolve("manager").resolve("manager_config.json");
    }

    protected Path getPersistedMapConfigPath() {
        return this.persistenceService.getStorageDir().resolve("manager").resolve("mapsettings.json");
    }

    protected Path getPersistedCustomTilesPath() {
        return this.persistenceService.getStorageDir().resolve("map");
    }

    protected Path getPersistedManagerConfigImagePath() {
        return this.persistenceService.resolvePath("manager").resolve("images");
    }

    protected ManagerAppConfig checkAndFixImageReferences(ManagerAppConfig managerAppConfig) {
        if (!this.getPersistedManagerConfigImagePath().toFile().exists()) {
            this.getPersistedManagerConfigImagePath().toFile().mkdirs();
        }
        if (managerAppConfig.getRealms() != null && !managerAppConfig.getRealms().isEmpty()) {
            managerAppConfig.getRealms().values().forEach(managerAppRealmConfig -> {
                if (!TextUtil.isNullOrEmpty((String)managerAppRealmConfig.getLogo())) {
                    managerAppRealmConfig.setLogo(this.fixImageRef(managerAppRealmConfig.getLogo()));
                }
                if (!TextUtil.isNullOrEmpty((String)managerAppRealmConfig.getLogoMobile())) {
                    managerAppRealmConfig.setLogoMobile(this.fixImageRef(managerAppRealmConfig.getLogoMobile()));
                }
                if (!TextUtil.isNullOrEmpty((String)managerAppRealmConfig.getFavicon())) {
                    managerAppRealmConfig.setFavicon(this.fixImageRef(managerAppRealmConfig.getFavicon()));
                }
            });
        }
        return managerAppConfig;
    }

    protected String fixImageRef(String image) {
        String originalString = image;
        if (!((String)image).isBlank()) {
            image = ((String)image).replace("/api/master/configuration/manager/image/", "");
            image = ((String)(image = ((String)image).replace("images/", ""))).charAt(0) == '/' ? ((String)image).substring(1) : image;
            Path imagePath = Path.of((String)image, new String[0]);
            Path persistedImagePath = this.getPersistedManagerConfigImagePath().resolve(imagePath).toAbsolutePath();
            Path path = this.pathPublicRoot.resolve("images").resolve(imagePath).toAbsolutePath();
            if (!Files.isRegularFile(persistedImagePath, new LinkOption[0])) {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    try {
                        Files.copy(path, persistedImagePath, new CopyOption[0]);
                        image = "/api/master/configuration/manager/image/" + String.valueOf(imagePath);
                    }
                    catch (Exception e) {
                        LOG.warning("Error occurred whilst copying manager config image to persisted path: " + String.valueOf(persistedImagePath));
                    }
                } else {
                    LOG.warning("manager_config.json image reference doesn't exist: " + String.valueOf(imagePath));
                }
            } else {
                return originalString;
            }
        }
        return image;
    }
}

