/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.app;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.openremote.container.timer.TimerService;
import org.openremote.container.web.WebService;
import org.openremote.manager.app.ConfigurationService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.file.FileInfo;
import org.openremote.model.http.RequestParams;
import org.openremote.model.manager.ConfigurationResource;
import org.openremote.model.manager.ManagerAppConfig;

public class ConfigurationResourceImpl
extends ManagerWebResource
implements ConfigurationResource {
    protected ConfigurationService configurationService;
    private static final Logger LOG = Logger.getLogger(WebService.class.getName());

    public ConfigurationResourceImpl(TimerService timerService, ManagerIdentityService identityService, ConfigurationService configurationService) {
        super(timerService, identityService);
        this.configurationService = configurationService;
    }

    public ManagerAppConfig update(RequestParams requestParams, ManagerAppConfig managerConfiguration) {
        try {
            this.configurationService.saveManagerConfig(managerConfiguration);
        }
        catch (Exception e) {
            LOG.warning("Couldn't store manager_config.json:" + e.getMessage());
            throw new InternalServerErrorException("Error updating manager_config.json");
        }
        return managerConfiguration;
    }

    public String fileUpload(RequestParams requestParams, String path, FileInfo fileInfo) {
        try {
            this.configurationService.saveManagerConfigImage(path, fileInfo);
        }
        catch (Exception e) {
            LOG.warning("Save image failed '" + path + "': " + e.getMessage());
            throw new InternalServerErrorException("Error storing image");
        }
        Path managerConfigPath = Path.of("/api", new String[0]).resolve("master").resolve("configuration").resolve("manager").resolve("image").resolve(path);
        return managerConfigPath.toString();
    }

    public ManagerAppConfig getManagerConfig() {
        return this.configurationService.getManagerConfig();
    }

    public Object getManagerConfigImage(String fileName) {
        try {
            File imageFile = this.configurationService.getManagerConfigImage(fileName).orElseThrow();
            if (!imageFile.exists()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            String mimeType = Files.probeContentType(imageFile.toPath());
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            Response.ResponseBuilder response = Response.ok((Object)imageFile, (String)mimeType);
            return response.build();
        }
        catch (NoSuchElementException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Image not Found").build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Error retrieving image").build();
        }
    }
}

