/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.alarm;

import jakarta.persistence.EntityNotFoundException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openremote.container.timer.TimerService;
import org.openremote.manager.alarm.AlarmService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.alarm.Alarm;
import org.openremote.model.alarm.AlarmAssetLink;
import org.openremote.model.alarm.AlarmResource;
import org.openremote.model.alarm.SentAlarm;
import org.openremote.model.http.RequestParams;
import org.openremote.model.util.TextUtil;

public class AlarmResourceImpl
extends ManagerWebResource
implements AlarmResource {
    private final AlarmService alarmService;

    public AlarmResourceImpl(TimerService timerService, ManagerIdentityService identityService, AlarmService alarmService) {
        super(timerService, identityService);
        this.alarmService = alarmService;
    }

    public SentAlarm[] getAlarms(RequestParams requestParams, String realm, Alarm.Status status, String assetId, String assigneeId) {
        try {
            String filterRealm;
            String string = filterRealm = TextUtil.isNullOrEmpty((String)realm) ? this.getAuthenticatedRealmName() : realm;
            if (!this.isRealmActiveAndAccessible(filterRealm)) {
                throw new ForbiddenException("Realm '" + filterRealm + "' is nonexistent, inactive or inaccessible");
            }
            return this.alarmService.getAlarms(filterRealm, status, assetId, assigneeId).toArray(new SentAlarm[0]);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        catch (ForbiddenException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    public void removeAlarms(RequestParams requestParams, List<Long> alarmIds) {
        try {
            if (!this.isRealmActiveAndAccessible(this.getAuthenticatedRealmName())) {
                throw new ForbiddenException("Realm '" + this.getAuthenticatedRealmName() + "' is nonexistent, inactive or inaccessible");
            }
            List<SentAlarm> alarms = this.alarmService.getAlarms(alarmIds);
            this.alarmService.removeAlarms(alarms, alarmIds);
        }
        catch (EntityNotFoundException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (ForbiddenException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    public SentAlarm getAlarm(RequestParams requestParams, Long alarmId) {
        try {
            SentAlarm alarm = this.alarmService.getAlarm(alarmId);
            if (!this.isRealmActiveAndAccessible(alarm.getRealm())) {
                throw new ForbiddenException("Realm '" + alarm.getRealm() + "' is nonexistent, inactive or inaccessible");
            }
            return this.alarmService.getAlarm(alarmId);
        }
        catch (EntityNotFoundException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (ForbiddenException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    public void removeAlarm(RequestParams requestParams, Long alarmId) {
        try {
            SentAlarm alarm = this.alarmService.getAlarm(alarmId);
            if (!this.isRealmActiveAndAccessible(alarm.getRealm())) {
                throw new ForbiddenException("Realm '" + alarm.getRealm() + "' is nonexistent, inactive or inaccessible");
            }
            this.alarmService.removeAlarm(alarm);
        }
        catch (EntityNotFoundException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (ForbiddenException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        catch (IllegalArgumentException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    public SentAlarm createAlarm(RequestParams requestParams, Alarm alarm, List<String> assetIds) {
        try {
            if (this.getUserId() != null) {
                alarm.setSource(Alarm.Source.MANUAL);
                alarm.setSourceId(this.getUserId());
            } else if (this.getClientId() != null) {
                alarm.setSource(Alarm.Source.CLIENT);
                alarm.setSourceId(this.getClientId());
            }
            if (!this.isRealmActiveAndAccessible(alarm.getRealm())) {
                throw new ForbiddenException("Realm '" + alarm.getRealm() + "' is nonexistent, inactive or inaccessible");
            }
            return this.alarmService.sendAlarm(alarm, assetIds);
        }
        catch (NullPointerException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        catch (ForbiddenException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    public void updateAlarm(RequestParams requestParams, Long alarmId, SentAlarm newAlarm) {
        try {
            SentAlarm oldAlarm = this.alarmService.getAlarm(alarmId);
            if (!this.isRealmActiveAndAccessible(oldAlarm.getRealm())) {
                throw new ForbiddenException("Realm '" + oldAlarm.getRealm() + "' is nonexistent, inactive or inaccessible");
            }
            this.alarmService.updateAlarm(oldAlarm, newAlarm);
        }
        catch (EntityNotFoundException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (ForbiddenException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    public List<AlarmAssetLink> getAssetLinks(RequestParams requestParams, Long alarmId, String realm) {
        try {
            if (!this.isRealmActiveAndAccessible(realm)) {
                throw new ForbiddenException("Realm '" + realm + "' is nonexistent, inactive or inaccessible");
            }
            return this.alarmService.getAssetLinks(alarmId, realm);
        }
        catch (EntityNotFoundException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (ForbiddenException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    public void setAssetLinks(RequestParams requestParams, List<AlarmAssetLink> links) {
        try {
            if (links == null || links.isEmpty()) {
                throw new IllegalArgumentException("No AlarmAssetLink objects were provided.");
            }
            Set realms = links.stream().map(link -> link.getId().getRealm()).collect(Collectors.toSet());
            if (!this.isRealmActiveAndAccessible((String)realms.stream().findFirst().orElse(null))) {
                throw new ForbiddenException("Realm '" + String.valueOf(realms.stream().findFirst()) + "' is nonexistent, inactive or inaccessible");
            }
            this.alarmService.linkAssets(links);
        }
        catch (EntityNotFoundException e) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        catch (ForbiddenException e) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }
}

