/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.agent;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotAllowedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.NotSupportedException;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openremote.container.timer.TimerService;
import org.openremote.container.util.CodecUtil;
import org.openremote.manager.agent.AgentService;
import org.openremote.manager.asset.AssetStorageService;
import org.openremote.manager.security.ManagerIdentityService;
import org.openremote.manager.web.ManagerWebResource;
import org.openremote.model.asset.Asset;
import org.openremote.model.asset.AssetTreeNode;
import org.openremote.model.asset.agent.Agent;
import org.openremote.model.asset.agent.AgentDescriptor;
import org.openremote.model.asset.agent.AgentResource;
import org.openremote.model.file.FileInfo;
import org.openremote.model.http.RequestParams;
import org.openremote.model.util.TextUtil;
import org.openremote.model.util.ValueUtil;

public class AgentResourceImpl
extends ManagerWebResource
implements AgentResource {
    private static final Logger LOG = Logger.getLogger(AgentResourceImpl.class.getName());
    protected final AgentService agentService;
    protected final AssetStorageService assetStorageService;
    protected final ExecutorService executorService;

    public AgentResourceImpl(TimerService timerService, ManagerIdentityService identityService, AssetStorageService assetStorageService, AgentService agentService, ExecutorService executorService) {
        super(timerService, identityService);
        this.agentService = agentService;
        this.assetStorageService = assetStorageService;
        this.executorService = executorService;
    }

    public Agent<?, ?, ?>[] doProtocolInstanceDiscovery(RequestParams requestParams, String parentId, String agentType, String realm) {
        Optional agentDescriptor;
        if (!this.isSuperUser()) {
            realm = this.getAuthenticatedRealmName();
        }
        if (parentId != null) {
            Asset<?> asset = this.assetStorageService.find(parentId, false);
            if (asset == null) {
                throw new NotFoundException("Parent asset does not exist");
            }
            if (realm != null && !asset.getRealm().equals(realm)) {
                throw new ForbiddenException("Parent asset not in the correct realm: agent ID =" + parentId);
            }
        }
        if (!(agentDescriptor = ValueUtil.getAgentDescriptor((String)agentType)).isPresent()) {
            throw new IllegalArgumentException("Agent descriptor not found: agent type =" + agentType);
        }
        if (!agentDescriptor.map(AgentDescriptor::isInstanceDiscovery).orElse(false).booleanValue()) {
            throw new NotSupportedException("Agent protocol doesn't support instance discovery");
        }
        ArrayList foundAgents = new ArrayList();
        this.agentService.doProtocolInstanceDiscovery(parentId, ((AgentDescriptor)agentDescriptor.get()).getInstanceDiscoveryProviderClass(), agents -> {
            if (agents != null) {
                foundAgents.addAll(Arrays.asList(agents));
            }
        });
        return foundAgents.toArray(new Agent[0]);
    }

    public AssetTreeNode[] doProtocolAssetDiscovery(RequestParams requestParams, String agentId, String realm) {
        Agent<?, ?, ?> agent;
        if (!this.isSuperUser()) {
            realm = this.getAuthenticatedRealmName();
        }
        if ((agent = this.agentService.getAgent(agentId)) == null) {
            throw new IllegalArgumentException("Agent not found: agent ID =" + agentId);
        }
        if (realm != null && !realm.equals(agent.getRealm())) {
            throw new ForbiddenException("Agent not in the correct realm: agent ID =" + agentId);
        }
        ArrayList foundAssets = new ArrayList();
        String finalRealm = realm;
        Future<Void> result = this.agentService.doProtocolAssetDiscovery(agent, assets -> {
            if (assets != null) {
                this.executorService.submit(() -> this.persistAssets((AssetTreeNode[])assets, (Asset<?>)agent, finalRealm));
                foundAssets.addAll(Arrays.asList(assets));
            }
        });
        try {
            result.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.fine("Protocol discovery stopped as timeout reached");
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Protocol discovery threw an exception: " + String.valueOf(agent), e);
            throw new BadRequestException("Protocol discovery threw an exception: " + String.valueOf(agent), (Throwable)e);
        }
        return foundAssets.toArray(new AssetTreeNode[0]);
    }

    public AssetTreeNode[] doProtocolAssetImport(RequestParams requestParams, String agentId, String realm, FileInfo fileInfo) {
        byte[] fileData;
        Agent<?, ?, ?> agent;
        if (!this.isSuperUser()) {
            realm = this.getAuthenticatedRealmName();
        }
        if ((agent = this.agentService.getAgent(agentId)) == null) {
            throw new IllegalArgumentException("Agent not found: agent ID =" + agentId);
        }
        if (realm != null && !realm.equals(agent.getRealm())) {
            throw new ForbiddenException("Agent not in the correct realm: agent ID =" + agentId);
        }
        ArrayList foundAssets = new ArrayList();
        try {
            fileData = fileInfo.isBinary() ? CodecUtil.decodeBase64((String)fileInfo.getContents()) : fileInfo.getContents().getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            String msg = "Failed to decode file info: name = " + fileInfo.getName();
            LOG.log(Level.WARNING, msg, e);
            throw new BadRequestException(msg);
        }
        try {
            Future<Void> future = this.agentService.doProtocolAssetImport(agent, fileData, assets -> {
                if (assets != null) {
                    foundAssets.addAll(Arrays.asList(assets));
                }
            });
            future.get();
        }
        catch (UnsupportedOperationException e) {
            throw new NotAllowedException((Throwable)e, new String[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ProcessingException((Throwable)e);
        }
        AssetTreeNode[] foundAssetsArr = foundAssets.toArray(new AssetTreeNode[0]);
        this.persistAssets(foundAssetsArr, (Asset<?>)agent, realm);
        return foundAssetsArr;
    }

    protected void persistAssets(AssetTreeNode[] assets, Asset<?> parentAsset, String realm) {
        try {
            LOG.fine("Persisting assets");
            if (assets == null || assets.length == 0) {
                LOG.fine("No assets to import");
                return;
            }
            for (AssetTreeNode assetNode : assets) {
                Asset asset = assetNode.asset;
                if (asset == null) {
                    LOG.fine("Skipping node as asset not set");
                    continue;
                }
                asset.setId(null);
                asset.setRealm(realm);
                asset.setParent(parentAsset);
                assetNode.asset = this.assetStorageService.merge(asset);
                if (assetNode.children == null) continue;
                this.persistAssets(assetNode.children, assetNode.asset, realm);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
            throw new NotFoundException(e.getMessage());
        }
        catch (UnsupportedOperationException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
            throw new NotSupportedException(e.getMessage());
        }
        catch (IllegalStateException e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
            throw new InternalServerErrorException(e.getMessage());
        }
    }

    protected Asset<?> getParent(String parentId, String realm) throws WebApplicationException {
        if (!this.isSuperUser() && !realm.equals(this.getAuthenticatedRealmName())) {
            throw new ForbiddenException();
        }
        if (TextUtil.isNullOrEmpty((String)parentId)) {
            return null;
        }
        Asset<?> parentAsset = this.assetStorageService.find(parentId);
        if (parentAsset == null || !TextUtil.isNullOrEmpty((String)realm) && parentAsset.getRealm().equals(realm)) {
            throw new NotFoundException("Parent asset doesn't exist in the requested realm '" + realm + "'");
        }
        return parentAsset;
    }
}

