/*
 * Decompiled with CFR 0.152.
 */
package org.openremote.manager.agent;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.openremote.manager.agent.AgentService;
import org.openremote.model.Container;
import org.openremote.model.asset.agent.Agent;
import org.openremote.model.asset.agent.ConnectionStatus;
import org.openremote.model.system.HealthStatusProvider;

public class AgentHealthStatusProvider
implements HealthStatusProvider {
    public static final String NAME = "agents";
    protected AgentService agentService;

    public void init(Container container) throws Exception {
        this.agentService = (AgentService)container.getService(AgentService.class);
    }

    public void start(Container container) throws Exception {
    }

    public void stop(Container container) throws Exception {
    }

    public String getHealthStatusName() {
        return NAME;
    }

    public Object getHealthStatus() {
        AtomicInteger connectedCount = new AtomicInteger(0);
        AtomicInteger disabledCount = new AtomicInteger(0);
        AtomicInteger errorCount = new AtomicInteger(0);
        AtomicInteger otherCount = new AtomicInteger(0);
        HashMap<String, Serializable> objectValue = new HashMap<String, Serializable>();
        objectValue.put(NAME, Integer.valueOf(this.agentService.getAgents().size()));
        objectValue.put("protocols", Integer.valueOf(this.agentService.protocolInstanceMap.size()));
        for (Agent<?, ?, ?> agent : this.agentService.getAgents().values()) {
            ConnectionStatus status = agent.getAgentStatus().orElse(null);
            if (status != null) {
                switch (status) {
                    case DISCONNECTED: 
                    case CONNECTING: 
                    case DISCONNECTING: 
                    case WAITING: {
                        otherCount.incrementAndGet();
                        break;
                    }
                    case CONNECTED: {
                        connectedCount.incrementAndGet();
                        break;
                    }
                    case DISABLED: {
                        disabledCount.incrementAndGet();
                        break;
                    }
                    case ERROR: {
                        errorCount.incrementAndGet();
                    }
                }
            } else {
                otherCount.incrementAndGet();
            }
            HashMap<String, String> agentValue = new HashMap<String, String>();
            agentValue.put("name", agent.getName());
            agentValue.put("status", status != null ? status.name() : "null");
            agentValue.put("type", agent.getType());
            objectValue.put(agent.getId(), agentValue);
        }
        objectValue.put("totalAgents", Integer.valueOf(this.agentService.getAgents().size()));
        objectValue.put("connectedAgents", Integer.valueOf(connectedCount.get()));
        objectValue.put("errorAgents", Integer.valueOf(errorCount.get()));
        objectValue.put("disabledAgents", Integer.valueOf(disabledCount.get()));
        objectValue.put("otherAgents", Integer.valueOf(otherCount.get()));
        return objectValue;
    }
}

