/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.policy.output.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.openraven.magpie.api.PolicyOutputPlugin;
import io.openraven.magpie.plugins.policy.output.json.analysis.IgnoredRule;
import io.openraven.magpie.plugins.policy.output.json.analysis.ScanResults;
import io.openraven.magpie.plugins.policy.output.json.analysis.Violation;
import io.openraven.magpie.plugins.policy.output.json.model.Policy;
import io.openraven.magpie.plugins.policy.output.json.model.Rule;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class JsonReportPlugin
implements PolicyOutputPlugin<Void> {
    private static final String ID = "magpie.policy.output.json";
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false).findAndRegisterModules();

    public void generateReport(ObjectNode data) {
        ScanResults results = this.parseData(data);
        try {
            ObjectNode parentNode = MAPPER.createObjectNode();
            this.generateReportMeta(results, parentNode);
            this.generateDisabledPolicies(results, parentNode);
            this.generatePolicyAnalysis(results, parentNode);
            MAPPER.writeValue((OutputStream)System.out, (Object)parentNode);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize policy analysis results to JSON format", e);
        }
    }

    private void generatePolicyAnalysis(ScanResults results, ObjectNode parentNode) {
        ArrayNode policiesArrayNode = MAPPER.createArrayNode();
        parentNode.set("policies", (JsonNode)policiesArrayNode);
        Map<Policy, List<Violation>> violationMap = results.getViolations().stream().collect(Collectors.groupingBy(Violation::getPolicy));
        Map<Policy, List<IgnoredRule>> ignoredRulesMap = results.getIgnoredRules().stream().collect(Collectors.groupingBy(IgnoredRule::getPolicy));
        results.getPolicies().forEach(policy -> {
            List policyViolations = (List)violationMap.get(policy);
            List ignoredRules = (List)ignoredRulesMap.get(policy);
            ObjectNode policyNode = MAPPER.createObjectNode();
            policyNode.put("name", policy.getName());
            policyNode.put("violationsCount", policyViolations == null ? 0 : policyViolations.size());
            this.generateViolation((Policy)policy, policyViolations, policyNode);
            this.generateIgnoredRule(ignoredRules, policyNode);
            policiesArrayNode.add((JsonNode)policyNode);
        });
    }

    private void generateIgnoredRule(List<IgnoredRule> ignoredRules, ObjectNode policyNode) {
        if (ignoredRules != null) {
            ArrayNode ignoredRulesArray = MAPPER.createArrayNode();
            policyNode.set("ignoredRules", (JsonNode)ignoredRulesArray);
            ignoredRules.forEach(rule -> {
                ObjectNode ignoredRuleNode = MAPPER.createObjectNode();
                ignoredRuleNode.put("name", rule.getRule().getName());
                ignoredRuleNode.put("file", rule.getRule().getFileName());
                ignoredRuleNode.put("reason", rule.getIgnoredReason().getReason());
                ignoredRulesArray.add((JsonNode)ignoredRuleNode);
            });
        }
    }

    private void generateViolation(Policy policy, List<Violation> policyViolations, ObjectNode policyNode) {
        ArrayNode violationsArray = MAPPER.createArrayNode();
        policyNode.set("violations", (JsonNode)violationsArray);
        if (policyViolations != null) {
            policyViolations.forEach(policyViolation -> {
                Rule violatedRule = policyViolation.getRule();
                ObjectNode violatedRuleNode = MAPPER.createObjectNode();
                violatedRuleNode.put("name", violatedRule.getName());
                violatedRuleNode.put("file", violatedRule.getFileName());
                violatedRuleNode.put("severety", violatedRule.getSeverity().getTitle());
                ObjectNode violationNode = MAPPER.createObjectNode();
                violationNode.put("resourceID", policyViolation.getAssetId());
                violationNode.set("violatedRule", (JsonNode)violatedRuleNode);
                violationsArray.add((JsonNode)violationNode);
            });
        }
    }

    private void generateDisabledPolicies(ScanResults results, ObjectNode parentNode) {
        ArrayNode disabledPoliciesNode = MAPPER.createArrayNode();
        parentNode.set("disabledPolicies", (JsonNode)disabledPoliciesNode);
        List<Policy> disabledPolicies = results.getPolicies().stream().filter(policy -> !policy.isEnabled()).collect(Collectors.toList());
        if (!disabledPolicies.isEmpty()) {
            disabledPolicies.forEach(policy -> {
                ObjectNode policyNode = MAPPER.createObjectNode();
                policyNode.put("Policy GUID", policy.getId());
                policyNode.put("Policy name", policy.getName());
                disabledPoliciesNode.add((JsonNode)policyNode);
            });
        }
    }

    private void generateReportMeta(ScanResults results, ObjectNode parentNode) {
        ObjectNode metaNode = MAPPER.createObjectNode();
        metaNode.put("startTime", results.getScanMetadata().getStartDateTime().toString());
        metaNode.put("duration", this.humanReadableFormat(results.getScanMetadata().getDuration()));
        parentNode.set("meta", (JsonNode)metaNode);
    }

    private String humanReadableFormat(Duration duration) {
        return duration.toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    private ScanResults parseData(ObjectNode data) {
        try {
            return (ScanResults)MAPPER.treeToValue((TreeNode)data, ScanResults.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to parse data for plugin: " + this.id(), e);
        }
    }

    public String id() {
        return ID;
    }

    public void init(Void config, Logger logger) {
    }

    public void shutdown() {
        super.shutdown();
    }

    public Class<Void> configType() {
        return null;
    }
}

