/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.policy.output.csv;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.openraven.magpie.api.PolicyOutputPlugin;
import io.openraven.magpie.plugins.policy.output.csv.analysis.IgnoredRule;
import io.openraven.magpie.plugins.policy.output.csv.analysis.ScanResults;
import io.openraven.magpie.plugins.policy.output.csv.analysis.Violation;
import io.openraven.magpie.plugins.policy.output.csv.exception.CsvOutputException;
import java.io.IOException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvReportPlugin
implements PolicyOutputPlugin<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvReportPlugin.class);
    private static final String ID = "magpie.policy.output.csv";
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule());
    private CSVPrinter printer;

    public void generateReport(ObjectNode data) {
        ScanResults results = this.parseData(data);
        try {
            this.printer.printRecord(new Object[]{"Policy name", "Resource ID", "Rule file name", "Rule name", "Ignored Reason"});
            if (!results.getViolations().isEmpty() || !results.getIgnoredRules().isEmpty()) {
                for (Violation violation : results.getViolations()) {
                    this.printer.printRecord(new Object[]{violation.getPolicy().getPolicyName(), violation.getAssetId(), violation.getRule().getFileName(), this.trimLineSeparator(violation.getRule().getRuleName()), null});
                }
                for (IgnoredRule ignoredRule : results.getIgnoredRules()) {
                    this.printer.printRecord(new Object[]{ignoredRule.getPolicy().getPolicyName(), null, ignoredRule.getRule().getFileName(), this.trimLineSeparator(ignoredRule.getRule().getRuleName()), ignoredRule.getIgnoredReason().getReason()});
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize policy analysis results to CSV format", e);
        }
    }

    private String trimLineSeparator(String line) {
        return line.replace(System.lineSeparator(), "").replace("\"", "");
    }

    protected ScanResults parseData(ObjectNode data) {
        try {
            return (ScanResults)MAPPER.treeToValue((TreeNode)data, ScanResults.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to parse data for plugin: " + this.id(), e);
        }
    }

    public String id() {
        return ID;
    }

    public void init(Void config, Logger logger) {
        try {
            this.printer = new CSVPrinter((Appendable)System.out, CSVFormat.DEFAULT);
        }
        catch (IOException e) {
            throw new CsvOutputException("Unable to instantiate the CSVPrinter for system.out stream", e);
        }
    }

    public void shutdown() {
        try {
            this.printer.close(true);
        }
        catch (IOException e) {
            throw new CsvOutputException("Unable to close the CSVPrinter", e);
        }
    }

    public Class<Void> configType() {
        return null;
    }
}

