/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.plugins.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.openraven.magpie.api.MagpieEnvelope;
import io.openraven.magpie.api.TerminalPlugin;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;

public class JSONPlugin
implements TerminalPlugin<Void> {
    private final Object SYNC = new Object();
    private static final String ID = "magpie.json";
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).findAndRegisterModules();
    private Logger logger;
    private JsonGenerator generator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(MagpieEnvelope env) {
        Object object = this.SYNC;
        synchronized (object) {
            try {
                this.generator.writeObject((Object)env.getContents());
            }
            catch (IOException ex) {
                this.logger.warn("Couldn't process envelope contents", (Throwable)ex);
            }
        }
    }

    public String id() {
        return ID;
    }

    public void init(Void unused, Logger logger) {
        this.logger = logger;
        try {
            this.generator = new JsonFactory().createGenerator((OutputStream)System.out, JsonEncoding.UTF8).setCodec((ObjectCodec)MAPPER);
            this.generator.writeStartArray();
        }
        catch (IOException ex) {
            throw new RuntimeException("JSON generator error", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.SYNC;
        synchronized (object) {
            try {
                this.generator.writeEndArray();
                this.generator.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("JSON generator error", ex);
            }
        }
    }

    public Class<Void> configType() {
        return null;
    }
}

