/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ec2;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.ec2.model.NetworkAcl;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsec2networkacl")
public class Ec2NetworkAcl
extends AWSResource {
    protected static final String TABLE_NAME = "awsec2networkacl";
    public static final String RESOURCE_TYPE = "AWS::EC2::NetworkAcl";

    public Ec2NetworkAcl() {
        this.resourceType = RESOURCE_TYPE;
    }

    public Ec2NetworkAcl(String accountId, String region, NetworkAcl networkAcl) {
        this.arn = String.format("arn:aws:ec2:%s:%s:network-acl/%s", region, accountId, networkAcl.networkAclId());
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.resourceId = networkAcl.networkAclId();
        this.resourceName = networkAcl.networkAclId();
        this.resourceType = RESOURCE_TYPE;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{networkAcl});
    }
}

