/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ec2;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.ec2.model.SecurityGroup;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsec2securitygroup")
public class EC2SecurityGroup
extends AWSResource {
    protected static final String TABLE_NAME = "awsec2securitygroup";
    public static final String RESOURCE_TYPE = "AWS::EC2::SecurityGroup";

    public EC2SecurityGroup() {
        this.resourceType = RESOURCE_TYPE;
    }

    public EC2SecurityGroup(String accountId, String region, SecurityGroup securityGroup) {
        this.arn = String.format("arn:aws:ec2:%s:%s:security-group/%s", region, accountId, securityGroup.groupId());
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.resourceId = securityGroup.groupId();
        this.resourceName = securityGroup.groupName();
        this.resourceType = RESOURCE_TYPE;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{securityGroup});
    }

    public static class WhoisLookupException
    extends Exception {
        public WhoisLookupException(String message) {
            super(message);
        }
    }

    public static class OwnerCIDR {
        public String cidr;
        public String owner;
        public String ownerNetrange;
        public boolean isBadCidr;

        public OwnerCIDR() {
        }

        public OwnerCIDR(String cidr, String owner, String ownerNetrange, boolean isBadCidr) {
            this.cidr = cidr;
            this.owner = owner;
            this.ownerNetrange = ownerNetrange;
            this.isBadCidr = isBadCidr;
        }
    }
}

