/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.dynamodb;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.dynamodb.model.TableDescription;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsdynamodbtable")
public class DynamoDbTable
extends AWSResource {
    protected static final String TABLE_NAME = "awsdynamodbtable";
    public static final String RESOURCE_TYPE = "AWS::DynamoDB::Table";

    public DynamoDbTable() {
        this.resourceType = RESOURCE_TYPE;
    }

    public DynamoDbTable(String account, String region, TableDescription table) {
        this.awsAccountId = account;
        this.awsRegion = region;
        this.resourceName = table.tableName();
        this.resourceId = table.tableId();
        this.arn = table.tableArn();
        this.createdIso = table.creationDateTime();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{table});
        this.resourceType = RESOURCE_TYPE;
    }
}

