/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.athena;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.athena.model.DataCatalogSummary;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsathenadatacatalog")
public class AthenaDataCatalog
extends AWSResource {
    protected static final String TABLE_NAME = "awsathenadatacatalog";
    public static final String RESOURCE_TYPE = "AWS::Athena::DataCatalog";

    public AthenaDataCatalog() {
        this.resourceType = RESOURCE_TYPE;
    }

    public AthenaDataCatalog(String account, String regionId, DataCatalogSummary dataCatalogSummary) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = String.format("arn:aws:athena:%s:%s:datacatalog/%s", regionId, account, dataCatalogSummary.catalogName());
        this.resourceName = dataCatalogSummary.catalogName();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{dataCatalogSummary});
        this.resourceType = RESOURCE_TYPE;
    }
}

