/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ssm;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Table;
import software.amazon.awssdk.services.ssm.model.InstanceInformation;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Table(name="awsssminstance")
public class SSMInstance
extends AWSResource {
    protected static final String TABLE_NAME = "awsssminstance";
    public static final String RESOURCE_TYPE = "AWS::SSM::Instance";

    public SSMInstance() {
        this.resourceType = RESOURCE_TYPE;
    }

    public SSMInstance(String account, String regionId, InstanceInformation instanceInformation) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = String.format("arn:aws:ec2:%s:instance/%s", regionId, instanceInformation.instanceId());
        this.resourceName = instanceInformation.name();
        this.resourceId = instanceInformation.instanceId();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{instanceInformation});
        this.resourceType = RESOURCE_TYPE;
    }
}

