/*-
 * #%L
 * Magpie API
 * %%
 * Copyright (C) 2021 Open Raven Inc
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
/*
 * Copyright 2021 Open Raven Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.openraven.magpie.data.aws.batch;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import software.amazon.awssdk.services.batch.model.JobQueueDetail;

@javax.persistence.Entity
@javax.persistence.Inheritance(strategy = javax.persistence.InheritanceType.TABLE_PER_CLASS)
@javax.persistence.Table(name = BatchJobQueue.TABLE_NAME)
public class BatchJobQueue extends AWSResource {

  protected static final String TABLE_NAME = "awsbatchjobqueue";
  public static final String RESOURCE_TYPE = "AWS::Batch::JobQueue";

  public BatchJobQueue() {
    this.resourceType = RESOURCE_TYPE;

  }

  public BatchJobQueue(String account, String regionId, JobQueueDetail jobQueue) {
    this.awsRegion = regionId;
    this.awsAccountId = account;
    this.arn = jobQueue.jobQueueArn();
    this.resourceName = jobQueue.jobQueueName();
    this.configuration = PayloadUtils.update(jobQueue);
    this.resourceType = RESOURCE_TYPE;
  }
}
