/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.data.utils.JacksonMapper;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter(autoApply=true)
public class JsonConverter
implements AttributeConverter<JsonNode, String> {
    private static final Logger LOG = LoggerFactory.getLogger(JsonConverter.class);
    private static final ObjectMapper MAPPER = JacksonMapper.getJacksonMapper();

    public String convertToDatabaseColumn(JsonNode jsonNode) {
        if (jsonNode == null) {
            LOG.debug("jsonNode is null return null as database column");
            return null;
        }
        try {
            return MAPPER.writeValueAsString((Object)jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Unable to serialize JsonNode: " + jsonNode, e);
        }
    }

    public JsonNode convertToEntityAttribute(String jsonStr) {
        if (jsonStr == null || jsonStr.isEmpty()) {
            LOG.debug("json string is empty return null as entity attribute");
            return null;
        }
        try {
            return MAPPER.readTree(jsonStr);
        }
        catch (JsonProcessingException e) {
            LOG.error("Unable to read jsonb tree from the DB", (Throwable)e);
            return null;
        }
    }
}

