/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.shared;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.openraven.magpie.data.utils.JacksonMapper;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PayloadUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PayloadUtils.class);
    private static final ObjectMapper objectMapper = JacksonMapper.getJacksonMapper();
    private static final JsonNode NULL_NODE = objectMapper.nullNode();

    public static <R> void getAwsResponse(Supplier<R> fn, Consumer<R> resp, Consumer<JsonNode> noresp) throws SdkClientException, SdkServiceException {
        try {
            R ret = fn.get();
            resp.accept(ret);
        }
        catch (SdkServiceException ex) {
            if (ex.statusCode() >= 400 && ex.statusCode() < 500) {
                noresp.accept(NULL_NODE);
            }
            throw ex;
        }
    }

    public static JsonNode update(@Nullable JsonNode payload, ToCopyableBuilder ... responsesToAdd) {
        for (ToCopyableBuilder responseToAdd : responsesToAdd) {
            if (responseToAdd == null) continue;
            JsonNode jsonNode = (JsonNode)objectMapper.convertValue((Object)responseToAdd.toBuilder(), JsonNode.class);
            payload = PayloadUtils.update(payload, jsonNode);
        }
        return payload;
    }

    public static JsonNode update(@Nullable JsonNode payload, Map<String, Object> mappedResponsesToAdd) {
        for (Map.Entry<String, Object> responseToAdd : mappedResponsesToAdd.entrySet()) {
            ObjectNode nodeToAdd = objectMapper.createObjectNode();
            if (responseToAdd.getValue() instanceof ToCopyableBuilder) {
                nodeToAdd.set(responseToAdd.getKey(), (JsonNode)objectMapper.convertValue((Object)((ToCopyableBuilder)responseToAdd.getValue()).toBuilder(), JsonNode.class));
            } else {
                nodeToAdd.set(responseToAdd.getKey(), (JsonNode)objectMapper.convertValue(responseToAdd.getValue(), JsonNode.class));
            }
            payload = PayloadUtils.update(payload, new JsonNode[]{nodeToAdd});
        }
        return payload;
    }

    public static JsonNode update(@Nullable JsonNode payload, JsonNode ... nodesToAdd) {
        for (JsonNode nodeToAdd : nodesToAdd) {
            if (nodeToAdd == null) continue;
            try {
                if (payload != null) {
                    payload = (JsonNode)objectMapper.readerForUpdating((Object)payload).readValue(nodeToAdd);
                    continue;
                }
                payload = nodeToAdd;
            }
            catch (IOException e) {
                LOG.warn("Unable to add extra data {}", (Object)nodeToAdd, (Object)e);
            }
        }
        return payload;
    }

    public static JsonNode update(ToCopyableBuilder ... responsesToAdd) {
        return PayloadUtils.update(null, responsesToAdd);
    }
}

