/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.efs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.efs.model.FileSystemDescription;
import software.amazon.awssdk.services.efs.model.Tag;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsefsfilesystem")
public class EfsFileSystem
extends AWSResource {
    protected static final String TABLE_NAME = "awsefsfilesystem";
    public static final String RESOURCE_TYPE = "AWS::EFS::FileSystem";

    public EfsFileSystem() {
        this.resourceType = RESOURCE_TYPE;
    }

    public EfsFileSystem(String region, FileSystemDescription fileSystem) {
        this.resourceId = fileSystem.fileSystemId();
        this.awsAccountId = fileSystem.ownerId();
        this.awsRegion = region;
        this.arn = String.format("arn:aws:elasticfilesystem:%s:%s:file-system/%s", region, fileSystem.ownerId(), fileSystem.fileSystemId());
        this.resourceName = fileSystem.name();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{fileSystem});
        this.resourceType = RESOURCE_TYPE;
        this.createdIso = fileSystem.creationTime();
    }

    public EfsFileSystem(String region, FileSystemDescription fileSystem, ObjectMapper objectMapper) {
        this(region, fileSystem);
        this.tags = (JsonNode)objectMapper.convertValue(fileSystem.tags().stream().collect(Collectors.toMap(Tag::key, Tag::value)), JsonNode.class);
    }
}

