/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.ec2storage;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.ec2.model.Snapshot;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsec2snapshot")
public class EC2Snapshot
extends AWSResource {
    protected static final String TABLE_NAME = "awsec2snapshot";
    public static final String RESOURCE_TYPE = "AWS::EC2::Snapshot";

    public EC2Snapshot() {
        this.resourceType = RESOURCE_TYPE;
    }

    public EC2Snapshot(String accountId, String region, Snapshot snapshot) {
        this.arn = String.format("arn:aws:ec2:%s:%s:snapshot/%s", region, accountId, snapshot.snapshotId());
        this.awsAccountId = accountId;
        this.awsRegion = region;
        this.resourceId = snapshot.snapshotId();
        this.resourceType = RESOURCE_TYPE;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{snapshot});
    }
}

