/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.cloudfront;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.cloudfront.model.DistributionSummary;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awscloudfrontdistribution")
public class CloudFrontDistribution
extends AWSResource {
    protected static final String TABLE_NAME = "awscloudfrontdistribution";
    public static final String RESOURCE_TYPE = "AWS::CloudFront::Distribution";

    public CloudFrontDistribution() {
        this.resourceType = RESOURCE_TYPE;
    }

    public CloudFrontDistribution(String account, String regionId, DistributionSummary fileSystem) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = fileSystem.arn();
        this.resourceId = fileSystem.id();
        this.resourceName = fileSystem.domainName();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{fileSystem});
        this.resourceType = RESOURCE_TYPE;
        this.updatedIso = fileSystem.lastModifiedTime();
    }
}

