/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.batch;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.batch.model.JobQueueDetail;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsbatchjobqueue")
public class BatchJobQueue
extends AWSResource {
    protected static final String TABLE_NAME = "awsbatchjobqueue";
    public static final String RESOURCE_TYPE = "AWS::Batch::JobQueue";

    public BatchJobQueue() {
        this.resourceType = RESOURCE_TYPE;
    }

    public BatchJobQueue(String account, String regionId, JobQueueDetail jobQueue) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = jobQueue.jobQueueArn();
        this.resourceName = jobQueue.jobQueueName();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{jobQueue});
        this.resourceType = RESOURCE_TYPE;
    }
}

