/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openraven.magpie.data.aws.AWSResource;
import java.time.Instant;

public class Envelope {
    @JsonIgnore
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public String integration;
    public String discoverySession;
    public String ts;
    public AWSResource contents;

    public Envelope() {
    }

    public Envelope(String integration, String discoverySession, String ts, AWSResource contents) {
        this.integration = integration;
        this.discoverySession = discoverySession;
        this.ts = ts;
        this.contents = contents;
        this.contents.discoverySessionId = discoverySession;
        DiscoveryMeta metaData = new DiscoveryMeta(discoverySession);
        this.contents.discoveryMeta = MAPPER.valueToTree((Object)metaData);
    }

    public String getIntegration() {
        return this.integration;
    }

    public void setIntegration(String integration) {
        this.integration = integration;
    }

    public String getDiscoverySession() {
        return this.discoverySession;
    }

    public void setDiscoverySession(String discoverySession) {
        this.discoverySession = discoverySession;
    }

    public String getTs() {
        return this.ts;
    }

    public void setTs(String ts) {
        this.ts = ts;
    }

    public AWSResource getContents() {
        return this.contents;
    }

    public void setContents(AWSResource contents) {
        this.contents = contents;
    }

    private static class DiscoveryMeta {
        public String discoverySessionId;
        public String updatedIso;

        public DiscoveryMeta(String discoverySessionId) {
            this.discoverySessionId = discoverySessionId;
            this.updatedIso = Instant.now().toString();
        }
    }
}

