/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.emr;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import software.amazon.awssdk.services.emr.model.ClusterSummary;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsemrcluster")
public class EmrCluster
extends AWSResource {
    protected static final String TABLE_NAME = "awsemrcluster";
    public static final String RESOURCE_TYPE = "AWS::EMR::Cluster";

    public EmrCluster() {
        this.resourceType = RESOURCE_TYPE;
    }

    public EmrCluster(String account, String regionId, ClusterSummary cluster) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = String.format("arn:aws:emr:::cluster/%s", cluster.id());
        this.resourceId = cluster.id();
        this.resourceName = cluster.name();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{cluster});
        this.resourceType = RESOURCE_TYPE;
        this.createdIso = cluster.status().timeline().creationDateTime();
    }
}

