/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.storagegateway;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import software.amazon.awssdk.services.storagegateway.model.GatewayInfo;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awsstoragegatewaygateway")
public class StorageGatewayGateway
extends AWSResource {
    protected static final String TABLE_NAME = "awsstoragegatewaygateway";
    public static final String RESOURCE_TYPE = "AWS::StorageGateway::Gateway";

    public StorageGatewayGateway() {
        this.resourceType = RESOURCE_TYPE;
    }

    public StorageGatewayGateway(String account, String regionId, GatewayInfo gateway) {
        this.awsRegion = regionId;
        this.awsAccountId = account;
        this.arn = gateway.gatewayARN();
        this.resourceName = gateway.gatewayName();
        this.resourceId = gateway.gatewayId();
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{gateway});
        this.resourceType = RESOURCE_TYPE;
    }
}

