/*
 * Decompiled with CFR 0.152.
 */
package io.openraven.magpie.data.aws.s3objects;

import io.openraven.magpie.data.aws.AWSResource;
import io.openraven.magpie.data.aws.shared.PayloadUtils;
import jakarta.persistence.Entity;
import jakarta.persistence.Inheritance;
import jakarta.persistence.InheritanceType;
import jakarta.persistence.Table;
import java.util.Map;
import software.amazon.awssdk.services.s3.model.S3Object;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Entity
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@Table(name="awss3bucketobject")
public class S3BucketObject
extends AWSResource {
    protected static final String TABLE_NAME = "awss3bucketobject";
    public static final String RESOURCE_TYPE = "AWS::S3::BucketObject";
    public static final String BUCKET_NAME_KEY = "BucketName";

    public S3BucketObject() {
        this.resourceType = RESOURCE_TYPE;
    }

    public S3BucketObject(String account, String region, String bucketName, S3Object s3Object) {
        this.awsAccountId = account;
        this.awsRegion = region;
        String objectKey = s3Object.key();
        String objectLocationWithinBucket = String.format("%s/%s", bucketName, objectKey);
        this.arn = "arn:aws:s3:::" + objectLocationWithinBucket;
        this.resourceName = objectKey;
        this.resourceId = objectLocationWithinBucket;
        this.configuration = PayloadUtils.update(new ToCopyableBuilder[]{s3Object});
        this.resourceType = RESOURCE_TYPE;
        this.createdIso = s3Object.lastModified();
        this.supplementaryConfiguration = PayloadUtils.update(this.supplementaryConfiguration, Map.of(BUCKET_NAME_KEY, bucketName));
    }
}

